/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.richfaces;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.jsf.richfaces.Richfaces4Implementation;
import org.netbeans.modules.web.jsf.richfaces.ui.Richfaces4CustomizerPanelVisual;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class Richfaces4Customizer
implements JsfComponentCustomizer {
    Richfaces4CustomizerPanelVisual panel;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    boolean initialize = true;
    public static final Logger LOGGER = Logger.getLogger(Richfaces4Customizer.class.getName());

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new Richfaces4CustomizerPanelVisual(new PanelChangeListener());
            this.panel.initLibraries(true);
        }
        return this.panel;
    }

    public boolean isValid() {
        Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
        String string = preferences.get("base-library", "");
        if (LibraryManager.getDefault().getLibrary(string) != null) {
            return true;
        }
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !Richfaces4Customizer.isValidRichfacesLibrary(list = library.getContent("classpath"))) continue;
            return true;
        }
        return false;
    }

    public String getWarningMessage() {
        return this.panel.getWarningMessage();
    }

    public String getErrorMessage() {
        return this.panel.getErrorMessage();
    }

    public void saveConfiguration() {
        Preferences preferences = Richfaces4Implementation.getRichfacesPreferences();
        preferences.put("base-library", this.panel.getRichFacesLibrary());
    }

    public static List<Library> getRichfacesLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List list;
            if (!"j2se".equals(library.getType()) || !Richfaces4Customizer.isValidRichfacesLibrary(list = library.getContent("classpath"))) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public static boolean isValidRichfacesLibrary(List<URL> list) {
        Set<Map.Entry<String, String>> set = Richfaces4Implementation.RF_LIBRARIES.entrySet();
        for (Map.Entry<String, String> entry : set) {
            try {
                if (Util.containsClass(list, (String)entry.getKey())) continue;
                return false;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
                return false;
            }
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return this.panel.getHelpCtx();
    }

    private class PanelChangeListener
    implements ChangeListener {
        private PanelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Richfaces4Customizer.this.changeSupport.fireChange();
        }
    }
}

