/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.spi.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.utilities.ui.WSHandlerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MessageHandlerPanel
extends JPanel {
    private Project project;
    private List<String> handlerClasses;
    private boolean isJaxWS;
    private String componentName;
    private boolean isChanged;
    private int protocolIndex = -1;
    private static final String LOGICAL_TYPE = "Logical";
    private static final String PROTOCOL_TYPE = "Protocol";
    private JButton addBtn;
    private JButton downBtn;
    private JTable handlerTable;
    private DefaultTableModel handlerTableModel;
    private JScrollPane jScrollPane2;
    private JButton removeBtn;
    private JButton upBtn;

    public MessageHandlerPanel(Project project, List<String> handlerClasses, boolean isJaxWS, String componentName) {
        this.project = project;
        this.handlerClasses = handlerClasses;
        this.isJaxWS = isJaxWS;
        this.componentName = componentName;
        this.initComponents();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.populateHandlers();
        this.isChanged = false;
        this.handlerTable.getColumnModel().getColumn(1).setCellRenderer(new TypeCellRenderer());
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public TableModel getHandlerTableModel() {
        return this.handlerTableModel;
    }

    private FileObject getFileObjectOfClass(String className) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroups.length; ++i) {
            FileObject rootFolder = sourceGroups[i].getRootFolder();
            FileObject classFileObject = rootFolder.getFileObject(className.replaceAll("\\.", "/") + ".java");
            if (classFileObject == null) continue;
            return classFileObject;
        }
        return null;
    }

    private void populateHandlers() {
        ListIterator<String> listIterator = this.handlerClasses.listIterator();
        final int[] handlerType = new int[]{1};
        while (listIterator.hasNext()) {
            String handlerClass = listIterator.next();
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    handlerType[0] = WSHandlerDialog.getHandlerType(controller, MessageHandlerPanel.this.isJaxWS);
                }

                public void cancel() {
                }
            };
            FileObject classFO = this.getFileObjectOfClass(handlerClass);
            if (classFO != null) {
                try {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)classFO);
                    javaSource.runUserActionTask((Task)task, true);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (handlerType[0] == 1) {
                ++this.protocolIndex;
            }
            this.handlerTableModel.addRow(new Object[]{handlerClass, handlerType[0]});
        }
        if (this.handlerTableModel.getRowCount() > 0) {
            this.handlerTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.upBtn = new JButton();
        this.downBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.handlerTable = new HandlerTable();
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"Add_DotDotDot_label"));
        this.addBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"Remove_label"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"LBL_Move_Up"));
        this.upBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Move_Up"));
        this.upBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageHandlerPanel.this.moveUpHandler(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtn, (String)NbBundle.getMessage(MessageHandlerPanel.class, (String)"LBL_Move_Down"));
        this.downBtn.setToolTipText(NbBundle.getMessage(MessageHandlerPanel.class, (String)"HINT_Move_Down"));
        this.downBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageHandlerPanel.this.moveDownHandler(evt);
            }
        });
        this.handlerTableModel = new HandlerTableModel(new String[]{NbBundle.getMessage(MessageHandlerPanel.class, (String)"HEADING_HANDLERS"), NbBundle.getMessage(MessageHandlerPanel.class, (String)"HEADING_TYPE")}, 0);
        this.handlerTable.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.handlerTable.setModel(this.handlerTableModel);
        this.jScrollPane2.setViewportView(this.handlerTable);
        this.handlerTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessageHandlerPanel.class, (String)"ACSD_MessageHandlerTable"));
        this.handlerTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageHandlerPanel.class, (String)"ACSD_MessageHandlerTable"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addBtn, -1, 190, Short.MAX_VALUE).addComponent(this.upBtn, -1, 190, Short.MAX_VALUE).addComponent(this.removeBtn, -1, 190, Short.MAX_VALUE).addComponent(this.downBtn, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeBtn).addGap(23, 23, 23).addComponent(this.upBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downBtn)).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 219, Short.MAX_VALUE)).addContainerGap()));
    }

    private void moveUpHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        Integer type = (Integer)this.handlerTableModel.getValueAt(selectedRow, 1);
        if (type == 2 && selectedRow - 1 == this.protocolIndex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"TXT_CannotMoveUp", (Object)2)));
            return;
        }
        int newSelectedRow = selectedRow - 1;
        this.handlerTableModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.handlerTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        Integer type = (Integer)this.handlerTableModel.getValueAt(selectedRow, 1);
        if (type == 1 && selectedRow == this.protocolIndex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"TXT_CannotMoveDown", (Object)2)));
            return;
        }
        int newSelectedRow = selectedRow + 1;
        this.handlerTableModel.moveRow(selectedRow, selectedRow, newSelectedRow);
        this.handlerTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
        this.isChanged = true;
    }

    private int getSelectedRow() {
        ListSelectionModel lsm = this.handlerTable.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        }
        return lsm.getMinSelectionIndex();
    }

    class TypeCellRenderer
    implements TableCellRenderer {
        TypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer type;
            JLabel typeLabel = new JLabel();
            if (column == 1 && (type = (Integer)value) != null) {
                if (type == 1) {
                    typeLabel.setText(MessageHandlerPanel.LOGICAL_TYPE);
                } else {
                    typeLabel.setText(MessageHandlerPanel.PROTOCOL_TYPE);
                }
            }
            return typeLabel;
        }
    }

    class HandlerTableModel
    extends DefaultTableModel {
        public HandlerTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class HandlerListSelectionListener
    implements ListSelectionListener {
        HandlerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selectedRow = MessageHandlerPanel.this.getSelectedRow();
                if (selectedRow == 0) {
                    MessageHandlerPanel.this.upBtn.setEnabled(false);
                } else if (!MessageHandlerPanel.this.upBtn.isEnabled()) {
                    MessageHandlerPanel.this.upBtn.setEnabled(true);
                }
                if (selectedRow == MessageHandlerPanel.this.handlerTableModel.getRowCount() - 1) {
                    MessageHandlerPanel.this.downBtn.setEnabled(false);
                } else if (!MessageHandlerPanel.this.downBtn.isEnabled()) {
                    MessageHandlerPanel.this.downBtn.setEnabled(true);
                }
            }
        }
    }

    class HandlerTable
    extends JTable {
        public HandlerTable() {
            JTableHeader header = this.getTableHeader();
            header.setResizingAllowed(false);
            header.setReorderingAllowed(false);
            ListSelectionModel model = this.getSelectionModel();
            model.setSelectionMode(1);
            model.addListSelectionListener(new HandlerListSelectionListener());
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        DialogDescriptor dlgDesc = null;

        AddButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Map<String, Integer> selectedClasses;
            WSHandlerDialog wsHandlerDialog = new WSHandlerDialog(MessageHandlerPanel.this.project, MessageHandlerPanel.this.isJaxWS);
            wsHandlerDialog.show();
            if (wsHandlerDialog.okButtonPressed() && (selectedClasses = wsHandlerDialog.getSelectedClasses()).size() > 0) {
                int newSelectedRow = 0;
                Set<Map.Entry<String, Integer>> classes = selectedClasses.entrySet();
                for (Map.Entry<String, Integer> selectedClass : classes) {
                    Integer type = selectedClasses.get(selectedClass.getKey());
                    if (type == 1) {
                        MessageHandlerPanel.this.handlerTableModel.insertRow(++MessageHandlerPanel.this.protocolIndex, new Object[]{selectedClass.getKey(), type});
                        newSelectedRow = MessageHandlerPanel.this.protocolIndex;
                        continue;
                    }
                    MessageHandlerPanel.this.handlerTableModel.addRow(new Object[]{selectedClass.getKey(), type});
                    newSelectedRow = MessageHandlerPanel.this.handlerTableModel.getRowCount() - 1;
                }
                MessageHandlerPanel.this.handlerTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
                MessageHandlerPanel.this.isChanged = true;
            }
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = MessageHandlerPanel.this.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            String className = (String)MessageHandlerPanel.this.handlerTableModel.getValueAt(selectedRow, 0);
            if (this.confirmDeletion(className)) {
                Integer type = (Integer)MessageHandlerPanel.this.handlerTableModel.getValueAt(selectedRow, 1);
                if (type == 1) {
                    --MessageHandlerPanel.this.protocolIndex;
                }
                MessageHandlerPanel.this.handlerTableModel.removeRow(selectedRow);
                int newSelectedRow = selectedRow - 1;
                MessageHandlerPanel.this.handlerTable.getSelectionModel().setSelectionInterval(newSelectedRow, newSelectedRow);
                MessageHandlerPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String className) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageHandlerPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)className, (Object)MessageHandlerPanel.this.componentName), NbBundle.getMessage(MessageHandlerPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

