/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.NavigatorView;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.HelpConstants;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractHelp
extends Help
implements HelpConstants {
    private Lookup.Result<HelpSet> helpsets = null;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    protected AbstractHelp() {
    }

    protected final Collection<? extends HelpSet> getHelpSets() {
        if (this.helpsets == null) {
            Installer.log.fine("searching for instances of HelpSet...");
            this.helpsets = Lookup.getDefault().lookupResult(HelpSet.class);
            this.helpsets.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    AbstractHelp.this.helpSetsChanged();
                }
            });
            this.fireChangeEvent();
        }
        Collection<? extends HelpSet> c = this.helpsets.allInstances();
        if (Installer.log.isLoggable(Level.FINE)) {
            ArrayList<String> l = new ArrayList<String>(Math.min(1, c.size()));
            for (HelpSet helpSet : c) {
                l.add(helpSet.getTitle());
            }
            Installer.log.fine("listing helpsets: " + l);
        }
        assert ((c = AbstractHelp.selectSafeHelpSets(c)) != null);
        return c;
    }

    private static Collection<? extends HelpSet> selectSafeHelpSets(Collection<? extends HelpSet> sets) {
        ArrayList<HelpSet> safeSets = new ArrayList<HelpSet>(sets.size());
        for (HelpSet helpSet : sets) {
            if (!AbstractHelp.isSafe(helpSet)) continue;
            safeSets.add(helpSet);
        }
        return safeSets;
    }

    private static boolean isSafe(HelpSet hs) {
        for (NavigatorView nv : hs.getNavigatorViews()) {
            if (!"Search".equals(nv.getName())) continue;
            String engine = (String)nv.getParameters().get("engine");
            if (engine == null) {
                engine = HelpUtilities.getDefaultQueryEngine();
            }
            assert (engine != null);
            try {
                AbstractHelp.checkSearchEngineCanBeCreated(engine, hs, nv);
            }
            catch (Exception e) {
                Installer.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return false;
            }
        }
        return true;
    }

    private static void checkSearchEngineCanBeCreated(String engine, HelpSet hs, NavigatorView nv) throws Exception {
        Class<?> klass;
        URL base = hs.getHelpSetURL();
        ClassLoader loader = hs.getLoader();
        try {
            klass = loader == null ? Class.forName(engine) : loader.loadClass(engine);
        }
        catch (Throwable t) {
            String p = "Could not load engine named {0} for Help Set {1} with url {2}";
            String msg = MessageFormat.format(p, engine, hs.getTitle(), base);
            throw new Exception(msg, t);
        }
        Constructor<?> konstructor = null;
        try {
            Class[] types = new Class[]{URL.class, Hashtable.class};
            konstructor = klass.getConstructor(types);
        }
        catch (Throwable t) {
            String p = "Could not find constructor for {0} for Help Set {1} with url {2}";
            String msg = MessageFormat.format(p, engine, hs.getTitle(), base);
            throw new Exception(msg, t);
        }
        try {
            Object[] args = new Object[]{base, nv.getParameters()};
            konstructor.newInstance(args);
        }
        catch (Throwable t) {
            String p = "Exception while creating engine {0} for Help Set {1} with url {2}";
            String msg = MessageFormat.format(p, engine, hs.getTitle(), base);
            throw new Exception(msg, t);
        }
    }

    protected final boolean helpSetsReady() {
        return this.helpsets != null;
    }

    protected final boolean shouldMerge(HelpSet hs) {
        Boolean b = (Boolean)hs.getKeyData("OpenIDE", "mergeIntoMaster");
        return b == null || b != false;
    }

    protected void helpSetsChanged() {
        Installer.log.fine("helpSetsChanged");
        this.fireChangeEvent();
    }

    @Override
    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    @Override
    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private final void fireChangeEvent() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractHelp.this.fireChangeEvent();
                }
            });
            return;
        }
        Installer.log.fine("Help.stateChanged");
        this.cs.fireChange();
    }
}

