/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;

public abstract class EditorViewFactory {
    private static List<Factory> viewFactoryFactories = new ArrayList<Factory>(3);
    private final DocumentView docView;
    private final JTextComponent component;
    private ViewBuilder viewBuilder;
    private final ListenerList<EditorViewFactoryListener> listenerList = new ListenerList();

    public static void registerFactory(Factory factory) {
        viewFactoryFactories.add(factory);
        Collections.sort(viewFactoryFactories, new Comparator<Factory>(){

            @Override
            public int compare(Factory f0, Factory f1) {
                return f0.importance() - f1.importance();
            }
        });
    }

    public static List<Factory> factories() {
        return Collections.unmodifiableList(viewFactoryFactories);
    }

    protected EditorViewFactory(View documentView) {
        assert (documentView instanceof DocumentView) : "documentView=" + documentView + " is not instance of " + DocumentView.class.getName();
        this.docView = (DocumentView)documentView;
        this.component = this.docView.getTextComponent();
    }

    protected final JTextComponent textComponent() {
        return this.component;
    }

    protected final Document document() {
        return this.docView.getDocument();
    }

    public abstract void restart(int var1, int var2);

    public abstract int nextViewStartOffset(int var1);

    public abstract EditorView createView(int var1, int var2);

    public abstract int viewEndOffset(int var1, int var2);

    public abstract void finishCreation();

    public void addEditorViewFactoryListener(EditorViewFactoryListener listener) {
        this.listenerList.add((EventListener)listener);
    }

    public void removeEditorViewFactoryListener(EditorViewFactoryListener listener) {
        this.listenerList.remove((EventListener)listener);
    }

    protected void fireEvent(List<Change> changes) {
        this.fireEvent(changes, 0);
    }

    protected void fireEvent(List<Change> changes, int priority) {
        EditorViewFactoryEvent evt = new EditorViewFactoryEvent(this, changes, priority);
        for (EditorViewFactoryListener listener : this.listenerList.getListeners()) {
            listener.viewFactoryChanged(evt);
        }
    }

    public static Change createChange(int startOffset, int endOffset) {
        return new Change(startOffset, endOffset);
    }

    public static List<Change> createSingleChange(int startOffset, int endOffset) {
        return Collections.singletonList(EditorViewFactory.createChange(startOffset, endOffset));
    }

    public void offsetRepaint(int startOffset, int endOffset) {
        this.docView.offsetRepaint(startOffset, endOffset);
    }

    protected final void notifyStaleCreation() {
        if (this.viewBuilder != null) {
            this.viewBuilder.notifyStaleCreation();
        }
    }

    void setViewBuilder(ViewBuilder viewBuilder) {
        this.viewBuilder = viewBuilder;
    }

    public static interface Factory {
        public EditorViewFactory createEditorViewFactory(View var1);

        public int importance();
    }

    public static final class Change {
        private int startOffset;
        private int endOffset;

        Change(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            return "<" + this.getStartOffset() + "," + this.getEndOffset() + ">";
        }
    }
}

