/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.io.IOException;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DebuggerAnnotation
extends Annotation
implements Lookup.Provider {
    private final Line line;
    private final String type;
    private final JPDAThread thread;

    DebuggerAnnotation(String type, Line line, JPDAThread thread) {
        this.type = type;
        this.line = line;
        this.thread = thread;
        if ("Breakpoint".equals(type)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + type + ". Please report to bug #169096."));
        }
        this.attach((Annotatable)line);
    }

    DebuggerAnnotation(String type, Line.Part linePart) {
        this.type = type;
        this.line = linePart.getLine();
        this.thread = null;
        if ("Breakpoint".equals(type)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + type + ". Please report to bug #169096."));
        }
        this.attach((Annotatable)linePart);
    }

    DebuggerAnnotation(String type, AttributeSet attrs, int start, int end, FileObject fo) {
        this.type = type;
        this.line = null;
        this.thread = null;
        if ("Breakpoint".equals(type)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + type + ". Please report to bug #169096."));
        }
        this.attach(new HighlightAnnotatable(attrs, start, end, fo));
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type == "CurrentPC") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_PC");
        }
        if (this.type == "CurrentExpressionLine") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_EXP_LINE");
        }
        if (this.type == "CallSite") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_CALLSITE");
        }
        if (this.type == "OtherThread") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_OTHER_THREAD", (Object)this.thread.getName());
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown annotation type '" + this.type + "'."));
        return null;
    }

    static synchronized OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(DebuggerAnnotation.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, true);
            doc.putProperty(DebuggerAnnotation.class, bag);
        }
        return bag;
    }

    public Lookup getLookup() {
        if (this.thread == null) {
            return Lookup.EMPTY;
        }
        return Lookups.singleton((Object)this.thread);
    }

    private static final class HighlightAnnotatable
    extends Annotatable {
        private AttributeSet attrs;
        private int start;
        private int end;
        private Document doc;

        public HighlightAnnotatable(AttributeSet attrs, int start, int end, FileObject fo) {
            this.attrs = attrs;
            this.start = start;
            this.end = end;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                this.doc = ec.getDocument();
                if (this.doc == null) {
                    try {
                        this.doc = ec.openDocument();
                    }
                    catch (IOException ioex) {}
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }

        public String getText() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation anno) {
            Class<DebuggerAnnotation> clazz = DebuggerAnnotation.class;
            synchronized (DebuggerAnnotation.class) {
                if (this.doc != null) {
                    OffsetsBag bag = DebuggerAnnotation.getHighlightsBag(this.doc);
                    bag.addHighlight(this.start, this.end, this.attrs);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation anno) {
            Class<DebuggerAnnotation> clazz = DebuggerAnnotation.class;
            synchronized (DebuggerAnnotation.class) {
                if (this.doc != null) {
                    OffsetsBag bag = DebuggerAnnotation.getHighlightsBag(this.doc);
                    bag.removeHighlights(this.start, this.end, false);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

