/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.field;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractDecoratorAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.FieldModelAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class InjectionPointAnalyzer
extends AbstractDecoratorAnalyzer<Void>
implements FieldModelAnalyzer.FieldAnalyzer {
    @Override
    public void analyze(VariableElement element, TypeMirror elementType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        try {
            if (model.isInjectionPoint(element)) {
                boolean isEvent;
                boolean isDelegate = false;
                result.requireCdiEnabled(element, model);
                this.checkInjectionPointMetadata(element, elementType, parent, model, cancel, result);
                if (cancel.get()) {
                    return;
                }
                if (!model.isDynamicInjectionPoint(element)) {
                    isDelegate = AnnotationUtil.isDelegate(element, parent, model);
                    if (!this.checkBuiltInBeans(element, elementType, model, cancel)) {
                        DependencyInjectionResult res = model.lookupInjectables(element, null);
                        this.checkResult(res, element, model, result);
                        if (isDelegate) {
                            this.analyzeDecoratedBeans(res, element, null, parent, model, result);
                        }
                    }
                }
                if (isEvent = model.isEventInjectionPoint(element)) {
                    ElementHandle modelHandle = ElementHandle.create((Element)element);
                    EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
                    if (helper != null) {
                        helper.addEventInjectionPoint(result, (VariableElement)modelHandle.resolve(result.getInfo()));
                    }
                } else {
                    if (isDelegate || AnnotationUtil.hasAnnotation(element, "javax.decorator.Delegate", (CompilationInfo)model.getCompilationController())) {
                        return;
                    }
                    ElementHandle modelHandle = ElementHandle.create((Element)element);
                    EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
                    if (helper != null) {
                        helper.addInjectionPoint(result, (VariableElement)modelHandle.resolve(result.getInfo()));
                    }
                }
            }
        }
        catch (InjectionPointDefinitionError e) {
            result.requireCdiEnabled(element, model);
            this.informInjectionPointDefError(e, element, model, result);
        }
    }

    @Override
    protected void addClassError(VariableElement element, Void fake, TypeElement decoratedBean, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError((Element)element, model, NbBundle.getMessage(InjectionPointAnalyzer.class, (String)"ERR_FinalDecoratedBean", (Object)decoratedBean.getQualifiedName().toString()));
    }

    @Override
    protected void addMethodError(VariableElement element, Void fake, TypeElement decoratedBean, Element decoratedMethod, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError((Element)element, model, NbBundle.getMessage(InjectionPointAnalyzer.class, (String)"ERR_FinalMethodDecoratedBean", (Object)decoratedBean.getQualifiedName().toString(), (Object)decoratedMethod.getSimpleName().toString()));
    }

    private void checkInjectionPointMetadata(VariableElement element, TypeMirror elementType, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        TypeElement injectionPointType = model.getCompilationController().getElements().getTypeElement("javax.enterprise.inject.spi.InjectionPoint");
        if (injectionPointType == null) {
            return;
        }
        Element varElement = model.getCompilationController().getTypes().asElement(elementType);
        if (!injectionPointType.equals(varElement)) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        List<AnnotationMirror> qualifiers = model.getQualifiers(element, true);
        AnnotationHelper helper = new AnnotationHelper((CompilationInfo)model.getCompilationController());
        Map qualifiersFqns = helper.getAnnotationsByType(qualifiers);
        boolean hasDefault = model.hasImplicitDefaultQualifier(varElement);
        if (!hasDefault && qualifiersFqns.keySet().contains("javax.enterprise.inject.Default")) {
            hasDefault = true;
        }
        if (!hasDefault || cancel.get()) {
            return;
        }
        try {
            String scope = model.getScope(parent);
            if (scope != null && !"javax.enterprise.context.Dependent".equals(scope)) {
                result.addError((Element)element, model, "ERR_WrongQualifierInjectionPointMeta");
            }
        }
        catch (CdiException e) {
            return;
        }
    }

    private void checkResult(DependencyInjectionResult res, VariableElement var, WebBeansModel model, ModelAnalyzer.Result result) {
        if (res instanceof DependencyInjectionResult.Error) {
            DependencyInjectionResult.ResultKind kind = res.getKind();
            Severity severity = Severity.WARNING;
            if (kind == DependencyInjectionResult.ResultKind.DEFINITION_ERROR) {
                severity = Severity.ERROR;
            }
            String message = ((DependencyInjectionResult.Error)res).getMessage();
            result.addNotification(severity, (Element)var, model, message);
        }
    }

    private void informInjectionPointDefError(InjectionPointDefinitionError exception, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, model, exception.getMessage());
    }
}

