/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;

public abstract class AbstractScopedAnalyzer {
    public void analyzeScope(Element element, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        try {
            String scope = model.getScope(element);
            if (cancel.get()) {
                return;
            }
            TypeElement scopeElement = model.getCompilationController().getElements().getTypeElement(scope);
            if (scopeElement == null) {
                return;
            }
            this.checkScope(scopeElement, element, model, cancel, result);
        }
        catch (CdiException e) {
            result.requireCdiEnabled(element, model);
            this.informCdiException(e, element, model, result);
        }
    }

    protected abstract void checkScope(TypeElement var1, Element var2, WebBeansModel var3, AtomicBoolean var4, ModelAnalyzer.Result var5);

    protected boolean hasTypeVarParameter(TypeMirror type) {
        if (type.getKind() == TypeKind.TYPEVAR) {
            return true;
        }
        if (type instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            for (TypeMirror typeMirror : typeArguments) {
                if (!this.hasTypeVarParameter(typeMirror)) continue;
                return true;
            }
        } else if (type instanceof ArrayType) {
            return this.hasTypeVarParameter(((ArrayType)type).getComponentType());
        }
        return false;
    }

    private void informCdiException(CdiException exception, Element element, WebBeansModel model, ModelAnalyzer.Result result) {
        result.addError(element, model, exception.getMessage());
    }
}

