/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.web.beans.analysis.CdiEditorAnalysisTask;
import org.netbeans.modules.web.beans.analysis.CdiEditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class CdiEditorAnalysisFactory
extends CdiEditorAwareJavaSourceTaskFactory {
    public CdiEditorAnalysisFactory() {
        super(JavaSource.Priority.BELOW_NORMAL);
    }

    protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
        return new CdiEditorAnalysisTask(fileObject, this);
    }

    public static ErrorDescription createError(Element subject, CompilationInfo info, String description) {
        return CdiEditorAnalysisFactory.createNotification(Severity.ERROR, subject, info, description);
    }

    public static ErrorDescription createNotification(Severity severity, Element subject, CompilationInfo info, String description) {
        return CdiEditorAnalysisFactory.createNotification(severity, subject, info, description, null);
    }

    public static ErrorDescription createNotification(Severity severity, Element subject, CompilationInfo info, String description, Fix fix) {
        Tree elementTree = info.getTrees().getTree(subject);
        return CdiEditorAnalysisFactory.createNotification(severity, elementTree, info, description, fix);
    }

    public static ErrorDescription createNotification(Severity severity, Element subject, WebBeansModel model, CompilationInfo info, String description) {
        return CdiEditorAnalysisFactory.createNotification(severity, subject, model, info, description, null);
    }

    public static ErrorDescription createNotification(Severity severity, Element subject, WebBeansModel model, CompilationInfo info, String description, Fix fix) {
        ElementHandle handle = ElementHandle.create((Element)subject);
        Element element = handle.resolve(info);
        if (element == null) {
            return null;
        }
        Tree elementTree = info.getTrees().getTree(element);
        return CdiEditorAnalysisFactory.createNotification(severity, elementTree, info, description, fix);
    }

    public static ErrorDescription createNotification(Severity severity, VariableElement element, ExecutableElement parent, WebBeansModel model, CompilationInfo info, String description, Fix fix) {
        VariableElement var = CdiEditorAnalysisFactory.resolveParameter(element, parent, info);
        if (var == null) {
            return null;
        }
        Tree elementTree = info.getTrees().getTree(var);
        return CdiEditorAnalysisFactory.createNotification(severity, elementTree, info, description, fix);
    }

    public static ErrorDescription createNotification(Severity severity, VariableElement element, ExecutableElement parent, WebBeansModel model, CompilationInfo info, String description) {
        return CdiEditorAnalysisFactory.createNotification(severity, element, parent, model, info, description, null);
    }

    public static VariableElement resolveParameter(VariableElement element, ExecutableElement parent, CompilationInfo info) {
        List<? extends VariableElement> parameters = parent.getParameters();
        int i = 0;
        for (VariableElement variableElement : parameters) {
            if (variableElement.equals(element)) break;
            ++i;
        }
        if (i == parameters.size()) {
            return null;
        }
        ElementHandle handle = ElementHandle.create((Element)parent);
        ExecutableElement executableElement = (ExecutableElement)handle.resolve(info);
        if (executableElement == null) {
            return null;
        }
        parameters = executableElement.getParameters();
        int j = 0;
        VariableElement var = null;
        for (VariableElement variableElement : parameters) {
            if (i == j) {
                var = variableElement;
            }
            ++j;
        }
        return var;
    }

    private static ErrorDescription createNotification(Severity severity, Tree tree, CompilationInfo info, String description, Fix fix) {
        List<Object> fixes = fix != null ? Collections.singletonList(fix) : Collections.emptyList();
        if (tree != null) {
            List<Integer> position = CdiEditorAnalysisFactory.getElementPosition(info, tree);
            return ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, fixes, (FileObject)info.getFileObject(), (int)position.get(0), (int)position.get(1));
        }
        return null;
    }

    public static List<Integer> getElementPosition(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startTree = ((VariableTree)tree).getType();
        }
        if (startTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(startOffset);
        result.add(endOffset);
        return result;
    }
}

