/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfArangesSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

public class DwarfRelaDebugInfoSection
extends ElfSection {
    private final Map<Long, Long> table = new HashMap<Long, Long>();
    private int abbrTableIndex = -1;
    private final Map<Long, Long> abbrTable = new HashMap<Long, Long>();

    public DwarfRelaDebugInfoSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
        try {
            Integer symtabSectionIndex;
            Integer section = reader.getSectionIndex(".debug_abbrev");
            if (section != null && (symtabSectionIndex = reader.getSymtabSectionIndex(section)) != null) {
                this.abbrTableIndex = symtabSectionIndex;
            }
            this.read();
        }
        catch (IOException ex) {
            Logger.getLogger(DwarfRelaDebugInfoSection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Long getAddend(long offset) {
        return this.table.get(offset);
    }

    public Long getAbbrAddend(long offset) {
        return this.abbrTable.get(offset);
    }

    public final DwarfArangesSection read() throws IOException {
        long sectionStart = this.header.getSectionOffset();
        long sectionEnd = this.header.getSectionSize() + sectionStart;
        this.reader.seek(sectionStart);
        int i = 0;
        while (this.reader.getFilePointer() < sectionEnd) {
            long r_offset = this.reader.read3264();
            long r_info = this.reader.read3264();
            long r_addend = this.reader.read3264();
            if (this.abbrTableIndex >= 0 && this.getR_SYM(r_info) == this.abbrTableIndex) {
                this.abbrTable.put(r_offset, r_addend);
            } else {
                this.table.put(r_offset, r_addend);
            }
            ++i;
        }
        return null;
    }

    private int getR_SYM(long r_info) {
        if (this.reader.is64Bit()) {
            return (int)(r_info >> 32);
        }
        return (int)(r_info >> 8);
    }

    private int getR_TYPE(long r_info) {
        return (int)(r_info & 0xFFL);
    }
}

