/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;

public class LddService {
    private static final boolean TRACE_READ_EXCEPTIONS = false;

    private LddService() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Not enough parameters.");
            System.err.println("Usage:");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.LddService binaryFileName");
            return;
        }
        try {
            LddService.dump(args[0], System.out);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void dump(String objFileName, PrintStream out) throws IOException, Exception {
        ElfReader.SharedLibraries res = LddService.getPubNames(objFileName);
        if (res != null) {
            for (String dll : res.getDlls()) {
                out.println("Name:" + dll);
            }
            for (String path : res.getPaths()) {
                out.println("Path:" + path);
            }
        }
    }

    public static ElfReader.SharedLibraries getPubNames(BufferedReader out) throws IOException {
        String line;
        ElfReader.SharedLibraries res = new ElfReader.SharedLibraries();
        ArrayList dlls = new ArrayList();
        ArrayList paths = new ArrayList();
        while ((line = out.readLine()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith("Name:")) {
                res.addDll(line.substring(5).trim());
                continue;
            }
            if (!line.startsWith("Path:")) continue;
            res.addPath(line.substring(5).trim());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElfReader.SharedLibraries getPubNames(String objFileName) {
        ElfReader.SharedLibraries pubNames = null;
        Dwarf dump = null;
        try {
            dump = new Dwarf(objFileName);
            pubNames = dump.readPubNames();
        }
        catch (FileNotFoundException ex) {
        }
        catch (WrongFileFormatException ex) {
        }
        catch (IOException ex) {
        }
        catch (Exception exception) {
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
        return pubNames;
    }
}

