/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import javax.swing.JComponent;
import org.netbeans.modules.php.project.ui.options.BaseOptionsPanelController;
import org.netbeans.modules.php.project.ui.options.PhpDebuggerPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PhpDebuggerPanelController
extends BaseOptionsPanelController {
    public static final String ID = "Debugger";
    private PhpDebuggerPanel debuggerPanel = null;

    @Override
    public void updateInternal() {
        this.debuggerPanel.setPort(this.getPhpOptions().getDebuggerPort());
        this.debuggerPanel.setSessionId(this.getPhpOptions().getDebuggerSessionId());
        this.debuggerPanel.setStoppedAtTheFirstLine(this.getPhpOptions().isDebuggerStoppedAtTheFirstLine());
        this.debuggerPanel.setWatchesAndEval(this.getPhpOptions().isDebuggerWatchesAndEval());
        this.debuggerPanel.setMaxStructuresDepth(this.getPhpOptions().getDebuggerMaxStructuresDepth());
        this.debuggerPanel.setMaxChildren(this.getPhpOptions().getDebuggerMaxChildren());
        this.debuggerPanel.setShowUrls(this.getPhpOptions().isDebuggerShowUrls());
        this.debuggerPanel.setShowConsole(this.getPhpOptions().isDebuggerShowConsole());
    }

    @Override
    public void applyChangesInternal() {
        this.getPhpOptions().setDebuggerPort(this.parseInteger(this.debuggerPanel.getPort()));
        this.getPhpOptions().setDebuggerSessionId(this.debuggerPanel.getSessionId());
        this.getPhpOptions().setDebuggerStoppedAtTheFirstLine(this.debuggerPanel.isStoppedAtTheFirstLine());
        this.getPhpOptions().setDebuggerWatchesAndEval(this.debuggerPanel.isWatchesAndEval());
        this.getPhpOptions().setDebuggerMaxStructuresDepth(this.parseInteger(this.debuggerPanel.getMaxStructuresDepth()));
        this.getPhpOptions().setDebuggerMaxChildren(this.parseInteger(this.debuggerPanel.getMaxChildren()));
        this.getPhpOptions().setDebuggerShowUrls(this.debuggerPanel.isShowUrls());
        this.getPhpOptions().setDebuggerShowConsole(this.debuggerPanel.isShowConsole());
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.debuggerPanel == null) {
            this.debuggerPanel = new PhpDebuggerPanel();
            this.debuggerPanel.addChangeListener(this);
        }
        return this.debuggerPanel;
    }

    @Override
    protected boolean validateComponent() {
        Integer port = this.parseInteger(this.debuggerPanel.getPort());
        if (port == null || port < 1) {
            this.debuggerPanel.setError(NbBundle.getMessage(PhpDebuggerPanelController.class, (String)"MSG_DebuggerInvalidPort"));
            return false;
        }
        String sessionId = this.debuggerPanel.getSessionId();
        if (sessionId == null || sessionId.trim().length() == 0 || sessionId.contains(" ")) {
            this.debuggerPanel.setError(NbBundle.getMessage(PhpDebuggerPanelController.class, (String)"MSG_DebuggerInvalidSessionId"));
            return false;
        }
        Integer maxStructuresDepth = this.parseInteger(this.debuggerPanel.getMaxStructuresDepth());
        if (maxStructuresDepth == null || maxStructuresDepth < 1) {
            this.debuggerPanel.setError(NbBundle.getMessage(PhpDebuggerPanelController.class, (String)"MSG_DebuggerInvalidMaxStructuresDepth"));
            return false;
        }
        Integer maxChildren = this.parseInteger(this.debuggerPanel.getMaxChildren());
        if (maxChildren == null || maxChildren < 1) {
            this.debuggerPanel.setError(NbBundle.getMessage(PhpDebuggerPanelController.class, (String)"MSG_DebuggerInvalidMaxChildren"));
            return false;
        }
        this.debuggerPanel.setError(" ");
        return true;
    }
}

