/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.DebugFileCommand;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.RunFileCommand;
import org.netbeans.modules.php.project.ui.actions.RunTestCommand;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

public class SrcNode
extends FilterNode {
    static final Image PACKAGE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/packageBadge.gif");
    static final Image WEB_ROOT_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/php/project/ui/resources/webRootBadge.gif");
    private final PhpProject project;
    private final boolean isTest;
    static final Action[] COMMON_ACTIONS = new Action[]{null, FileSensitiveActions.fileCommandAction((String)"download", (String)DownloadCommand.DISPLAY_NAME, null), FileSensitiveActions.fileCommandAction((String)"upload", (String)UploadCommand.DISPLAY_NAME, null)};

    SrcNode(PhpProject project, DataFolder folder, DataFilter filter, String name, boolean isTest) {
        this(project, folder, new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren(filter)), name, isTest);
    }

    private SrcNode(PhpProject project, DataFolder folder, FilterNode node, String name, boolean isTest) {
        super((Node)node, (Children)new FolderChildren(project, (Node)node, isTest), SrcNode.extendLookupWithSearchInfo(folder.getNodeDelegate().getLookup(), project, folder.getPrimaryFile()));
        this.project = project;
        this.isTest = isTest;
        this.disableDelegation(172);
        this.setDisplayName(name);
    }

    public Image getIcon(int type) {
        return ImageUtilities.mergeImages((Image)super.getIcon(type), (Image)PACKAGE_BADGE, (int)7, (int)7);
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.mergeImages((Image)super.getOpenedIcon(type), (Image)PACKAGE_BADGE, (int)7, (int)7);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonProjectActions.newFileAction());
        actions.add(null);
        if (!this.isTest) {
            actions.add(FileSensitiveActions.fileCommandAction((String)"download", (String)DownloadCommand.DISPLAY_NAME, null));
            actions.add(FileSensitiveActions.fileCommandAction((String)"upload", (String)UploadCommand.DISPLAY_NAME, null));
            actions.add(null);
        }
        actions.add((Action)SystemAction.get(FileSystemAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(FindAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(PasteAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(ToolsAction.class));
        actions.add(null);
        Action customizeAction = null;
        customizeAction = this.isTest ? new PhpLogicalViewProvider.CustomizeProjectAction(this.project, "PhpUnit") : CommonProjectActions.customizeProjectAction();
        actions.add(customizeAction);
        return actions.toArray(new Action[actions.size()]);
    }

    public static Action createDownloadAction() {
        return COMMON_ACTIONS[1];
    }

    public static Action createUploadAction() {
        return COMMON_ACTIONS[2];
    }

    public static Lookup extendLookupWithSearchInfo(Lookup originalLookup, PhpProject project, FileObject folder) {
        return new ProxyLookup(new Lookup[]{originalLookup, Lookups.singleton((Object)SearchInfoFactory.createSearchInfo((FileObject)folder, (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{project.getFileObjectFilter()}))});
    }

    private static final class ObjectNode
    extends FilterNode {
        private final Node originalNode;
        private final boolean isTest;

        public ObjectNode(Node originalNode, boolean isTest) {
            super(originalNode);
            this.originalNode = originalNode;
            this.isTest = isTest;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
            int idx = actions.indexOf(SystemAction.get(PasteAction.class));
            Action[] toAdd = this.getCommonActions();
            for (int i = 0; i < toAdd.length; ++i) {
                if (idx >= 0 && idx + toAdd.length < actions.size()) {
                    actions.add(idx + i + 1, toAdd[i]);
                    continue;
                }
                actions.add(toAdd[i]);
            }
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                Action action = (Action)it.next();
                if (action == null || action.getClass().getName().indexOf("WhereUsedAction") == -1) continue;
                it.remove();
                break;
            }
            return actions.toArray(new Action[actions.size()]);
        }

        private Action[] getCommonActions() {
            ArrayList<Action> toAdd = new ArrayList<Action>();
            if (CommandUtils.isPhpOrHtmlFile(this.getFileObject())) {
                toAdd.add(null);
                toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"run.single", (String)RunFileCommand.DISPLAY_NAME, null));
                toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"debug.single", (String)DebugFileCommand.DISPLAY_NAME, null));
                if (!this.isTest) {
                    toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"test.single", (String)RunTestCommand.DISPLAY_NAME, null));
                }
            }
            ArrayList<Action> actions = new ArrayList<Action>(COMMON_ACTIONS.length + toAdd.size());
            actions.addAll(toAdd);
            if (!this.isTest) {
                actions.addAll(Arrays.asList(COMMON_ACTIONS));
            }
            return actions.toArray(new Action[actions.size()]);
        }

        private FileObject getFileObject() {
            FileObject fileObject = (FileObject)this.originalNode.getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                return fileObject;
            }
            DataObject dataObject = (DataObject)this.originalNode.getLookup().lookup(DataObject.class);
            assert (dataObject != null);
            fileObject = dataObject.getPrimaryFile();
            assert (fileObject != null);
            return fileObject;
        }
    }

    private static final class PackageNode
    extends FilterNode {
        private final PhpProject project;
        private final boolean isTest;
        private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileObject folder;
                String propertyName = evt.getPropertyName();
                if ("webRoot".equals(propertyName) && ((folder = (FileObject)PackageNode.this.getOriginal().getLookup().lookup(FileObject.class)).equals(evt.getOldValue()) || folder.equals(evt.getNewValue()))) {
                    PackageNode.this.fireIconChange();
                    PackageNode.this.fireOpenedIconChange();
                }
            }
        };

        public PackageNode(PhpProject project, Node originalNode, boolean isTest) {
            super(originalNode, (Children)new FolderChildren(project, originalNode, isTest), SrcNode.extendLookupWithSearchInfo(originalNode.getLookup(), project, (FileObject)originalNode.getLookup().lookup(FileObject.class)));
            this.project = project;
            this.isTest = isTest;
            ProjectPropertiesSupport.addWeakPropertyChangeListener(project, this.propertyChangeListener);
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
            if (!this.isTest) {
                int idx = actions.indexOf(SystemAction.get(PasteAction.class));
                for (int i = 0; i < COMMON_ACTIONS.length; ++i) {
                    if (idx >= 0 && idx + COMMON_ACTIONS.length < actions.size()) {
                        actions.add(idx + i + 1, COMMON_ACTIONS[i]);
                        continue;
                    }
                    actions.add(COMMON_ACTIONS[i]);
                }
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Image getIcon(int type) {
            FileObject folder = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            if (ProjectPropertiesSupport.getWebRootDirectory(this.project).equals(folder) && !ProjectPropertiesSupport.getSourcesDirectory(this.project).equals(folder)) {
                return ImageUtilities.mergeImages((Image)super.getIcon(type), (Image)WEB_ROOT_BADGE, (int)7, (int)7);
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            FileObject folder = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            if (ProjectPropertiesSupport.getWebRootDirectory(this.project).equals(folder) && !ProjectPropertiesSupport.getSourcesDirectory(this.project).equals(folder)) {
                return ImageUtilities.mergeImages((Image)super.getOpenedIcon(type), (Image)WEB_ROOT_BADGE, (int)7, (int)7);
            }
            return super.getOpenedIcon(type);
        }
    }

    private static class FolderChildren
    extends FilterNode.Children {
        private final PhpProject project;
        private final boolean isTest;

        FolderChildren(PhpProject project, Node originalNode, boolean isTest) {
            super(originalNode);
            this.project = project;
            this.isTest = isTest;
        }

        protected Node[] createNodes(Node key) {
            return super.createNodes(key);
        }

        protected Node copyNode(Node originalNode) {
            FileObject fo = (FileObject)originalNode.getLookup().lookup(FileObject.class);
            if (fo == null) {
                Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, "No fileobject found for node: {0}", originalNode);
                return super.copyNode(originalNode);
            }
            if (fo.isFolder()) {
                return new PackageNode(this.project, originalNode, this.isTest);
            }
            return new ObjectNode(originalNode, this.isTest);
        }
    }
}

