/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.phpunit.Bundle;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.ui.PhpUnitTestGroupsPanel;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.windows.InputOutput;

public final class PhpUnitTestGroupsFetcher {
    private static final Logger LOGGER = Logger.getLogger(PhpUnitTestGroupsFetcher.class.getName());
    private static final String TEST_GROUPS_DELIMITER = ",";
    private final PhpProjectProperties phpProperties;
    private final Lock phpPropertiesLock = new ReentrantLock();
    private final StringBuffer formattedTestGroups = new StringBuffer(100);
    private final TestGroupsTableModel tableModel = new TestGroupsTableModel();
    private final Collection<String> testGroups = Collections.synchronizedList(new ArrayList());
    private volatile boolean wasInterrupted = false;

    public PhpUnitTestGroupsFetcher(PhpProject project) {
        this.phpProperties = new PhpProjectProperties(project);
    }

    public void fetch(File workingDirectory) {
        this.testGroups.addAll(this.fetchAllTestGroups(workingDirectory));
        if (this.testsContainCustomGroups()) {
            this.runInEdtAndWait(new Runnable(){

                @Override
                public void run() {
                    PhpUnitTestGroupsFetcher.this.displayTestGroupsDialog();
                }
            });
        }
    }

    private Collection<String> fetchAllTestGroups(File workingDirectory) {
        PhpUnit phpUnit = CommandUtils.getPhpUnit(true);
        if (phpUnit == null) {
            assert (false) : "Valid PhpUnit should already be found";
            return Collections.emptyList();
        }
        TestGroupsOutputProcessorFactory outputProcessorFactory = new TestGroupsOutputProcessorFactory();
        ExternalProcessBuilder processBuilder = phpUnit.getProcessBuilder().addArgument("--list-groups").addArgument(workingDirectory.getAbsolutePath());
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)outputProcessorFactory);
        try {
            PhpProgram.execute((ExternalProcessBuilder)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)Bundle.LBL_FetchingTestGroups(), (String)Bundle.LBL_FetchingTestGroups());
        }
        catch (CancellationException ex) {
            return Collections.emptyList();
        }
        return outputProcessorFactory.getTestGroups();
    }

    private boolean testsContainCustomGroups() {
        return !this.testGroups.isEmpty();
    }

    private void displayTestGroupsDialog() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT thread";
        PhpUnitTestGroupsPanel phpUnitTestGroupsPanel = new PhpUnitTestGroupsPanel(this.getTableModel());
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)phpUnitTestGroupsPanel, Bundle.LBL_TestGroups(), 2, -1, null, NotifyDescriptor.OK_OPTION);
        NotificationLineSupport notificationLineSupport = notifyDescriptor.createNotificationLineSupport();
        this.getTableModel().addTableModelListener(new TestGroupsTableModelListener(notificationLineSupport));
        this.initTableModel();
        if (DialogDisplayer.getDefault().notify(notifyDescriptor) != NotifyDescriptor.OK_OPTION) {
            this.wasInterrupted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableModel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT thread";
        String phpUnitLastUsedTestGroups = null;
        this.phpPropertiesLock.lock();
        try {
            phpUnitLastUsedTestGroups = this.phpProperties.getPhpUnitLastUsedTestGroups();
        }
        finally {
            this.phpPropertiesLock.unlock();
        }
        List lastUsedTestGroups = StringUtils.explode((String)phpUnitLastUsedTestGroups, (String)TEST_GROUPS_DELIMITER);
        for (String testGroup : this.testGroups) {
            this.getTableModel().addRow(new Object[]{testGroup, lastUsedTestGroups.contains(testGroup)});
        }
    }

    public void saveSelectedTestGroups() {
        this.saveFormattedTestGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFormattedTestGroups() {
        this.phpPropertiesLock.lock();
        try {
            this.phpProperties.setPhpUnitLastUsedTestGroups(this.getFormattedTestGroups());
            this.phpProperties.save();
        }
        finally {
            this.phpPropertiesLock.unlock();
        }
    }

    private String getFormattedTestGroups() {
        if (this.formattedTestGroups.length() == 0) {
            this.createFormatedTestGroups();
        }
        return this.formattedTestGroups.toString();
    }

    private void createFormatedTestGroups() {
        this.runInEdtAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < PhpUnitTestGroupsFetcher.this.getTableModel().getRowCount(); ++i) {
                    PhpUnitTestGroupsFetcher.this.processTableRow(i);
                }
            }
        });
    }

    private void processTableRow(int i) {
        Boolean isChecked = (Boolean)this.getTableModel().getValueAt(i, 1);
        if (isChecked.booleanValue()) {
            this.addRowToFormattedTestGroups(i);
        }
    }

    private void addRowToFormattedTestGroups(int i) {
        String groupName = (String)this.getTableModel().getValueAt(i, 0);
        this.formattedTestGroups.append(this.formattedTestGroups.length() == 0 ? groupName : TEST_GROUPS_DELIMITER + groupName);
    }

    public boolean wasInterrupted() {
        return this.wasInterrupted;
    }

    private DefaultTableModel getTableModel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT thread";
        return this.tableModel;
    }

    private void runInEdtAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private static final class TestGroupsTableModelListener
    implements TableModelListener {
        private final NotificationLineSupport notificationLineSupport;

        public TestGroupsTableModelListener(NotificationLineSupport notificationLineSupport) {
            this.notificationLineSupport = notificationLineSupport;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModel tableModel = (TableModel)e.getSource();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                Boolean isRowChecked = (Boolean)tableModel.getValueAt(i, 1);
                if (!isRowChecked.booleanValue()) continue;
                this.notificationLineSupport.clearMessages();
                return;
            }
            this.notificationLineSupport.setInformationMessage(Bundle.MSG_NoTestsForExecution());
        }
    }

    private static final class TestGroupsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 687644354211L;
        private final Class<?>[] types = new Class[]{String.class, Boolean.class};

        public TestGroupsTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public TestGroupsTableModel() {
            this(new Object[0][], new Object[]{null, null});
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }

    private class TestGroupsOutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final Pattern testGroupName = Pattern.compile("^\\s-\\s(.*)$");
        private final Collection<String> testGroups = Collections.synchronizedCollection(new ArrayList());

        private TestGroupsOutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    Matcher matcher = TestGroupsOutputProcessorFactory.this.testGroupName.matcher(line);
                    if (matcher.matches()) {
                        TestGroupsOutputProcessorFactory.this.testGroups.add(matcher.group(1).trim());
                    }
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }

        public Collection<String> getTestGroups() {
            return this.testGroups;
        }
    }
}

