/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.environment.MacPhpEnvironment;
import org.netbeans.modules.php.project.environment.SolarisPhpEnvironment;
import org.netbeans.modules.php.project.environment.UnixPhpEnvironment;
import org.netbeans.modules.php.project.environment.UnknownPhpEnvironment;
import org.netbeans.modules.php.project.environment.WindowsPhpEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class PhpEnvironment {
    public static final DocumentRoot PENDING_DOCUMENT_ROOT = new DocumentRoot(NbBundle.getMessage(PhpEnvironment.class, (String)"LBL_PleaseWait"), null, null, true);
    protected static final Logger LOGGER = Logger.getLogger(PhpEnvironment.class.getName());
    static final String HTDOCS = "htdocs";
    static final FilenameFilter APACHE_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith("apache");
        }
    };
    private static final PhpEnvironment UNKNOWN_PHP_ENVIRONMENT = new UnknownPhpEnvironment();
    private static final RequestProcessor READ_DOCUMENT_ROOTS_THREAD = new RequestProcessor("Read document roots", 3);

    PhpEnvironment() {
    }

    public static PhpEnvironment get() {
        if (PhpEnvironment.isSolaris()) {
            return new SolarisPhpEnvironment();
        }
        if (Utilities.isWindows()) {
            return new WindowsPhpEnvironment();
        }
        if (Utilities.isMac()) {
            return new MacPhpEnvironment();
        }
        if (Utilities.isUnix()) {
            return new UnixPhpEnvironment();
        }
        return UNKNOWN_PHP_ENVIRONMENT;
    }

    public DocumentRoot readDocumentRoots(final ReadDocumentRootsNotifier notifier, final String projectName) {
        assert (notifier != null);
        RequestProcessor.Task readDocumentRootsTask = READ_DOCUMENT_ROOTS_THREAD.create(new Runnable(){

            @Override
            public void run() {
                List<DocumentRoot> documentRoots = PhpEnvironment.this.getDocumentRoots(projectName);
                assert (documentRoots != null);
                notifier.finished(documentRoots);
            }
        });
        readDocumentRootsTask.schedule(0);
        return PENDING_DOCUMENT_ROOT;
    }

    public DocumentRoot readDocumentRoots(ReadDocumentRootsNotifier notifier) {
        return this.readDocumentRoots(notifier, null);
    }

    public abstract List<String> getAllPhpInterpreters();

    public String getAnyPhpInterpreter() {
        List<String> allPhpInterpreters = this.getAllPhpInterpreters();
        if (allPhpInterpreters.isEmpty()) {
            return null;
        }
        return allPhpInterpreters.get(0);
    }

    public List<String> getAllPhpUnits() {
        return FileUtils.findFileOnUsersPath((String)"phpunit");
    }

    public String getAnyPhpUnit() {
        List<String> allPhpUnits = this.getAllPhpUnits();
        if (allPhpUnits.isEmpty()) {
            return null;
        }
        return allPhpUnits.get(0);
    }

    protected abstract List<DocumentRoot> getDocumentRoots(String var1);

    static boolean isSolaris() {
        return (Utilities.getOperatingSystem() & 8) != 0 || (Utilities.getOperatingSystem() & 0x100) != 0;
    }

    static String getFolderName(File location, String name) {
        if (name == null) {
            return location.getAbsolutePath();
        }
        return new File(location, name).getAbsolutePath();
    }

    static String getDefaultUrl(String urlPart) {
        return PhpEnvironment.getDefaultUrl(urlPart, null);
    }

    static String getDefaultUrl(String urlPart, Integer port) {
        StringBuilder url = new StringBuilder(100);
        url.append("http://localhost");
        if (port != null) {
            url.append(":");
            url.append(port);
        }
        url.append("/");
        if (urlPart != null) {
            url.append(urlPart);
            url.append("/");
        }
        return url.toString();
    }

    static File findHtDocsDirectory(File startDir, FilenameFilter filenameFilter) {
        LOGGER.log(Level.FINE, "Searching for htdocs in {0}", startDir);
        String[] subDirNames = startDir.list(filenameFilter);
        if (subDirNames == null || subDirNames.length == 0) {
            return null;
        }
        for (String subDirName : subDirNames) {
            File subDir = new File(startDir, subDirName);
            File htDocs = new File(subDir, HTDOCS);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("\t%s - exists: %s, directory: %s, file: %s", htDocs, htDocs.exists(), htDocs.isDirectory(), htDocs.isFile()));
            }
            if (htDocs.isDirectory()) {
                return htDocs;
            }
            htDocs = PhpEnvironment.findHtDocsDirectory(subDir, filenameFilter);
            if (htDocs == null || !htDocs.isDirectory()) continue;
            return htDocs;
        }
        return null;
    }

    static DocumentRoot getUserPublicHtmlDocumentRoot(String projectName) {
        DocumentRoot docRoot = null;
        File userDir = new File(System.getProperty("user.home"), "public_html");
        if (userDir.isDirectory()) {
            String documentRoot = PhpEnvironment.getFolderName(userDir, projectName);
            String user = System.getProperty("user.name");
            String urlSuffix = projectName != null ? "/" + projectName : "";
            String url = PhpEnvironment.getDefaultUrl("~" + user + urlSuffix);
            String hint = NbBundle.getMessage(PhpEnvironment.class, (String)"TXT_UserDir");
            docRoot = new DocumentRoot(documentRoot, url, hint, FileUtils.isDirectoryWritable((File)userDir));
        }
        return docRoot;
    }

    static List<String> getAllPhpInterpreters(String phpFilename) {
        return FileUtils.findFileOnUsersPath((String)phpFilename);
    }

    public static interface ReadDocumentRootsNotifier {
        public void finished(List<DocumentRoot> var1);
    }

    public static final class DocumentRoot {
        private final String documentRoot;
        private final String url;
        private final String hint;
        private final boolean preferred;

        public DocumentRoot(String documentRoot, String url, String hint, boolean preferred) {
            this.documentRoot = documentRoot;
            this.url = url;
            this.hint = hint;
            this.preferred = preferred;
        }

        public String getDocumentRoot() {
            return this.documentRoot;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isPreferred() {
            return this.preferred;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append(this.getClass().getName());
            sb.append(" { documentRoot : ");
            sb.append(this.documentRoot);
            sb.append(" , url : ");
            sb.append(this.url);
            sb.append(" , hint : ");
            sb.append(this.hint);
            sb.append(" , preferred : ");
            sb.append(this.preferred);
            sb.append(" }");
            return sb.toString();
        }
    }
}

