/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserVisual;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.TransferSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class TransferFilesChooser {
    private final Set<TransferFile> transferFiles;
    private final TransferType transferType;
    private final long timestamp;
    private TransferFilesChooserVisual transferVisual;
    private TransferFilesChooserPanel transferPanel;

    private TransferFilesChooser(Set<TransferFile> transferFiles, TransferType transferType, long timestamp) {
        assert (transferFiles != null);
        assert (transferType != null);
        this.transferFiles = Collections.synchronizedSet(new HashSet<TransferFile>(transferFiles));
        this.transferType = transferType;
        this.timestamp = timestamp;
    }

    public static TransferFilesChooser forDownload(Set<TransferFile> transferFiles) {
        return TransferFilesChooser.forDownload(transferFiles, -1L);
    }

    public static TransferFilesChooser forDownload(Set<TransferFile> transferFiles, long timestamp) {
        return new TransferFilesChooser(transferFiles, TransferType.DOWNLOAD, timestamp);
    }

    public static TransferFilesChooser forUpload(Set<TransferFile> transferFiles) {
        return TransferFilesChooser.forUpload(transferFiles, -1L);
    }

    public static TransferFilesChooser forUpload(Set<TransferFile> transferFiles, long timestamp) {
        return new TransferFilesChooser(transferFiles, TransferType.UPLOAD, timestamp);
    }

    public Set<TransferFile> showDialog() {
        String titleKey = null;
        switch (this.transferType) {
            case DOWNLOAD: {
                titleKey = "LBL_FileDownload";
                break;
            }
            case UPLOAD: {
                titleKey = "LBL_FileUpload";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transfer type: " + (Object)((Object)this.transferType));
            }
        }
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(TransferFilesChooser.class, (String)"LBL_Ok"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.getTransferVisual(), NbBundle.getMessage(TransferFilesChooser.class, (String)titleKey), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == okButton) {
            return this.getTransferPanel().getSelectedFiles();
        }
        return Collections.emptySet();
    }

    public TransferFilesChooserPanel getEmbeddablePanel() {
        return this.getTransferVisual().getEmbeddablePanel();
    }

    public boolean hasAnyTransferableFiles() {
        return this.getTransferPanel().hasAnyTransferableFiles();
    }

    private synchronized TransferFilesChooserVisual getTransferVisual() {
        if (this.transferVisual == null) {
            this.transferVisual = new TransferFilesChooserVisual(this.getTransferPanel(), this.transferType);
        }
        return this.transferVisual;
    }

    private synchronized TransferFilesChooserPanel getTransferPanel() {
        if (this.transferPanel == null) {
            this.transferPanel = new TransferSelector(this.transferFiles, this.transferType, this.timestamp);
        }
        return this.transferPanel;
    }

    public static enum TransferType {
        UPLOAD,
        DOWNLOAD;

    }
}

