/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.LocalTransferFile;
import org.netbeans.modules.php.project.connections.transfer.RemoteTransferFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class TransferFile {
    public static final String REMOTE_PATH_SEPARATOR = "/";
    public static final String REMOTE_PROJECT_ROOT = ".";
    protected final String baseDirectory;
    protected final TransferFile parent;
    private final ReadWriteLock childrenLock = new ReentrantReadWriteLock();
    private Set<TransferFile> children = null;
    private volatile Long timestamp = null;
    private Long size = null;

    TransferFile(TransferFile parent, String baseDirectory) {
        this.parent = parent;
        this.baseDirectory = baseDirectory;
    }

    public static TransferFile fromFileObject(TransferFile parent, FileObject fo, String baseDirectory) {
        assert (fo != null);
        return TransferFile.fromFile(parent, FileUtil.toFile((FileObject)fo), baseDirectory, fo.isFolder());
    }

    public static TransferFile fromFile(TransferFile parent, File file, String baseDirectory) {
        return TransferFile.fromFile(parent, file, baseDirectory, false);
    }

    public static TransferFile fromDirectory(TransferFile parent, File file, String baseDirectory) {
        return TransferFile.fromFile(parent, file, baseDirectory, true);
    }

    public static TransferFile fromRemoteFile(TransferFile parent, RemoteFile remoteFile, RemoteClientImplementation remoteClient) {
        RemoteTransferFile transferFile = new RemoteTransferFile(remoteFile, parent, remoteClient);
        if (parent != null) {
            parent.addChild(transferFile);
        }
        return transferFile;
    }

    private static TransferFile fromFile(TransferFile parent, File file, String baseDirectory, boolean forceDirectory) {
        LocalTransferFile transferFile = new LocalTransferFile(FileUtil.normalizeFile((File)file), parent, baseDirectory, forceDirectory);
        if (parent != null) {
            parent.addChild(transferFile);
        }
        return transferFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TransferFile> getChildren() {
        if (!this.isDirectory()) {
            return Collections.emptyList();
        }
        this.initChildren();
        this.childrenLock.readLock().lock();
        try {
            ArrayList<TransferFile> arrayList = new ArrayList<TransferFile>(this.children);
            return arrayList;
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildrenFetched() {
        if (!this.isDirectory()) {
            return true;
        }
        this.childrenLock.readLock().lock();
        try {
            boolean bl = this.children != null;
            return bl;
        }
        finally {
            this.childrenLock.readLock().unlock();
        }
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final TransferFile getParent() {
        if (this.isProjectRoot()) {
            throw new IllegalStateException("Cannot get parent on project root.");
        }
        return this.parent;
    }

    public final String getBaseDirectory() {
        return this.baseDirectory;
    }

    public boolean isRoot() {
        if (this.isProjectRoot()) {
            return true;
        }
        return !this.hasParent();
    }

    public boolean isProjectRoot() {
        return REMOTE_PROJECT_ROOT == this.getRemotePath();
    }

    public abstract String getName();

    public abstract String getRemotePath();

    protected abstract Collection<TransferFile> fetchChildren();

    public final String getParentRemotePath() {
        if (this.getParent() != null) {
            return this.getParent().getRemotePath();
        }
        ArrayList fragments = new ArrayList(StringUtils.explode((String)this.getRemotePath(), (String)REMOTE_PATH_SEPARATOR));
        fragments.remove(fragments.size() - 1);
        if (fragments.isEmpty()) {
            return REMOTE_PROJECT_ROOT;
        }
        return StringUtils.implode(fragments, (String)REMOTE_PATH_SEPARATOR);
    }

    public final String getLocalPath() {
        String remotePath = this.getRemotePath();
        if (File.separator.equals(REMOTE_PATH_SEPARATOR)) {
            return remotePath;
        }
        return remotePath.replace(REMOTE_PATH_SEPARATOR, File.separator);
    }

    public File resolveLocalFile(File directory) {
        if (directory == null) {
            throw new NullPointerException();
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory must be provided (both existing and non-existing allowed)");
        }
        if (this.isProjectRoot()) {
            return directory;
        }
        return new File(directory, this.getLocalPath());
    }

    public final long getSize() {
        if (this.size == null) {
            this.size = this.getSizeImpl();
            if (this.size < 0L) {
                throw new IllegalArgumentException("Size cannot be smaller than 0");
            }
            if (this.isDirectory() && this.size != 0L) {
                throw new IllegalArgumentException("Size of a directory has to be 0 bytes");
            }
        }
        return this.size;
    }

    protected abstract long getSizeImpl();

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isLink();

    public final long getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = this.getTimestampImpl();
        }
        return this.timestamp;
    }

    protected abstract long getTimestampImpl();

    public final void touch() {
        this.timestamp = new Date().getTime();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferFile)) {
            return false;
        }
        TransferFile other = (TransferFile)obj;
        return this.getRemotePath().equals(other.getRemotePath());
    }

    public int hashCode() {
        return this.getRemotePath().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name: " + this.getName() + ", remotePath: " + this.getRemotePath() + ", baseDirectory: " + this.getBaseDirectory() + ", hasParent: " + this.hasParent() + ", isFile: " + this.isFile() + ", isDirectory: " + this.isDirectory() + ", isLink: " + this.isLink() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(TransferFile child) {
        if (!this.isDirectory()) {
            throw new IllegalStateException("Cannot add child to not directory: " + this);
        }
        this.initChildren();
        this.childrenLock.writeLock().lock();
        try {
            this.children.add(child);
        }
        finally {
            this.childrenLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChildren() {
        boolean fetchChildren;
        block11: {
            fetchChildren = false;
            this.childrenLock.readLock().lock();
            try {
                if (this.children != null) break block11;
                this.childrenLock.readLock().unlock();
                this.childrenLock.writeLock().lock();
                try {
                    if (this.children == null) {
                        this.children = new LinkedHashSet<TransferFile>();
                        fetchChildren = true;
                    }
                }
                finally {
                    this.childrenLock.readLock().lock();
                    this.childrenLock.writeLock().unlock();
                }
            }
            finally {
                this.childrenLock.readLock().unlock();
            }
        }
        if (fetchChildren) {
            Collection<TransferFile> fetchedChildren = this.fetchChildren();
            this.childrenLock.writeLock().lock();
            try {
                this.children.addAll(fetchedChildren);
            }
            finally {
                this.childrenLock.writeLock().unlock();
            }
        }
    }
}

