/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class FtpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 62342689756412730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private boolean passwordRead = false;
    private JCheckBox anonymousCheckBox;
    private JComboBox encryptionComboBox;
    private JLabel encryptionLabel;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JCheckBox ignoreDisconnectErrorsCheckBox;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JLabel keepAliveInfoLabel;
    private JLabel keepAliveLabel;
    private JTextField keepAliveTextField;
    private JCheckBox onlyLoginSecuredCheckBox;
    private JCheckBox passiveModeCheckBox;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public FtpConfigurationPanel() {
        this.initComponents();
        this.init();
        this.registerListeners();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidConfiguration() {
        String err = RemoteValidator.validateHost(this.hostTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        err = RemoteValidator.validatePort(this.portTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        if (!this.validateUser()) {
            return false;
        }
        if (!this.validateInitialDirectory()) {
            return false;
        }
        err = RemoteValidator.validateTimeout(this.timeoutTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        err = RemoteValidator.validateKeepAliveInterval(this.keepAliveTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        this.setError(null);
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    private void init() {
        this.populateEncryptionComboBox();
        this.setEnabledOnlyLoginSecured();
        this.setEnabledLoginCredentials();
    }

    void setEnabledLoginCredentials() {
        this.setEnabledLoginCredentials(!this.anonymousCheckBox.isSelected());
    }

    private void setEnabledLoginCredentials(boolean enabled) {
        this.userTextField.setEnabled(enabled);
        this.passwordTextField.setEnabled(enabled);
    }

    void setEnabledOnlyLoginSecured() {
        this.onlyLoginSecuredCheckBox.setEnabled(this.getEncryptionInternal() != FtpConfiguration.Encryption.NONE);
    }

    private void populateEncryptionComboBox() {
        for (FtpConfiguration.Encryption encryption : FtpConfiguration.Encryption.values()) {
            this.encryptionComboBox.addItem(encryption);
        }
        this.encryptionComboBox.setRenderer(new EncryptionRenderer());
    }

    private void registerListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        DefaultActionListener actionListener = new DefaultActionListener();
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.encryptionComboBox.addActionListener(actionListener);
        this.onlyLoginSecuredCheckBox.addActionListener(actionListener);
        this.userTextField.getDocument().addDocumentListener(documentListener);
        this.passwordTextField.getDocument().addDocumentListener(documentListener);
        this.anonymousCheckBox.addActionListener(actionListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(documentListener);
        this.timeoutTextField.getDocument().addDocumentListener(documentListener);
        this.keepAliveTextField.getDocument().addDocumentListener(documentListener);
        this.passiveModeCheckBox.addActionListener(actionListener);
        this.ignoreDisconnectErrorsCheckBox.addActionListener(actionListener);
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpConfigurationPanel.this.setEnabledLoginCredentials();
            }
        });
        this.encryptionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpConfigurationPanel.this.setEnabledOnlyLoginSecured();
            }
        });
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private boolean validateUser() {
        if (this.isAnonymousLogin()) {
            return true;
        }
        String err = RemoteValidator.validateUser(this.userTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String err = RunAsValidator.validateUploadDirectory(this.getInitialDirectory(), false);
        if (err != null) {
            this.setError(err);
            return false;
        }
        return true;
    }

    private FtpConfiguration.Encryption getEncryptionInternal() {
        return (FtpConfiguration.Encryption)((Object)this.encryptionComboBox.getSelectedItem());
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.encryptionLabel = new JLabel();
        this.encryptionComboBox = new JComboBox();
        this.onlyLoginSecuredCheckBox = new JCheckBox();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.anonymousCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.keepAliveLabel = new JLabel();
        this.keepAliveTextField = new JTextField();
        this.keepAliveInfoLabel = new JLabel();
        this.passiveModeCheckBox = new JCheckBox();
        this.passwordLabelInfo = new JLabel();
        this.ignoreDisconnectErrorsCheckBox = new JCheckBox();
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.text_1"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.text_1"));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        this.encryptionLabel.setLabelFor(this.encryptionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encryptionLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.onlyLoginSecuredCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.onlyLoginSecuredCheckBox.text"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.text_1"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.text_1"));
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.text_1"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.text_1"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        this.keepAliveLabel.setLabelFor(this.keepAliveTextField);
        Mnemonics.setLocalizedText((JLabel)this.keepAliveLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keepAliveInfoLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.passiveModeCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.text_1"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreDisconnectErrorsCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passiveModeCheckBox).addComponent(this.ignoreDisconnectErrorsCheckBox)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.userLabel).addComponent(this.passwordLabel).addComponent(this.initialDirectoryLabel).addComponent(this.timeoutLabel).addComponent(this.keepAliveLabel).addComponent(this.encryptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.onlyLoginSecuredCheckBox).addContainerGap(29, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.userTextField, GroupLayout.Alignment.LEADING).addComponent(this.hostTextField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.passwordTextField, GroupLayout.Alignment.LEADING).addComponent(this.initialDirectoryTextField, GroupLayout.Alignment.LEADING).addComponent(this.keepAliveTextField, GroupLayout.Alignment.LEADING).addComponent(this.timeoutTextField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField, -1, -1, Short.MAX_VALUE)).addComponent(this.anonymousCheckBox, GroupLayout.Alignment.LEADING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keepAliveInfoLabel).addComponent(this.passwordLabelInfo).addComponent(this.encryptionComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encryptionLabel).addComponent(this.encryptionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyLoginSecuredCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.anonymousCheckBox).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDirectoryLabel).addComponent(this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutTextField, -2, -1, -2).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keepAliveLabel).addComponent(this.keepAliveTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepAliveInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passiveModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreDisconnectErrorsCheckBox).addContainerGap()));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.encryptionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.AccessibleContext.accessibleName"));
        this.encryptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.AccessibleContext.accessibleDescription"));
        this.encryptionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionComboBox.AccessibleContext.accessibleName"));
        this.encryptionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionComboBox.AccessibleContext.accessibleDescription"));
        this.onlyLoginSecuredCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.dataChannelSecuredCheckBox.AccessibleContext.accessibleName"));
        this.onlyLoginSecuredCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.dataChannelSecuredCheckBox.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleName"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleName"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleDescription"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleName"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleDescription"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleName"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.ignoreDisconnectErrorsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.AccessibleContext.accessibleName"));
        this.ignoreDisconnectErrorsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String hostName) {
        this.hostTextField.setText(hostName);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public String getEncryption() {
        return this.getEncryptionInternal().name();
    }

    public void setEncryption(String encryption) {
        this.encryptionComboBox.setSelectedItem((Object)FtpConfiguration.Encryption.valueOf(encryption));
        this.setEnabledOnlyLoginSecured();
    }

    public boolean isOnlyLoginSecured() {
        return this.onlyLoginSecuredCheckBox.isSelected();
    }

    public void setOnlyLoginSecured(boolean onlyLoginSecured) {
        this.onlyLoginSecuredCheckBox.setSelected(onlyLoginSecured);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String userName) {
        this.userTextField.setText(userName);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordTextField.setText(password);
    }

    public boolean isAnonymousLogin() {
        return this.anonymousCheckBox.isSelected();
    }

    public void setAnonymousLogin(boolean anonymousLogin) {
        this.anonymousCheckBox.setSelected(anonymousLogin);
        this.setEnabledLoginCredentials();
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryTextField.setText(initialDirectory);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String timeout) {
        this.timeoutTextField.setText(timeout);
    }

    public String getKeepAliveInterval() {
        return this.keepAliveTextField.getText();
    }

    public void setKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveTextField.setText(keepAliveInterval);
    }

    public boolean isPassiveMode() {
        return this.passiveModeCheckBox.isSelected();
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveModeCheckBox.setSelected(passiveMode);
    }

    public boolean getIgnoreDisconnectErrors() {
        return this.ignoreDisconnectErrorsCheckBox.isSelected();
    }

    public void setIgnoreDisconnectErrors(boolean ignoreDisconnectErrors) {
        this.ignoreDisconnectErrorsCheckBox.setSelected(ignoreDisconnectErrors);
    }

    @Override
    public void read(ConfigManager.Configuration cfg) {
        this.setHostName(cfg.getValue("host"));
        this.setPort(cfg.getValue("port"));
        this.setEncryption(cfg.getValue("encryption"));
        this.setOnlyLoginSecured(Boolean.valueOf(cfg.getValue("onlyLoginEncrypted")));
        this.setUserName(cfg.getValue("user"));
        this.setPassword(this.readPassword(cfg));
        this.setAnonymousLogin(Boolean.valueOf(cfg.getValue("anonymousLogin")));
        this.setInitialDirectory(cfg.getValue("initialDirectory"));
        this.setTimeout(cfg.getValue("timeout"));
        this.setKeepAliveInterval(cfg.getValue("keepAliveInterval"));
        this.setPassiveMode(Boolean.valueOf(cfg.getValue("passiveMode")));
        this.setIgnoreDisconnectErrors(Boolean.valueOf(cfg.getValue("ignoreDisconnectErrors")));
    }

    @Override
    public void store(ConfigManager.Configuration cfg) {
        cfg.putValue("host", this.getHostName());
        cfg.putValue("port", this.getPort());
        cfg.putValue("encryption", this.getEncryption());
        cfg.putValue("onlyLoginEncrypted", String.valueOf(this.isOnlyLoginSecured()));
        cfg.putValue("user", this.getUserName());
        cfg.putValue("password", this.getPassword(), true);
        cfg.putValue("anonymousLogin", String.valueOf(this.isAnonymousLogin()));
        cfg.putValue("initialDirectory", RunAsValidator.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        cfg.putValue("timeout", this.getTimeout());
        cfg.putValue("keepAliveInterval", this.getKeepAliveInterval());
        cfg.putValue("passiveMode", String.valueOf(this.isPassiveMode()));
        cfg.putValue("ignoreDisconnectErrors", String.valueOf(this.getIgnoreDisconnectErrors()));
    }

    private String readPassword(ConfigManager.Configuration cfg) {
        if (!this.passwordRead) {
            this.passwordRead = true;
            return new FtpConfiguration(cfg).getPassword();
        }
        return cfg.getValue("password", true);
    }

    public static class EncryptionRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 468746132134L;

        public EncryptionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                assert (value instanceof FtpConfiguration.Encryption);
                this.setText(((FtpConfiguration.Encryption)((Object)value)).getLabel());
            }
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FtpConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            FtpConfigurationPanel.this.fireChange();
        }
    }
}

