/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import org.openide.util.NbBundle;

public final class RemoteValidator {
    public static final int MINIMUM_PORT = 0;
    public static final int MAXIMUM_PORT = 65535;

    private RemoteValidator() {
    }

    public static String validateHost(String host) {
        assert (host != null);
        if (host.trim().length() == 0) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoHostName");
        }
        return null;
    }

    public static String validateUser(String username) {
        if (username.trim().length() == 0) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoUserName");
        }
        return null;
    }

    public static String validatePort(String port) {
        String err = null;
        try {
            int p = Integer.parseInt(port);
            if (p < 0 || p > 65535) {
                err = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortInvalid", (Object)String.valueOf(0), (Object)String.valueOf(65535));
            }
        }
        catch (NumberFormatException nfe) {
            err = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortNotNumeric");
        }
        return err;
    }

    public static String validateTimeout(String timeout) {
        return RemoteValidator.validatePositiveNumber(timeout, "MSG_TimeoutNotPositive", "MSG_TimeoutNotNumeric");
    }

    public static String validateKeepAliveInterval(String keepAliveInterval) {
        return RemoteValidator.validatePositiveNumber(keepAliveInterval, "MSG_KeepAliveNotPositive", "MSG_KeepAliveNotNumeric");
    }

    private static String validatePositiveNumber(String number, String errorNotPositiveKey, String errorNotNumericKey) {
        String err = null;
        try {
            int t = Integer.parseInt(number);
            if (t < 0) {
                err = NbBundle.getMessage(RemoteValidator.class, (String)errorNotPositiveKey);
            }
        }
        catch (NumberFormatException nfe) {
            err = NbBundle.getMessage(RemoteValidator.class, (String)errorNotNumericKey);
        }
        return err;
    }
}

