/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

public class IncludePathClassPathProvider
implements ClassPathProvider {
    private static final Set<ClassPath> PROJECT_INCLUDES = new WeakSet();
    private static final ReadWriteLock PROJECT_INCLUDES_LOCK = new ReentrantReadWriteLock();

    public static void addProjectIncludePath(final ClassPath classPath) {
        IncludePathClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_INCLUDES.add(classPath);
            }
        });
    }

    public static synchronized void removeProjectIncludePath(final ClassPath classPath) {
        IncludePathClassPathProvider.runUnderWriteLock(new Runnable(){

            @Override
            public void run() {
                PROJECT_INCLUDES.remove(classPath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(FileObject file, String type) {
        if (!FileUtils.isPhpFile((FileObject)file)) {
            return null;
        }
        PhpSourcePath.FileType fileType = PhpSourcePath.getFileType(file);
        if (fileType == PhpSourcePath.FileType.UNKNOWN) {
            PROJECT_INCLUDES_LOCK.readLock().lock();
            try {
                for (ClassPath classPath : PROJECT_INCLUDES) {
                    if (!classPath.contains(file)) continue;
                    ClassPath classPath2 = classPath;
                    return classPath2;
                }
            }
            finally {
                PROJECT_INCLUDES_LOCK.readLock().unlock();
            }
        }
        List<FileObject> includePath = PhpSourcePath.getIncludePath(file);
        return ClassPathSupport.createClassPath((FileObject[])includePath.toArray(new FileObject[includePath.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runUnderWriteLock(Runnable runnable) {
        PROJECT_INCLUDES_LOCK.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            PROJECT_INCLUDES_LOCK.writeLock().unlock();
        }
    }
}

