/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.ui.BrowseTestSources;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProjectPropertiesSupport {
    private static final RequestProcessor RP = new RequestProcessor(ProjectPropertiesSupport.class);

    private ProjectPropertiesSupport() {
    }

    public static PropertyEvaluator getPropertyEvaluator(PhpProject project) {
        return project.getEvaluator();
    }

    public static void addWeakPropertyEvaluatorListener(PhpProject project, PropertyChangeListener listener) {
        project.addWeakPropertyEvaluatorListener(listener);
    }

    public static void addWeakIgnoredFilesListener(PhpProject project, ChangeListener listener) {
        project.addWeakIgnoredFilesListener(listener);
    }

    public static boolean addWeakPropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        return project.addWeakPropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        project.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        project.removePropertyChangeListener(listener);
    }

    public static FileObject getProjectDirectory(PhpProject project) {
        return project.getProjectDirectory();
    }

    public static FileObject getSourcesDirectory(PhpProject project) {
        return project.getSourcesDirectory();
    }

    public static FileObject getTestDirectory(PhpProject project, boolean showFileChooser) {
        BrowseTestSources panel;
        FileObject testsDirectory = project.getTestsDirectory();
        if (testsDirectory != null && testsDirectory.isValid()) {
            return testsDirectory;
        }
        if (showFileChooser && (panel = new BrowseTestSources(project, NbBundle.getMessage(ProjectPropertiesSupport.class, (String)"LBL_BrowseTests"))).open()) {
            File tests = new File(panel.getTestSources());
            assert (tests.isDirectory());
            testsDirectory = FileUtil.toFileObject((File)tests);
            project.setTestsDirectory(testsDirectory);
            ProjectPropertiesSupport.saveTestSources(project, "test.src.dir", tests);
        }
        return testsDirectory;
    }

    public static FileObject getSeleniumDirectory(PhpProject project, boolean showFileChooser) {
        BrowseTestSources panel;
        FileObject seleniumDirectory = project.getSeleniumDirectory();
        if (seleniumDirectory != null && seleniumDirectory.isValid()) {
            return seleniumDirectory;
        }
        if (showFileChooser && (panel = new BrowseTestSources(project, NbBundle.getMessage(ProjectPropertiesSupport.class, (String)"LBL_BrowseSelenium"))).open()) {
            File selenium = new File(panel.getTestSources());
            assert (selenium.isDirectory());
            seleniumDirectory = FileUtil.toFileObject((File)selenium);
            project.setSeleniumDirectory(seleniumDirectory);
            ProjectPropertiesSupport.saveTestSources(project, "selenium.src.dir", selenium);
        }
        return seleniumDirectory;
    }

    public static FileObject getWebRootDirectory(PhpProject project) {
        return project.getWebRootDirectory();
    }

    public static FileObject getSourceSubdirectory(PhpProject project, String subdirectoryPath) {
        FileObject sources = project.getSourcesDirectory();
        if (subdirectoryPath != null && subdirectoryPath.trim().length() > 0) {
            File resolved = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)sources), (String)subdirectoryPath);
            if (resolved.exists()) {
                return FileUtil.toFileObject((File)resolved);
            }
            return sources.getFileObject(subdirectoryPath);
        }
        return sources;
    }

    public static PhpInterpreter getPhpInterpreter(PhpProject project) throws PhpProgram.InvalidPhpProgramException {
        String interpreter = project.getEvaluator().getProperty("interpreter");
        if (StringUtils.hasText((String)interpreter)) {
            return PhpInterpreter.getCustom((String)interpreter);
        }
        return PhpInterpreter.getDefault();
    }

    public static boolean isCopySourcesEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "copy.src.files", false);
    }

    public static File getCopySourcesTarget(PhpProject project) {
        String targetString = project.getEvaluator().getProperty("copy.src.target");
        if (targetString != null && targetString.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(targetString));
        }
        return null;
    }

    public static String getEncoding(PhpProject project) {
        return project.getEvaluator().getProperty("source.encoding");
    }

    public static boolean areShortTagsEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "tags.short", true);
    }

    public static boolean areAspTagsEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "tags.asp", false);
    }

    public static PhpLanguageOptions.PhpVersion getPhpVersion(PhpProject project) {
        return ProjectPropertiesSupport.getPhpVersion(project.getEvaluator().getProperty("php.version"));
    }

    public static PhpLanguageOptions.PhpVersion getPhpVersion(String value) {
        if (value != null) {
            try {
                return PhpLanguageOptions.PhpVersion.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return PhpLanguageOptions.PhpVersion.getDefault();
    }

    public static PhpProjectProperties.RunAsType getRunAs(PhpProject project) {
        PhpProjectProperties.RunAsType runAsType = null;
        String runAs = project.getEvaluator().getProperty("run.as");
        if (runAs != null) {
            try {
                runAsType = PhpProjectProperties.RunAsType.valueOf(runAs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return runAsType != null ? runAsType : PhpProjectProperties.RunAsType.LOCAL;
    }

    public static String getUrl(PhpProject project) {
        return project.getEvaluator().getProperty("url");
    }

    public static String getIndexFile(PhpProject project) {
        return project.getEvaluator().getProperty("index.file");
    }

    public static String getArguments(PhpProject project) {
        return project.getEvaluator().getProperty("script.arguments");
    }

    public static String getPhpArguments(PhpProject project) {
        return project.getEvaluator().getProperty("php.arguments");
    }

    public static String getWorkDir(PhpProject project) {
        return project.getEvaluator().getProperty("work.dir");
    }

    public static String getRemoteConnection(PhpProject project) {
        return project.getEvaluator().getProperty("remote.connection");
    }

    public static String getRemoteDirectory(PhpProject project) {
        return project.getEvaluator().getProperty("remote.directory");
    }

    public static boolean areRemotePermissionsPreserved(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "remote.permissions", false);
    }

    public static boolean isRemoteUploadDirectly(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "remote.upload.directly", false);
    }

    public static PhpProjectProperties.UploadFiles getRemoteUpload(PhpProject project) {
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String remoteUpload = project.getEvaluator().getProperty("remote.upload");
        assert (remoteUpload != null);
        try {
            uploadFiles = PhpProjectProperties.UploadFiles.valueOf(remoteUpload);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uploadFiles;
    }

    public static PhpProjectProperties.DebugUrl getDebugUrl(PhpProject project) {
        String debugUrl = project.getEvaluator().getProperty("debug.url");
        if (debugUrl == null) {
            return PhpProjectProperties.DebugUrl.DEFAULT_URL;
        }
        return PhpProjectProperties.DebugUrl.valueOf(debugUrl);
    }

    public static List<Pair<String, String>> getDebugPathMapping(PhpProject project) {
        List remotes = StringUtils.explode((String)ProjectPropertiesSupport.getString(project, "debug.path.mapping.remote", null), (String)"||NB||");
        List locals = StringUtils.explode((String)ProjectPropertiesSupport.getString(project, "debug.path.mapping.local", null), (String)"||NB||");
        int remotesSize = remotes.size();
        int localsSize = locals.size();
        ArrayList<Pair<String, String>> paths = new ArrayList<Pair<String, String>>(remotesSize);
        for (int i = 0; i < remotesSize; ++i) {
            String remotePath = (String)remotes.get(i);
            if (!StringUtils.hasText((String)remotePath)) continue;
            String l = "";
            if (i < localsSize) {
                l = (String)locals.get(i);
            }
            String localPath = null;
            File local = new File(l);
            if (local.isAbsolute()) {
                if (local.isDirectory()) {
                    localPath = local.getAbsolutePath();
                }
            } else {
                FileObject subDir = ProjectPropertiesSupport.getSourceSubdirectory(project, l);
                if (subDir != null && subDir.isValid()) {
                    localPath = FileUtil.toFile((FileObject)subDir).getAbsolutePath();
                }
            }
            if (localPath == null) continue;
            paths.add((Pair<String, String>)Pair.of((Object)remotePath, (Object)localPath));
        }
        Pair<String, String> copySupportPair = ProjectPropertiesSupport.getCopySupportPair(project);
        if (copySupportPair != null) {
            paths.add(copySupportPair);
        }
        return paths;
    }

    public static Pair<String, Integer> getDebugProxy(PhpProject project) {
        String host = ProjectPropertiesSupport.getString(project, "debug.proxy.host", null);
        if (!StringUtils.hasText((String)host)) {
            return null;
        }
        return Pair.of((Object)host, (Object)ProjectPropertiesSupport.getInt(project, "debug.proxy.port", 9001));
    }

    public static File getPhpUnitBootstrap(PhpProject project) {
        return ProjectPropertiesSupport.getFile(project, "phpunit.bootstrap");
    }

    public static boolean usePhpUnitBootstrapForCreateTests(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "phpunit.bootstrap.create.tests", false);
    }

    public static File getPhpUnitConfiguration(PhpProject project) {
        return ProjectPropertiesSupport.getFile(project, "phpunit.configuration");
    }

    public static File getPhpUnitSuite(PhpProject project) {
        return ProjectPropertiesSupport.getFile(project, "phpunit.suite");
    }

    public static boolean runAllTestFilesUsingPhpUnit(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "phpunit.run.test.files", false);
    }

    public static boolean askForTestGroups(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "phpunit.test.groups.ask", false);
    }

    public static String getPhpUnitLastUsedTestGroups(PhpProject project) {
        return ProjectPropertiesSupport.getString(project, "phpunit.test.groups.last.used", null);
    }

    private static Pair<String, String> getCopySupportPair(PhpProject project) {
        FileObject copySourceFo;
        File copySource;
        File copyTarget;
        Pair copySupportPair = null;
        if (ProjectPropertiesSupport.isCopySourcesEnabled(project) && (copyTarget = ProjectPropertiesSupport.getCopySourcesTarget(project)) != null && copyTarget.exists() && (copySource = FileUtil.toFile((FileObject)(copySourceFo = ProjectPropertiesSupport.getSourcesDirectory(project)))) != null && copySource.exists()) {
            copySupportPair = Pair.of((Object)copyTarget.getAbsolutePath(), (Object)copySource.getAbsolutePath());
        }
        return copySupportPair;
    }

    private static boolean getBoolean(PhpProject project, String property, boolean defaultValue) {
        String boolValue = project.getEvaluator().getProperty(property);
        if (StringUtils.hasText((String)boolValue)) {
            return Boolean.parseBoolean(boolValue);
        }
        return defaultValue;
    }

    private static String getString(PhpProject project, String property, String defaultValue) {
        String stringValue = project.getEvaluator().getProperty(property);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    private static int getInt(PhpProject project, String property, int defaultValue) {
        String stringValue = project.getEvaluator().getProperty(property);
        if (stringValue != null) {
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static File getFile(PhpProject project, String property) {
        String file = project.getEvaluator().getProperty(property);
        if (!StringUtils.hasText((String)file)) {
            return null;
        }
        return project.getHelper().resolveFile(file);
    }

    private static void saveTestSources(final PhpProject project, final String propertyName, final File testDir) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            AntProjectHelper helper = project.getHelper();
                            File projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
                            String testPath = PropertyUtils.relativizeFile((File)projectDirectory, (File)testDir);
                            if (testPath == null) {
                                testPath = testDir.getAbsolutePath();
                            }
                            EditableProperties projectProperties = helper.getProperties("nbproject/project.properties");
                            projectProperties.put(propertyName, testPath);
                            helper.putProperties("nbproject/project.properties", projectProperties);
                            ProjectManager.getDefault().saveProject((Project)project);
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
                }
            }
        });
    }
}

