/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ShowOppositeProfilingPointAction
extends SystemAction
implements ContextAwareAction {
    private static final String NO_END_DEFINED_MSG = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_NoEndDefinedMsg");
    private static final String NO_DATA_STRING = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_NoDataString");
    private static final String END_ACTION_NAME = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_EndActionName");
    private static final String START_ACTION_NAME = NbBundle.getMessage(ShowOppositeProfilingPointAction.class, (String)"ShowOppositeProfilingPointAction_StartActionName");

    public ShowOppositeProfilingPointAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.setEnabled(false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowOppositeProfilingPointAction.class);
    }

    public String getName() {
        return NO_DATA_STRING;
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection anns;
        InvocationLocationDescriptor desc;
        if (!ProfilingPointsManager.getDefault().isProfilingSessionInProgress() && (desc = this.getCurrentLocationDescriptor(anns = actionContext.lookupAll(CodeProfilingPoint.Annotation.class))) != null) {
            String name = desc.isStartLocation() ? END_ACTION_NAME : START_ACTION_NAME;
            return new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CodeProfilingPoint.Location oppositeLocation = desc.getOppositeLocation();
                    if (oppositeLocation != null) {
                        Utils.openLocation(oppositeLocation);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NO_END_DEFINED_MSG, 2));
                    }
                }
            };
        }
        return this;
    }

    private InvocationLocationDescriptor getCurrentLocationDescriptor(Collection<? extends CodeProfilingPoint.Annotation> anns) {
        if (anns.size() == 1) {
            CodeProfilingPoint pp = anns.iterator().next().profilingPoint();
            CodeProfilingPoint.Location currentLocation = Utils.getCurrentLocation(0);
            if (pp instanceof CodeProfilingPoint.Paired) {
                return new InvocationLocationDescriptor((CodeProfilingPoint.Paired)pp, currentLocation);
            }
        }
        return null;
    }

    private static class InvocationLocationDescriptor {
        private CodeProfilingPoint.Location location;
        private CodeProfilingPoint.Location oppositeLocation;
        private boolean isStartLocation;

        InvocationLocationDescriptor(CodeProfilingPoint.Paired profilingPoint, CodeProfilingPoint.Location location) {
            this.location = location;
            this.computeOppositeLocation(profilingPoint);
        }

        CodeProfilingPoint.Location getLocation() {
            return this.location;
        }

        CodeProfilingPoint.Location getOppositeLocation() {
            return this.oppositeLocation;
        }

        boolean isStartLocation() {
            return this.isStartLocation;
        }

        private void computeOppositeLocation(CodeProfilingPoint.Paired profilingPoint) {
            CodeProfilingPoint.Location startLocation = profilingPoint.getStartLocation();
            if (new File(startLocation.getFile()).equals(new File(this.location.getFile())) && startLocation.getLine() == this.location.getLine()) {
                this.oppositeLocation = profilingPoint.getEndLocation();
                this.isStartLocation = true;
            } else {
                this.oppositeLocation = profilingPoint.getStartLocation();
                this.isStartLocation = false;
            }
        }
    }
}

