/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleListener;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterImplementation;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.model.ApplicationMetadataModelImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public final class ProjectEar
extends J2eeApplicationProvider
implements ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener,
J2eeApplicationImplementation2 {
    public static final String FILE_DD = "application.xml";
    private static final Logger LOGGER = Logger.getLogger(ProjectEar.class.getName());
    private final ResourceChangeReporter rcr = ResourceChangeReporterFactory.createResourceChangeReporter((ResourceChangeReporterImplementation)new EarResourceChangeReporter());
    private final EarProject project;
    private PropertyChangeSupport propertyChangeSupport;
    private J2eeApplication j2eeApplication;
    private Application application;
    private MetadataModel<ApplicationMetadata> metadataModel;
    private final J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = new DeployOnSaveSupportProxy();
    final CopyOnSaveSupport copyOnSaveSupport = new CopyOnSaveSupport();
    private Map<String, J2eeModuleProvider> mods = new HashMap<String, J2eeModuleProvider>();
    private final List<ModuleListener> modListeners = new ArrayList<ModuleListener>();

    ProjectEar(EarProject earProject) {
        this.project = earProject;
        AntProjectHelper antProjectHelper = earProject.getAntProjectHelper();
    }

    public FileObject getDeploymentDescriptor() {
        FileObject fileObject = this.getMetaInf();
        if (fileObject != null) {
            return fileObject.getFileObject(FILE_DD);
        }
        return null;
    }

    public FileObject getMetaInf() {
        return this.project.getOrCreateMetaInfDir();
    }

    public File getResourceDirectory() {
        File file = this.project.getFile("resource.dir");
        if (file == null) {
            file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "setup");
        }
        return file;
    }

    public ClassPathProvider getClassPathProvider() {
        return (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
    }

    public FileObject getArchive() {
        return this.project.getFileObject("dist.jar");
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eeApplication == null) {
            this.j2eeApplication = J2eeModuleFactory.createJ2eeApplication((J2eeApplicationImplementation2)this);
        }
        return this.j2eeApplication;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.rcr;
    }

    public String getServerID() {
        return this.project.getServerID();
    }

    public void setServerInstanceID(String string) {
    }

    public String getServerInstanceID() {
        return this.project.getServerInstanceID();
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fileObject = this.getContentDirectory();
        fileObject.refresh();
        return new IT(this, fileObject);
    }

    public FileObject getContentDirectory() {
        return this.project.getFileObject("build.dir");
    }

    public FileObject getBuildDirectory() {
        return this.project.getFileObject("build.dir");
    }

    public synchronized MetadataModel<ApplicationMetadata> getMetadataModel() {
        if (this.metadataModel == null) {
            this.metadataModel = MetadataModelFactory.createMetadataModel((MetadataModelImplementation)new ApplicationMetadataModelImpl(this.project));
        }
        return this.metadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
        if (clazz == ApplicationMetadata.class) {
            MetadataModel<ApplicationMetadata> metadataModel = this.getMetadataModel();
            return metadataModel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getApplication() {
        try {
            if (EarProjectUtil.isDDCompulsory(this.project) || EarProjectUtil.isDDWritable(this.project)) {
                if (!EarProjectUtil.isDDCompulsory(this.project)) {
                    ProjectEar projectEar = this;
                    synchronized (projectEar) {
                        if (this.application != null) {
                            this.application = null;
                        }
                    }
                }
                return this.getDDFromFile();
            }
            return this.setupDDFromVirtual();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private Application getDDFromFile() throws IOException {
        FileObject fileObject = this.getDeploymentDescriptor();
        if (fileObject == null) {
            fileObject = EarProjectGenerator.setupDD(this.project.getJ2eeProfile(), this.getMetaInf(), this.project);
        }
        return DDProvider.getDefault().getDDRoot(fileObject);
    }

    private synchronized Application setupDDFromVirtual() throws IOException {
        if (EarProjectUtil.isDDWritable(this.project)) {
            return this.getApplication();
        }
        if (this.application != null) {
            return this.application;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-6.xml");
        assert (fileObject != null);
        FileObject fileObject2 = FileUtil.createMemoryFileSystem().getRoot();
        FileObject fileObject3 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)"application");
        this.application = DDProvider.getDefault().getDDRoot(fileObject3);
        this.application.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        for (ClassPathSupport.Item item : EarProjectProperties.getJarContentAdditional(this.project)) {
            EarProjectProperties.addItemToAppDD(this.project, this.application, item);
        }
        return this.application;
    }

    public EjbChangeDescriptor getEjbChanges(long l) {
        return this;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.EAR;
    }

    public String getModuleVersion() {
        Profile profile = Profile.fromPropertiesString((String)this.project.evaluator().getProperty("j2ee.platform"));
        if (profile == null) {
            profile = Profile.JAVA_EE_6_FULL;
        }
        if (Profile.JAVA_EE_5.equals(profile)) {
            return "5";
        }
        if (Profile.J2EE_14.equals(profile)) {
            return "1.4";
        }
        return "6";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("dd_version")) {
            String string = (String)propertyChangeEvent.getOldValue();
            String string2 = (String)propertyChangeEvent.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("moduleVersion", string, string2);
        } else if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
            Deployment deployment = Deployment.getDefault();
            String string = propertyChangeEvent.getOldValue() == null ? null : deployment.getServerID((String)propertyChangeEvent.getOldValue());
            String string3 = propertyChangeEvent.getNewValue() == null ? null : deployment.getServerID((String)propertyChangeEvent.getNewValue());
            this.fireServerChange(string, string3);
        } else if ("resource.dir".equals(propertyChangeEvent.getPropertyName())) {
            String string = (String)propertyChangeEvent.getOldValue();
            String string4 = (String)propertyChangeEvent.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("resourceDir", string == null ? null : new File(string), string4 == null ? null : new File(string4));
        }
    }

    public String getUrl() {
        return "";
    }

    public boolean isManifestChanged(long l) {
        return false;
    }

    public void setUrl(String string) {
        throw new UnsupportedOperationException("Cannot customize URL of web module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public Profile getJ2eeProfile() {
        return this.project.getJ2eeProfile();
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length + 1];
        fileObjectArray[0] = this.getMetaInf();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i + 1] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }

    void setModules(Map<String, J2eeModuleProvider> map) {
        if (null == map) {
            throw new IllegalArgumentException("mods");
        }
        this.mods = map;
    }

    public J2eeModule[] getModules() {
        J2eeModule[] j2eeModuleArray = new J2eeModule[this.mods.size()];
        int n = 0;
        for (J2eeModuleProvider j2eeModuleProvider : this.mods.values()) {
            j2eeModuleArray[n++] = j2eeModuleProvider.getJ2eeModule();
        }
        return j2eeModuleArray;
    }

    public void addModuleProvider(J2eeModuleProvider j2eeModuleProvider, String string) {
        this.mods.put(string, j2eeModuleProvider);
        J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
        this.fireAddModule(j2eeModule);
    }

    public void removeModuleProvider(J2eeModuleProvider j2eeModuleProvider, String string) {
        J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
        this.fireRemoveModule(j2eeModule);
        this.mods.remove(string);
    }

    private void fireAddModule(J2eeModule j2eeModule) {
        for (ModuleListener moduleListener : this.modListeners) {
            try {
                moduleListener.addModule(j2eeModule);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger("global").log(Level.INFO, runtimeException.getLocalizedMessage());
            }
        }
    }

    private void fireRemoveModule(J2eeModule j2eeModule) {
        for (ModuleListener moduleListener : this.modListeners) {
            try {
                moduleListener.removeModule(j2eeModule);
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger("global").log(Level.FINE, runtimeException.getLocalizedMessage());
            }
        }
    }

    public void addModuleListener(ModuleListener moduleListener) {
        this.modListeners.add(moduleListener);
    }

    public void removeModuleListener(ModuleListener moduleListener) {
        this.modListeners.remove(moduleListener);
    }

    public J2eeModuleProvider getChildModuleProvider(String string) {
        return this.mods.get(string);
    }

    public J2eeModuleProvider[] getChildModuleProviders() {
        return this.mods.values().toArray(new J2eeModuleProvider[this.mods.size()]);
    }

    public J2eeModuleProvider.DeployOnSaveSupport getDeployOnSaveSupport() {
        return this.deployOnSaveSupport;
    }

    public boolean isOnlyCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.compile.on.save")) && !Boolean.parseBoolean(this.project.evaluator().getProperty("j2ee.deploy.on.save"));
    }

    public File getDeploymentConfigurationFile(String string) {
        FileObject fileObject;
        String string2 = this.getConfigSupport().getContentRelativePath(string);
        if (string2 == null) {
            string2 = string;
        }
        if (string2.startsWith("META-INF/")) {
            string2 = string2.substring(8);
        }
        if ((fileObject = this.getMetaInf()) == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return new File(file, string2);
    }

    public void addEjbJarModule(EjbJar ejbJar) {
        FileObject fileObject = ejbJar.getDeploymentDescriptor();
        if (fileObject == null) {
            fileObject = ejbJar.getMetaInf();
        }
        this.addModule(fileObject);
    }

    public void addWebModule(WebModule webModule) {
        FileObject fileObject = webModule.getDeploymentDescriptor();
        if (fileObject == null) {
            fileObject = webModule.getWebInf();
        }
        this.addModule(fileObject);
    }

    public void addCarModule(Car car) {
        FileObject fileObject = car.getDeploymentDescriptor();
        if (fileObject == null) {
            fileObject = car.getMetaInf();
        }
        this.addModule(fileObject);
    }

    private void addModule(FileObject fileObject) {
        Project project = null;
        if (fileObject != null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        if (project == null) {
            LOGGER.log(Level.INFO, "Unable to add module to the Enterpise Application. Owner project not found.");
        } else {
            EarProjectProperties.addJ2eeSubprojects(this.project, new Project[]{project});
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeSupport getPropertyChangeSupport() {
        Application application = this.getApplication();
        ProjectEar projectEar = this;
        synchronized (projectEar) {
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this);
                if (application != null) {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)application);
                    application.addPropertyChangeListener(propertyChangeListener);
                }
            }
            return this.propertyChangeSupport;
        }
    }

    private class EarResourceChangeReporter
    implements ResourceChangeReporterImplementation {
        private EarResourceChangeReporter() {
        }

        public boolean isServerResourceChanged(long l) {
            File[] fileArray;
            File file = ProjectEar.this.getResourceDirectory();
            if (file != null && file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    if (file2.lastModified() <= l) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class DeployOnSaveSupportProxy
    implements ArtifactListener,
    J2eeModuleProvider.DeployOnSaveSupport {
        private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();

        public synchronized void addArtifactListener(ArtifactListener artifactListener) {
            ProjectEar.this.copyOnSaveSupport.addArtifactListener(artifactListener);
            boolean bl = this.listeners.isEmpty();
            if (artifactListener != null) {
                this.listeners.add(artifactListener);
            }
            if (bl) {
                for (J2eeModuleProvider j2eeModuleProvider : ProjectEar.this.getChildModuleProviders()) {
                    J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
                    if (deployOnSaveSupport == null) continue;
                    deployOnSaveSupport.addArtifactListener((ArtifactListener)this);
                }
            }
        }

        public synchronized void removeArtifactListener(ArtifactListener artifactListener) {
            ProjectEar.this.copyOnSaveSupport.removeArtifactListener(artifactListener);
            if (artifactListener != null) {
                this.listeners.remove(artifactListener);
            }
            if (this.listeners.isEmpty()) {
                for (J2eeModuleProvider j2eeModuleProvider : ProjectEar.this.getChildModuleProviders()) {
                    J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
                    if (deployOnSaveSupport == null) continue;
                    deployOnSaveSupport.removeArtifactListener((ArtifactListener)this);
                }
            }
        }

        public boolean containsIdeArtifacts() {
            for (J2eeModuleProvider j2eeModuleProvider : ProjectEar.this.getChildModuleProviders()) {
                J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
                if (deployOnSaveSupport == null || !deployOnSaveSupport.containsIdeArtifacts()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void artifactsUpdated(Iterable<ArtifactListener.Artifact> iterable) {
            File file;
            ArrayList<ArtifactListener.Artifact> arrayList = new ArrayList<ArtifactListener.Artifact>();
            for (ArtifactListener.Artifact object2 : iterable) {
                if (object2.isReferencedLibrary() && object2.isRelocatable()) {
                    file = ProjectEar.this.project.getAntProjectHelper().resolveFile(ProjectEar.this.project.evaluator().getProperty("build.dir"));
                    String string = object2.getRelocation();
                    File file2 = null;
                    file2 = string != null ? new File(file, string + File.separator + object2.getFile().getName()) : new File(file, object2.getFile().getName());
                    try {
                        FileUtil.createData((File)file2);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, "Could not prepare data file", iOException);
                        continue;
                    }
                    arrayList.add(object2.distributionPath(file2));
                    continue;
                }
                arrayList.add(object2);
            }
            Object object3 = null;
            DeployOnSaveSupportProxy deployOnSaveSupportProxy = this;
            synchronized (deployOnSaveSupportProxy) {
                object3 = new ArrayList<ArtifactListener>(this.listeners);
            }
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                file = (ArtifactListener)iterator.next();
                file.artifactsUpdated(arrayList);
            }
        }
    }

    public class CopyOnSaveSupport
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private File resources = null;
        private final List<ArtifactListener> listeners = new CopyOnWriteArrayList<ArtifactListener>();

        public void addArtifactListener(ArtifactListener artifactListener) {
            this.listeners.add(artifactListener);
        }

        public void removeArtifactListener(ArtifactListener artifactListener) {
            this.listeners.remove(artifactListener);
        }

        private boolean isCopyOnSaveEnabled() {
            return Boolean.parseBoolean(ProjectEar.this.project.evaluator().getProperty("j2ee.compile.on.save"));
        }

        public void initialize() throws FileStateInvalidException {
            ProjectEar.this.project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
            if (!this.isCopyOnSaveEnabled()) {
                return;
            }
            if (this.resources != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.resources);
            }
            this.resources = ProjectEar.this.getResourceDirectory();
            if (this.resources != null) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)this.resources);
            }
        }

        public void cleanup() throws FileStateInvalidException {
            if (this.resources != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.resources);
                this.resources = null;
            }
            ProjectEar.this.project.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("resource.dir".equals(propertyChangeEvent.getPropertyName()) || "j2ee.compile.on.save".equals(propertyChangeEvent.getPropertyName())) {
                try {
                    this.cleanup();
                    this.initialize();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOGGER.log(Level.INFO, null, fileStateInvalidException);
                }
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.handleResource(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.handleResource(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.handleResource((FileEvent)fileRenameEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.handleResource(fileEvent);
        }

        private void fireArtifactChange(Iterable<ArtifactListener.Artifact> iterable) {
            for (ArtifactListener artifactListener : this.listeners) {
                artifactListener.artifactsUpdated(iterable);
            }
        }

        private void handleResource(FileEvent fileEvent) {
            if (this.resources == null) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)this.resources);
            if (fileObject != null && (fileObject.equals(fileEvent.getFile()) || FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileEvent.getFile()))) {
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)FileUtil.toFile((FileObject)fileEvent.getFile())).serverResource()));
            }
        }
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject fileObject, FileObject fileObject2) {
            this.f = fileObject2;
            this.root = fileObject;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator {
        Iterator<FileObject> it;
        FileObject root;

        private IT(ProjectEar projectEar, FileObject fileObject) {
            String string;
            Object object;
            J2eeModule[] j2eeModuleArray = projectEar.getModules();
            HashSet<String> hashSet = new HashSet<String>(j2eeModuleArray.length);
            for (int i = 0; i < j2eeModuleArray.length; ++i) {
                object = null;
                try {
                    object = j2eeModuleArray[i].getArchive();
                }
                catch (IOException iOException) {
                    Logger.getLogger(ProjectEar.class.getName()).log(Level.FINER, null, iOException);
                    continue;
                }
                if (object == null) continue;
                string = object.getNameExt();
                long l = object.getSize();
                hashSet.add(string + "." + l);
            }
            ArrayList<String> arrayList = new ArrayList<String>(5);
            object = fileObject.getChildren(true);
            while (object.hasMoreElements()) {
                string = (FileObject)object.nextElement();
                String string2 = string.getNameExt();
                long l = string.getSize();
                if (hashSet.contains(string2 + "." + l)) continue;
                arrayList.add(string);
            }
            this.root = fileObject;
            this.it = arrayList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return new FSRootRE(this.root, this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

