/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Properties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class NetBeansRunParamsIDEChecker
implements PrerequisitesChecker {
    private static final String MASTER_PROPERTY = "netbeans.run.params";
    static final String PROPERTY = "netbeans.run.params.ide";
    private static final String ADDITIONAL_ARGUMENTS = "additionalArguments";

    public boolean checkRunConfig(RunConfig config) {
        String goal;
        String eval;
        String val = (String)config.getProperties().get(PROPERTY);
        if (val == null) {
            return true;
        }
        MavenProject prj = config.getMavenProject();
        try {
            eval = (String)new NBPluginParameterExpressionEvaluator(prj, new Settings(), config.getProperties()).evaluate(val);
        }
        catch (ExpressionEvaluationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
        String text = null;
        Iterator i$ = config.getGoals().iterator();
        while (i$.hasNext() && (text = PluginPropertyUtils.getPluginProperty((MavenProject)prj, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)ADDITIONAL_ARGUMENTS, (String)(goal = (String)i$.next()))) == null) {
        }
        if (text == null) {
            text = prj.getProperties().getProperty(MASTER_PROPERTY);
        }
        if (text == null || !text.contains(eval)) {
            NetBeansRunParamsIDEChecker.missingInterpolation(prj.getFile());
            return false;
        }
        return true;
    }

    private static void missingInterpolation(File pom) {
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.NetBeansRunParamsIDEChecker_msg_confirm(PROPERTY, pom), Bundle.NetBeansRunParamsIDEChecker_title_confirm(), 2)) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        Utilities.performPOMModelOperations((FileObject)FileUtil.toFileObject((File)pom), Collections.singletonList(new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                POMComponentFactory factory = model.getFactory();
                Project project = model.getProject();
                Properties properties = project.getProperties();
                if (properties == null) {
                    properties = factory.createProperties();
                    project.setProperties(properties);
                }
                if (properties.getProperty(NetBeansRunParamsIDEChecker.PROPERTY) == null) {
                    properties.setProperty(NetBeansRunParamsIDEChecker.PROPERTY, "");
                }
                String args = properties.getProperty(NetBeansRunParamsIDEChecker.MASTER_PROPERTY);
                String ref = "${netbeans.run.params.ide}";
                if (args == null) {
                    args = ref;
                } else if (!args.contains(ref)) {
                    args = args + " " + ref;
                }
                properties.setProperty(NetBeansRunParamsIDEChecker.MASTER_PROPERTY, args);
            }
        }));
    }
}

