/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AccessQueryImpl
implements AccessibilityQueryImplementation {
    private NbMavenProject mavenProject;
    private Project project;
    private WeakReference<List<Pattern>> ref;
    private static final String MANIFEST_PATH = "src/main/nbm/manifest.mf";
    private static final String ATTR_PUBLIC_PACKAGE = "OpenIDE-Module-Public-Packages";

    public AccessQueryImpl(Project prj) {
        this.project = prj;
        this.mavenProject = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isPubliclyAccessible(FileObject pkg) {
        String path;
        FileObject srcdir = FileUtilities.convertStringToFileObject((String)this.mavenProject.getMavenProject().getBuild().getSourceDirectory());
        if (srcdir != null && (path = FileUtil.getRelativePath((FileObject)srcdir, (FileObject)pkg)) != null) {
            String name = path.replace('/', '.');
            List<Pattern> pp = this.getPublicPackagesPatterns();
            return this.check(pp, name);
        }
        return null;
    }

    private boolean check(List<Pattern> patt, String value) {
        Pattern pattern;
        boolean matches = false;
        Iterator<Pattern> i$ = patt.iterator();
        while (i$.hasNext() && !(matches = (pattern = i$.next()).matcher(value).matches())) {
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pattern> getPublicPackagesPatterns() {
        List patterns;
        if (this.ref != null && (patterns = (List)this.ref.get()) != null) {
            return patterns;
        }
        List<Object> toRet = new ArrayList();
        String[] params = PluginPropertyUtils.getPluginPropertyList((Project)this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"publicPackages", (String)"publicPackage", (String)"manifest");
        if (params != null) {
            toRet = AccessQueryImpl.preparePublicPackagesPatterns(params);
        } else {
            FileObject obj = this.project.getProjectDirectory().getFileObject(MANIFEST_PATH);
            if (obj != null) {
                InputStream in = null;
                try {
                    in = obj.getInputStream();
                    Manifest man = new Manifest();
                    man.read(in);
                    String value = man.getMainAttributes().getValue(ATTR_PUBLIC_PACKAGE);
                    toRet = AccessQueryImpl.preparePublicPackagesPatterns(value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    IOUtil.close((InputStream)in);
                }
            }
        }
        this.ref = new WeakReference(toRet);
        return toRet;
    }

    static List<Pattern> preparePublicPackagesPatterns(String[] values) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        for (String token : values) {
            token = token.trim();
            boolean recursive = false;
            if (token.endsWith(".**")) {
                token = token.substring(0, token.length() - ".**".length());
                recursive = true;
            }
            token = token.replace(".", "\\.");
            if (recursive) {
                token = token + ".*";
            }
            toRet.add(Pattern.compile(token));
        }
        return toRet;
    }

    static List<Pattern> preparePublicPackagesPatterns(String value) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, " ,", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                token = token.trim();
                boolean recursive = false;
                if (token.endsWith(".*")) {
                    token = token.substring(0, token.length() - ".*".length());
                    recursive = false;
                } else if (token.endsWith(".**")) {
                    token = token.substring(0, token.length() - ".**".length());
                    recursive = true;
                }
                token = token.replace(".", "\\.");
                if (recursive) {
                    token = token + ".*";
                }
                toRet.add(Pattern.compile(token));
            }
        }
        return toRet;
    }
}

