/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.wizards;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.ejbjarproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.java.api.common.project.ui.wizards.FolderList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 17605310116880120L;
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    private File oldProjectLocation;
    private final DocumentListener configAndLibrariesListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelSourceFolders.this.dataChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelSourceFolders.this.dataChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelSourceFolders.this.dataChanged();
        }
    };
    private JButton jButtonConfigFilesLocation;
    private JButton jButtonLibraries;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextFieldConfigFiles;
    private JTextField jTextFieldLibraries;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_ImportEJBModule"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel, FolderList.testRootsFilter());
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        this.jTextFieldConfigFiles.getDocument().addDocumentListener(this.configAndLibrariesListener);
        this.jTextFieldLibraries.getDocument().addDocumentListener(this.configAndLibrariesListener);
    }

    public void initValues(FileObject fo) {
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fo));
        FileObject confFO = FileSearchUtility.guessConfigFilesPath((FileObject)fo, (String)"ejb-jar.xml");
        if (confFO != null) {
            String configFiles = FileUtil.toFile((FileObject)confFO).getAbsolutePath();
            this.jTextFieldConfigFiles.setText(configFiles);
        }
        FileObject librariesFO = FileSearchUtility.guessLibrariesFolder((FileObject)fo);
        if (librariesFO != null) {
            String libraries = FileUtil.toFile((FileObject)librariesFO).getAbsolutePath();
            this.jTextFieldLibraries.setText(libraries);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("files".equals(evt.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(evt.getPropertyName())) {
            if (evt.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)evt.getNewValue());
            } else if (evt.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)evt.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        File projectLocation = (File)settings.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(projectLocation);
        ((FolderList)this.testsPanel).setProjectFolder(projectLocation);
        if (!projectLocation.equals(this.oldProjectLocation)) {
            File[] testRoot;
            File[] srcRoot = (File[])settings.getProperty("javaRoot");
            if (srcRoot != null) {
                ((FolderList)this.sourcePanel).setFiles(srcRoot);
            }
            if ((testRoot = (File[])settings.getProperty("testRoot")) != null) {
                ((FolderList)this.testsPanel).setFiles(testRoot);
            }
            this.initValues(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectLocation)));
            this.oldProjectLocation = projectLocation;
        }
    }

    @Override
    void store(WizardDescriptor settings) {
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        settings.putProperty("javaRoot", (Object)sourceRoots);
        settings.putProperty("testRoot", (Object)testRoots);
        settings.putProperty("configFilesFolder", (Object)this.getConfigFiles());
        settings.putProperty("libFolder", (Object)this.getLibraries());
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        File confFolder = this.getConfigFiles();
        if (confFolder == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_BlankConfigurationFilesFolder"));
            return false;
        }
        File[] sourceRoots = ((FolderList)this.sourcePanel).getFiles();
        if (sourceRoots.length == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_BlankSourceFilesFolder"));
            return false;
        }
        File[] testRoots = ((FolderList)this.testsPanel).getFiles();
        String result = PanelSourceFolders.checkValidity(projectLocation, confFolder, this.getLibraries(), sourceRoots, testRoots);
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(File projectLocation, File configFilesLocation, File librariesLocation, File[] sources, File[] tests) {
        int i;
        FileObject fo;
        String ploc = projectLocation.getAbsolutePath();
        if (!(configFilesLocation == null || (fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)configFilesLocation))) != null && fo.isFolder())) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalConfigurationFilesFolder");
        }
        if (!(librariesLocation == null || (fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)librariesLocation))) != null && fo.isFolder())) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalLibrariesFolder");
        }
        if (sources.length == 0) {
            return " ";
        }
        for (i = 0; i < sources.length; ++i) {
            if (!sources[i].isDirectory() || !sources[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), sources[i].getAbsolutePath());
            }
            String sloc = sources[i].getAbsolutePath();
            if (!ploc.equals(sloc) && !ploc.startsWith(sloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (i = 0; i < tests.length; ++i) {
            if (!tests[i].isDirectory() || !tests[i].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), sources[i].getAbsolutePath());
            }
            String tloc = tests[i].getAbsolutePath();
            if (!ploc.equals(tloc) && !ploc.startsWith(tloc + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        boolean found = false;
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            if (folder == null) continue;
            Enumeration en = folder.getData(true);
            while (!found && en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                found = "class".equals(fo.getExt());
            }
        }
        if (found) {
            String DELETE_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            String KEEP_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            String CANCEL_OPTION = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, null);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                this.deleteClassFiles(folders);
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            Enumeration en = folder.getData(true);
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                assert (obj instanceof FileObject) : "Instance of FileObject: " + obj;
                FileObject fo = (FileObject)obj;
                try {
                    if (!"class".equals(fo.getExt())) continue;
                    fo.delete();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.jLabel1 = new JLabel();
        this.jTextFieldConfigFiles = new JTextField();
        this.jButtonConfigFilesLocation = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        this.jLabel1.setLabelFor(this.jTextFieldConfigFiles);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("LBL_IW_ConfigFilesFolder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConfigFilesLocation, (String)bundle.getString("LBL_NWP1_BrowseLocation_Button_w"));
        this.jButtonConfigFilesLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonConfigFilesLocationActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.jTextFieldLibraries);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("LBL_IW_LibrariesLocation_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonLibraries, (String)bundle.getString("LBL_NWP1_BrowseLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)bundle.getString("LBL_IW_DragAndDrop"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldLibraries, GroupLayout.Alignment.TRAILING, -1, 242, Short.MAX_VALUE).addComponent(this.jTextFieldConfigFiles, GroupLayout.Alignment.TRAILING, -1, 242, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonConfigFilesLocation, GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLibraries, GroupLayout.Alignment.TRAILING))).addComponent(this.sourcePanel, -1, 551, Short.MAX_VALUE).addComponent(this.testsPanel, -1, 551, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 551, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 551, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldConfigFiles, -2, -1, -2).addComponent(this.jButtonConfigFilesLocation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldLibraries, -2, -1, -2).addComponent(this.jButtonLibraries)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourcePanel, -1, 75, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.testsPanel, -1, 75, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2)));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void jButtonLibrariesActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            chooser.setSelectedFile(this.getLibraries());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File configFilesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldLibraries.setText(configFilesDir.getAbsolutePath());
        }
    }

    private void jButtonConfigFilesLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.jTextFieldConfigFiles.getText().length() > 0 && this.getConfigFiles().exists()) {
            chooser.setSelectedFile(this.getConfigFiles());
        } else {
            chooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == chooser.showOpenDialog(this)) {
            File configFilesDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextFieldConfigFiles.setText(configFilesDir.getAbsolutePath());
        }
    }

    private File getAsFile(String filename) {
        if (filename != null && filename.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(filename));
        }
        return null;
    }

    public File getConfigFiles() {
        return this.getAsFile(this.jTextFieldConfigFiles.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }
    }
}

