/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.JavaClassRenameTransaction;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class HibernateMovePlugin
implements RefactoringPlugin {
    private MoveRefactoring refactoring;
    private Project project;

    public HibernateMovePlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        try {
            URL targetURL = (URL)this.refactoring.getTarget().lookup(URL.class);
            if (targetURL == null) {
                return null;
            }
            if (this.refactoring.getRefactoringSource().lookupAll(FileObject.class).isEmpty()) {
                return null;
            }
            String targetPackageName = HibernateRefactoringUtil.getPackageName(targetURL);
            if (targetPackageName == null) {
                return null;
            }
            ArrayList<String> oldPackageNames = new ArrayList<String>();
            ArrayList<String> oldClassNames = new ArrayList<String>();
            for (FileObject fo : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
                if (this.project == null) {
                    this.project = FileOwnerQuery.getOwner((FileObject)fo);
                }
                if (fo.isFolder()) {
                    String oldPackageName = HibernateRefactoringUtil.getPackageName(fo);
                    if (oldPackageName == null) continue;
                    oldPackageNames.add(oldPackageName);
                    continue;
                }
                if (!HibernateRefactoringUtil.isJavaFile(fo)) continue;
                List<String> classNames = HibernateRefactoringUtil.getTopLevelClassNames(fo);
                oldClassNames.addAll(classNames);
            }
            HibernateEnvironment env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (env == null) {
                return null;
            }
            List<FileObject> mappingFileObjs = env.getAllHibernateMappingFileObjects();
            if (mappingFileObjs == null || mappingFileObjs.size() == 0) {
                return null;
            }
            for (String oldBinaryName : oldClassNames) {
                String simpleClassName = HibernateRefactoringUtil.getSimpleElementName(oldBinaryName);
                String newBinaryName = HibernateRefactoringUtil.createQualifiedName(targetPackageName, simpleClassName);
                if (newBinaryName == null) continue;
                Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaClassOccurrences(mappingFileObjs, oldBinaryName);
                for (FileObject mFileObj : occurrences.keySet()) {
                    List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                    for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                        HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(mFileObj, oldBinaryName, newBinaryName, foundPlace.getLocation(), foundPlace.getText());
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                    }
                }
                refactoringElements.registerTransaction((Transaction)new JavaClassRenameTransaction(occurrences.keySet(), oldBinaryName, newBinaryName));
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }
}

