/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ant;

import java.io.File;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class StartProfiledServer
extends Task
implements Deployment.Logger {
    private static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private boolean forceRestart;
    private int startupTimeout = 180000;
    private String javaPlatform;
    private CommandlineJava jvmarg = new CommandlineJava();
    private Environment env = new Environment();

    public void execute() throws BuildException {
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler == null) {
            String msg = NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_ProfierNotFound");
            throw new BuildException(msg);
        }
        JavaPlatform[] installedPlatforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        JavaPlatform platform = null;
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(this.javaPlatform)) continue;
            platform = installedPlatforms[i];
        }
        if (platform == null) {
            String msg = NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_PlatformNotFound", (Object)this.javaPlatform);
            throw new BuildException(msg);
        }
        String[] envvar = this.env.getVariables();
        if (envvar == null) {
            envvar = new String[]{};
        }
        ProfilerServerSettings settings = new ProfilerServerSettings(platform, this.jvmarg.getVmCommand().getArguments(), envvar);
        FileObject fo = FileUtil.toFileObject((File)this.getProject().getBaseDir());
        fo.refresh();
        J2eeModuleProvider jmp = (J2eeModuleProvider)FileOwnerQuery.getOwner((FileObject)fo).getLookup().lookup(J2eeModuleProvider.class);
        ServerInstance si = ServerRegistry.getInstance().getServerInstance(jmp.getServerInstanceID());
        if (!si.startProfile(settings, this.forceRestart, (Deployment.Logger)this)) {
            String msg = NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_StartupFailed");
            throw new BuildException(msg);
        }
        this.log(NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_AttachingProfiler"));
        if (!profiler.attachProfiler((Map)this.getProject().getProperties())) {
            String msg = NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_AttachFailed");
            throw new BuildException(msg);
        }
        this.log(NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_ProfilerAttached"));
        long timeout = System.currentTimeMillis() + (long)this.startupTimeout;
        while (profiler.getState() != 0) {
            if (si.isRunning()) {
                this.log(NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_ServerUp"));
                si.refresh();
                return;
            }
            if (System.currentTimeMillis() > timeout) {
                String msg = NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_StartTimedOut", (Object)String.valueOf(Math.round(this.startupTimeout / 1000)));
                throw new BuildException(msg);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {}
        }
        throw new BuildException(NbBundle.getMessage((Class)StartProfiledServer.class, (String)"MSG_StartupFailed"));
    }

    public void setForceRestart(boolean forceRestart) {
        this.forceRestart = forceRestart;
    }

    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    public void setJavaPlatform(String javaPlatform) {
        this.javaPlatform = javaPlatform;
    }

    public Commandline.Argument createJvmarg() {
        return this.jvmarg.createVmArgument();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }
}

