/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.libraries.Util;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.NamedLibraryImplementation;
import org.openide.util.WeakListeners;

public class ProxyLibraryImplementation
implements NamedLibraryImplementation,
PropertyChangeListener {
    private final LibraryImplementation original;
    private final LibrariesModel model;
    Map<String, List<URL>> newContents;
    private String newName;
    private String newDisplayName;
    private String newDescription;
    private PropertyChangeSupport support;

    private ProxyLibraryImplementation(LibraryImplementation original, LibrariesModel model) {
        assert (original != null && model != null);
        this.original = original;
        this.model = model;
        this.original.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.original));
        this.support = new PropertyChangeSupport(this);
    }

    public static ProxyLibraryImplementation createProxy(LibraryImplementation original, LibrariesModel model) {
        if (original instanceof LibraryImplementation2) {
            return new ProxyLibraryImplementation2((LibraryImplementation2)original, model);
        }
        return new ProxyLibraryImplementation(original, model);
    }

    protected LibrariesModel getModel() {
        return this.model;
    }

    protected PropertyChangeSupport getSupport() {
        return this.support;
    }

    public LibraryImplementation getOriginal() {
        return this.original;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public String getType() {
        return this.original.getType();
    }

    @Override
    public synchronized List<URL> getContent(String volumeType) throws IllegalArgumentException {
        List<URL> result = null;
        if (this.newContents == null || (result = this.newContents.get(volumeType)) == null) {
            return this.original.getContent(volumeType);
        }
        return result;
    }

    @Override
    public synchronized String getDescription() {
        if (this.newDescription != null) {
            return this.newDescription;
        }
        return this.original.getDescription();
    }

    @Override
    public synchronized String getName() {
        if (this.newName != null) {
            return this.newName;
        }
        return this.original.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        if (!Util.supportsDisplayName(this.original)) {
            throw new IllegalStateException("Original does not support displayName");
        }
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            return this.newDisplayName != null ? this.newDisplayName : Util.getDisplayName(this.original);
        }
    }

    @Override
    public synchronized void setContent(String volumeType, List<URL> path) throws IllegalArgumentException {
        if (this.newContents == null) {
            this.newContents = new HashMap<String, List<URL>>();
        }
        this.newContents.put(volumeType, path);
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("content", null, null);
    }

    @Override
    public synchronized void setDescription(String text) {
        String oldDescription = this.newDescription == null ? this.original.getDescription() : this.newDescription;
        this.newDescription = text;
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("description", oldDescription, this.newDescription);
    }

    @Override
    public synchronized void setName(String name) {
        String oldName = this.newName == null ? this.original.getName() : this.newName;
        this.newName = name;
        this.model.modifyLibrary(this);
        this.support.firePropertyChange("name", oldName, this.newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayName(@NullAllowed String displayName) {
        String oldName;
        ProxyLibraryImplementation proxyLibraryImplementation = this;
        synchronized (proxyLibraryImplementation) {
            oldName = this.newDisplayName != null ? this.newDisplayName : Util.getDisplayName(this.original);
            this.newDisplayName = displayName;
            this.model.modifyLibrary(this);
        }
        this.support.firePropertyChange("displayName", oldName, displayName);
    }

    @Override
    public String getLocalizingBundle() {
        return this.original.getLocalizingBundle();
    }

    @Override
    public void setLocalizingBundle(String resourceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.support.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProxyLibraryImplementation) {
            return this.original.equals(((ProxyLibraryImplementation)obj).getOriginal());
        }
        return false;
    }

    public String toString() {
        return "Proxy[" + this.original + "]";
    }

    static class ProxyLibraryImplementation2
    extends ProxyLibraryImplementation
    implements LibraryImplementation2,
    NamedLibraryImplementation {
        Map<String, List<URI>> newURIContents;

        public ProxyLibraryImplementation2(LibraryImplementation2 original, LibrariesModel model) {
            super(original, model);
        }

        LibraryImplementation2 getOriginal2() {
            return (LibraryImplementation2)this.getOriginal();
        }

        @Override
        public List<URI> getURIContent(String volumeType) throws IllegalArgumentException {
            List<URI> result = null;
            if (this.newURIContents == null || (result = this.newURIContents.get(volumeType)) == null) {
                return this.getOriginal2().getURIContent(volumeType);
            }
            return result;
        }

        @Override
        public void setURIContent(String volumeType, List<URI> path) throws IllegalArgumentException {
            if (this.newURIContents == null) {
                this.newURIContents = new HashMap<String, List<URI>>();
            }
            this.newURIContents.put(volumeType, path);
            this.getModel().modifyLibrary(this);
            this.getSupport().firePropertyChange("content", null, null);
        }

        @Override
        public final int hashCode() {
            return this.getOriginal().hashCode();
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj instanceof ProxyLibraryImplementation2) {
                return this.getOriginal().equals(((ProxyLibraryImplementation2)obj).getOriginal());
            }
            return false;
        }

        @Override
        public String toString() {
            return "Proxy2[" + this.getOriginal() + "]";
        }
    }
}

