/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentDescriptorWizardPanel;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NewComponentDescriptor;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.Version;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ComponentDescriptorVisualPanel
extends JPanel {
    public static final String TXT_DEFAULT_PREFIX = "TXT_DefaultClassNamePrefix";
    private static final String MSG_ERR_PREFIX_EMPTY = "MSG_CD_EmptyPrefix";
    private static final String MSG_ERR_PREFIX_WITH_DOT = "MSG_CD_DotInPrefix";
    private static final String MSG_ERR_PREFIX_INVALID = "MSG_CD_InvalidPrefix";
    private static final String MSG_ERR_CLASS_NAME_EMPTY = "MSG_CD_EmptyClassName";
    private static final String MSG_ERR_CLASS_NAME_INVALID = "MSG_CD_InvalidClassName";
    private static final String MSG_ERR_CLASS_NAME_EXISTS = "MSG_CD_ExistingClassName";
    private static final String MSG_ERR_TYPE_ID_EMPTY = "MSG_CD_EmptyTypeID";
    private static final String MSG_ERR_SUPER_CLASS_EMPTY = "MSG_CD_EmptySuperClass";
    private static final String MSG_ERR_SUPER_CLASS_INVALID = "MSG_CD_InvalidSuperClass";
    private JTextField myCDClassName;
    private JLabel myCDClassNameLabel;
    private JTextField myCDSuperClass;
    private JLabel myCDSuperClassLabel;
    private JTextField myCDTypeId;
    private JLabel myCDTypeIdLabel;
    private JComboBox myCDVersionCombo;
    private JLabel myCDVersionLabel;
    private JCheckBox myCanBeSuperChk;
    private JCheckBox myCanInstantiateChk;
    private JPanel myCompDescrPanel;
    private JPanel myCustCompPanel;
    private JPanel myCustCompPrefixPanel;
    private JTextField myPrefix;
    private JLabel myPrefixLabel;
    private WizardDescriptor mySettings;
    private ComponentDescriptorWizardPanel myPanel;
    private boolean isCDClassNameUpdated;
    private boolean isCDTypeIdUpdated;
    private boolean listenersAttached;
    private DocumentListener myPrefixListener;
    private DocumentListener myClassNAmeListener;
    private DocumentListener myTypeIdListener;
    private DocumentListener mySuperClassListener;

    ComponentDescriptorVisualPanel(ComponentDescriptorWizardPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        this.myCDVersionCombo.setModel(Version.getComboBoxModel());
        this.myPrefixListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentDescriptorVisualPanel.this.updateValuesOnPrefixUpdate();
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.myClassNAmeListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentDescriptorVisualPanel.this.isCDClassNameUpdated = true;
                ComponentDescriptorVisualPanel.this.updateValuesOnClassNameUpdate();
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.myTypeIdListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentDescriptorVisualPanel.this.isCDTypeIdUpdated = true;
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
        this.mySuperClassListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComponentDescriptorVisualPanel.this.checkValidity();
            }
        };
    }

    void storeData(WizardDescriptor descriptor) {
        descriptor.putProperty("prefix", (Object)this.getPrefixValue());
        descriptor.putProperty("compDescrClassName", (Object)this.getClassNameValue());
        descriptor.putProperty("compDescrTypeId", (Object)this.getTypeIdValue());
        descriptor.putProperty("compDescrSuperClass", (Object)this.getSuperDescrValue());
        descriptor.putProperty("compDescrVersion", (Object)this.getVersionValue());
        descriptor.putProperty("compDescrCanInstantiate", (Object)this.getCanInstantiateValue());
        descriptor.putProperty("compDescrCanBeSuper", (Object)this.getCanBeSuperValue());
    }

    void readData(WizardDescriptor descriptor) {
        this.mySettings = descriptor;
        this.myPrefix.setText(this.getPrefix());
        if (this.getClassName() != null) {
            this.myCDClassName.setText(this.getClassName());
        }
        if (this.getTypeId() != null) {
            this.myCDTypeId.setText(this.getTypeId());
        }
        this.myCDSuperClass.setText(this.getSuperDescriptor());
        this.myCDVersionCombo.setSelectedItem((Object)this.getVersion());
        this.myCanInstantiateChk.setSelected(this.getCanInstantiate());
        this.myCanBeSuperChk.setSelected(this.getCanBeSuper());
        this.updateValuesOnPrefixUpdate();
        this.checkValidity();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
        this.checkValidity();
    }

    @Override
    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.myPrefix.getDocument().addDocumentListener(this.myPrefixListener);
            this.myCDClassName.getDocument().addDocumentListener(this.myClassNAmeListener);
            this.myCDTypeId.getDocument().addDocumentListener(this.myTypeIdListener);
            this.myCDSuperClass.getDocument().addDocumentListener(this.mySuperClassListener);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.myPrefix.getDocument().removeDocumentListener(this.myPrefixListener);
            this.myCDClassName.getDocument().removeDocumentListener(this.myClassNAmeListener);
            this.myCDTypeId.getDocument().removeDocumentListener(this.myTypeIdListener);
            this.myCDSuperClass.getDocument().removeDocumentListener(this.mySuperClassListener);
            this.listenersAttached = false;
        }
    }

    private String getTypeId() {
        return (String)this.mySettings.getProperty("compDescrTypeId");
    }

    private String getClassName() {
        return (String)this.mySettings.getProperty("compDescrClassName");
    }

    private String getSuperDescriptor() {
        String superDescr = (String)this.mySettings.getProperty("compDescrSuperClass");
        if (superDescr == null) {
            superDescr = "org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD";
        }
        return superDescr;
    }

    private boolean getCanInstantiate() {
        Object value = this.mySettings.getProperty("compDescrCanInstantiate");
        return ComponentDescriptorVisualPanel.extractBoolean(value, true);
    }

    private boolean getCanBeSuper() {
        Object value = this.mySettings.getProperty("compDescrCanBeSuper");
        return ComponentDescriptorVisualPanel.extractBoolean(value, true);
    }

    private static boolean extractBoolean(Object value, boolean defaultValue) {
        if (value == null || !(value instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    private String getPrefix() {
        String prefix = (String)this.mySettings.getProperty("prefix");
        if (prefix == null) {
            prefix = this.getDefaultPrefix();
        }
        return prefix;
    }

    private String getDefaultPrefix() {
        String prefixProposal = ComponentDescriptorVisualPanel.getMessage(TXT_DEFAULT_PREFIX, new Object[0]);
        int index = 1;
        String prefix = this.getDefaultFreePrefix(prefixProposal, "");
        while (prefix == null) {
            prefix = this.getDefaultFreePrefix(prefixProposal, "" + index);
            ++index;
        }
        return prefix;
    }

    private String getDefaultFreePrefix(String prefix, String index) {
        String proposal = prefix + index;
        String cdClass = NewComponentDescriptor.createDefaultCDClass(proposal);
        String producerClass = NewComponentDescriptor.createDefaultProducerClass(proposal);
        if (this.getHelper().isCDClassNameExist(cdClass) || this.getHelper().isProducerClassNameExist(producerClass)) {
            proposal = null;
        }
        return proposal;
    }

    private Version getVersion() {
        Object value = this.mySettings.getProperty("compDescrVersion");
        if (value == null || !(value instanceof Version)) {
            return Version.MIDP;
        }
        return (Version)((Object)value);
    }

    private boolean checkValidity() {
        if (!this.isCCPrefixValid()) {
            return false;
        }
        if (!this.isCCClassNameValid()) {
            return false;
        }
        if (!this.isCCTypeIDValid()) {
            return false;
        }
        if (!this.isCCSuperClassValid()) {
            return false;
        }
        this.markValid();
        return true;
    }

    private void updateValuesOnPrefixUpdate() {
        if (this.isCCPrefixValid()) {
            if (!this.isCDClassNameUpdated) {
                this.myCDClassName.setText(NewComponentDescriptor.createDefaultCDClass(this.getPrefixValue()));
                this.isCDClassNameUpdated = false;
            }
            if (!this.isCDTypeIdUpdated) {
                this.myCDTypeId.setText(this.getCodeNameBase() + "." + this.getPrefixValue());
                this.isCDTypeIdUpdated = false;
            }
        }
    }

    private void updateValuesOnClassNameUpdate() {
        if (this.isCCClassNameValid() && !this.isCDTypeIdUpdated) {
            this.myCDTypeId.setText(this.getCodeNameBase() + "." + this.getPrefixValue());
            this.isCDTypeIdUpdated = false;
        }
    }

    private String getCodeNameBase() {
        return this.getHelper().getCodeNameBase();
    }

    private CustomComponentHelper getHelper() {
        return (CustomComponentHelper)this.mySettings.getProperty("custCompHelper");
    }

    private boolean isCCClassNameValid() {
        String name = this.getClassNameValue();
        if (name.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EMPTY, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)name)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_INVALID, new Object[0]));
            return false;
        }
        if (this.getHelper().isCDClassNameExist(name)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_CLASS_NAME_EXISTS, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCTypeIDValid() {
        String typeId = this.getTypeIdValue();
        if (typeId.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_TYPE_ID_EMPTY, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCSuperClassValid() {
        String name = this.getSuperDescrValue();
        if (name.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_SUPER_CLASS_EMPTY, new Object[0]));
            return false;
        }
        if (!UIUtils.isValidJavaFQN(name)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_SUPER_CLASS_INVALID, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCCPrefixValid() {
        String prefix = this.getPrefixValue();
        if (prefix.length() == 0) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_EMPTY, new Object[0]));
            return false;
        }
        if (prefix.contains(".")) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_WITH_DOT, new Object[0]));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)prefix)) {
            this.setError(ComponentDescriptorVisualPanel.getMessage(MSG_ERR_PREFIX_INVALID, new Object[0]));
            return false;
        }
        return true;
    }

    private String getPrefixValue() {
        return this.myPrefix.getText().trim();
    }

    private String getClassNameValue() {
        return this.myCDClassName.getText().trim();
    }

    private String getTypeIdValue() {
        return this.myCDTypeId.getText().trim();
    }

    private String getSuperDescrValue() {
        return this.myCDSuperClass.getText().trim();
    }

    private Version getVersionValue() {
        return (Version)((Object)this.myCDVersionCombo.getSelectedItem());
    }

    private Boolean getCanInstantiateValue() {
        return this.myCanInstantiateChk.isSelected();
    }

    private Boolean getCanBeSuperValue() {
        return this.myCanBeSuperChk.isSelected();
    }

    protected final void setError(String message) {
        assert (message != null);
        this.setMessage(message);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String message) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private final void setValid(boolean valid) {
        this.myPanel.setValid(valid);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ComponentDescriptorVisualPanel.class);
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)key, (Object[])args);
    }

    private void initComponents() {
        this.myCustCompPanel = new JPanel();
        this.myCustCompPrefixPanel = new JPanel();
        this.myPrefixLabel = new JLabel();
        this.myPrefix = new JTextField();
        this.myCompDescrPanel = new JPanel();
        this.myCDVersionLabel = new JLabel();
        this.myCDVersionCombo = new JComboBox();
        this.myCDClassNameLabel = new JLabel();
        this.myCDTypeIdLabel = new JLabel();
        this.myCDSuperClassLabel = new JLabel();
        this.myCDSuperClass = new JTextField();
        this.myCDTypeId = new JTextField();
        this.myCDClassName = new JTextField();
        this.myCanInstantiateChk = new JCheckBox();
        this.myCanBeSuperChk = new JCheckBox();
        this.myCustCompPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CustomComponentArea")));
        this.myPrefixLabel.setLabelFor(this.myPrefix);
        Mnemonics.setLocalizedText((JLabel)this.myPrefixLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_Prefix"));
        this.myPrefix.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        GroupLayout myCustCompPrefixPanelLayout = new GroupLayout(this.myCustCompPrefixPanel);
        this.myCustCompPrefixPanel.setLayout(myCustCompPrefixPanelLayout);
        myCustCompPrefixPanelLayout.setHorizontalGroup(myCustCompPrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCustCompPrefixPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.myPrefixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myPrefix, -1, 456, Short.MAX_VALUE).addContainerGap()));
        myCustCompPrefixPanelLayout.setVerticalGroup(myCustCompPrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCustCompPrefixPanelLayout.createSequentialGroup().addGroup(myCustCompPrefixPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myPrefixLabel).addComponent(this.myPrefix, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.myPrefixLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Prefix"));
        this.myPrefixLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        this.myPrefix.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Prefix"));
        this.myPrefix.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Prefix"));
        this.myCompDescrPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_ComponentDescriptor")));
        this.myCDVersionLabel.setLabelFor(this.myCDVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.myCDVersionLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_Version"));
        this.myCDClassNameLabel.setLabelFor(this.myCDClassName);
        Mnemonics.setLocalizedText((JLabel)this.myCDClassNameLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_ClassName"));
        this.myCDTypeIdLabel.setLabelFor(this.myCDTypeId);
        Mnemonics.setLocalizedText((JLabel)this.myCDTypeIdLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_TypeId"));
        this.myCDSuperClassLabel.setLabelFor(this.myCDSuperClass);
        Mnemonics.setLocalizedText((JLabel)this.myCDSuperClassLabel, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_SuperDescriptorClass"));
        this.myCDSuperClass.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_SuperDescriptorClass"));
        this.myCDTypeId.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_TypeId"));
        this.myCDClassName.setToolTipText(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_ClassName"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCanInstantiateChk, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CanInstantiate"));
        Mnemonics.setLocalizedText((AbstractButton)this.myCanBeSuperChk, (String)NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"LBL_CD_CanBeSuperType"));
        GroupLayout myCompDescrPanelLayout = new GroupLayout(this.myCompDescrPanel);
        this.myCompDescrPanel.setLayout(myCompDescrPanelLayout);
        myCompDescrPanelLayout.setHorizontalGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCompDescrPanelLayout.createSequentialGroup().addContainerGap().addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCompDescrPanelLayout.createSequentialGroup().addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCDClassNameLabel).addComponent(this.myCDTypeIdLabel).addComponent(this.myCDSuperClassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCDTypeId, GroupLayout.Alignment.TRAILING, -1, 323, Short.MAX_VALUE).addComponent(this.myCDClassName, -1, 323, Short.MAX_VALUE).addComponent(this.myCDVersionCombo, -2, -1, -2).addComponent(this.myCDSuperClass, -1, 323, Short.MAX_VALUE))).addComponent(this.myCDVersionLabel).addComponent(this.myCanInstantiateChk).addComponent(this.myCanBeSuperChk)).addContainerGap()));
        myCompDescrPanelLayout.setVerticalGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCompDescrPanelLayout.createSequentialGroup().addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCDClassNameLabel).addComponent(this.myCDClassName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCDTypeIdLabel).addComponent(this.myCDTypeId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCDSuperClass, -2, -1, -2).addComponent(this.myCDSuperClassLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(myCompDescrPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCDVersionLabel).addComponent(this.myCDVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCanInstantiateChk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCanBeSuperChk).addContainerGap(-1, Short.MAX_VALUE)));
        this.myCDVersionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Version"));
        this.myCDVersionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Version"));
        this.myCDClassNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_ClassName"));
        this.myCDClassNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_ClassName"));
        this.myCDTypeIdLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_TypeId"));
        this.myCDTypeIdLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_TypeId"));
        this.myCDSuperClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_SuperDescriptorClass"));
        this.myCDSuperClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_SuperDescriptorClass"));
        this.myCanInstantiateChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_CanInstantiate"));
        this.myCanInstantiateChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_CanInstantiate"));
        this.myCanBeSuperChk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_CanBeSuperType"));
        this.myCanBeSuperChk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_CanBeSuperType"));
        GroupLayout myCustCompPanelLayout = new GroupLayout(this.myCustCompPanel);
        this.myCustCompPanel.setLayout(myCustCompPanelLayout);
        myCustCompPanelLayout.setHorizontalGroup(myCustCompPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCustCompPrefixPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.myCompDescrPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        myCustCompPanelLayout.setVerticalGroup(myCustCompPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(myCustCompPanelLayout.createSequentialGroup().addComponent(this.myCustCompPrefixPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.myCompDescrPanel, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCustCompPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myCustCompPanel, -2, -1, -2).addContainerGap(102, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSN_CD_Panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentDescriptorVisualPanel.class, (String)"ACSD_CD_Panel"));
    }
}

