/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private ArtifactType artifactType;
    private static final RequestProcessor RP = new RequestProcessor("MakeArtifactChooser", 1);
    private final FSPath baseDir;
    private JLabel libFilesLabel;
    private JList listArtifacts;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JScrollPane scrollPane1;

    public MakeArtifactChooser(ArtifactType artifactType, JFileChooser chooser, FSPath baseDir) {
        this.artifactType = artifactType;
        this.baseDir = baseDir;
        this.initComponents();
        MyDefaultListModel model = new MyDefaultListModel(null, artifactType, baseDir);
        model.init();
        this.listArtifacts.setModel(model);
        chooser.addPropertyChangeListener(this);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_AD"));
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.libFilesLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.listArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.projectTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)bundle.getString("PROJECT_NAME_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.libFilesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_LIBRARY_FILES_MN").charAt(0));
        this.libFilesLabel.setLabelFor(this.listArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.libFilesLabel, (String)bundle.getString("PROJECT_LIBRARY_FILES_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.libFilesLabel, gridBagConstraints);
        this.scrollPane1.setViewportView(this.listArtifacts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.scrollPane1, gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JFileChooser chooser;
        File dir;
        if ("SelectedFileChangedProperty".equals(e.getPropertyName()) && (dir = (chooser = (JFileChooser)e.getSource()).getSelectedFile()) != null) {
            MyDefaultListModel oldModel = (MyDefaultListModel)this.listArtifacts.getModel();
            oldModel.cancel();
            final MyDefaultListModel model = new MyDefaultListModel(dir, this.artifactType, this.baseDir);
            this.listArtifacts.setModel(model);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        if (!model.isCanceled()) {
                            MakeArtifactChooser.this.projectTextField.setText(model.project == null ? "" : ProjectUtils.getInformation((Project)model.project).getDisplayName());
                            MakeArtifactChooser.this.listArtifacts.setModel(model);
                            if (model.def >= 0) {
                                MakeArtifactChooser.this.listArtifacts.setSelectionInterval(model.def, model.def);
                            }
                        }
                    } else {
                        model.init();
                        if (!model.isCanceled()) {
                            SwingUtilities.invokeLater(this);
                        }
                    }
                }
            });
        }
    }

    public static MakeArtifact[] showDialog(ArtifactType artifactType, Project master, FSPath baseDir, Component parent) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)baseDir.getFileSystem());
        String seed = RemoteFileUtil.getCurrentChooserFile((ExecutionEnvironment)env);
        JFileChooser chooser = RemoteFileUtil.createProjectChooser((ExecutionEnvironment)env, (String)MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_TITLE"), (String)MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_AD"), (String)MakeArtifactChooser.getString("ADD_BUTTON_TXT"), (String)seed);
        MakeArtifactChooser accessory = new MakeArtifactChooser(artifactType, chooser, baseDir);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(parent);
        if (option == 0) {
            RemoteFileUtil.setCurrentChooserFile((String)chooser.getCurrentDirectory().getAbsolutePath(), (ExecutionEnvironment)env);
            MyDefaultListModel model = (MyDefaultListModel)accessory.listArtifacts.getModel();
            Project selectedProject = model.getProject();
            if (selectedProject == null) {
                return null;
            }
            if (selectedProject.getProjectDirectory().equals(master.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_ITSELF_ERROR"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)master, (Project)selectedProject)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_CYCLIC_ERROR"), 1));
                return null;
            }
            Object[] tmp = new Object[model.getSize()];
            int count = 0;
            for (int i = 0; i < tmp.length; ++i) {
                Object elementAt;
                if (!accessory.listArtifacts.isSelectedIndex(i) || !((elementAt = model.getElementAt(i)) instanceof MakeArtifact)) continue;
                tmp[count] = elementAt;
                ++count;
            }
            MakeArtifact[] artifactItems = new MakeArtifact[count];
            System.arraycopy(tmp, 0, artifactItems, 0, count);
            return artifactItems;
        }
        return null;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeArtifactChooser.class).getString(s);
    }

    private static final class MyDefaultListModel
    extends DefaultListModel {
        private final File dir;
        private final ArtifactType artifactType;
        private Project project;
        private int def = -1;
        private AtomicBoolean canceled = new AtomicBoolean(false);
        private final FSPath baseDir;

        private MyDefaultListModel(File dir, ArtifactType artifactType, FSPath baseDir) {
            this.dir = dir;
            this.artifactType = artifactType;
            this.baseDir = baseDir;
            this.addElement(MakeArtifactChooser.getString("LOADING_PROJECT"));
        }

        private Project getProject() {
            return this.project;
        }

        private boolean isCanceled() {
            return this.canceled.get();
        }

        private void cancel() {
            this.canceled.set(true);
        }

        private void init() {
            this.project = this._getProject();
            if (this.project == null) {
                this.clear();
                return;
            }
            if (!this.isCanceled()) {
                this.populateAccessory(this.project);
            }
        }

        private Project _getProject() {
            if (this.dir == null) {
                return null;
            }
            String projectAbsPath = this.dir.getAbsolutePath();
            if (projectAbsPath == null) {
                return null;
            }
            try {
                FileObject fo = this.baseDir.getFileSystem().findResource(CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseDir.getFileSystem(), (String)projectAbsPath));
                if (fo != null && fo.isValid()) {
                    return ProjectManager.getDefault().findProject(fo);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return null;
        }

        private void populateAccessory(Project project) {
            MakeArtifact[] artifacts = MakeArtifact.getMakeArtifacts(project);
            this.clear();
            if (artifacts == null) {
                return;
            }
            for (int i = 0; i < artifacts.length; ++i) {
                if (this.artifactType == ArtifactType.LIBRARY) {
                    if (artifacts[i].getConfigurationType() == 0 && (artifacts[i].getOutput().endsWith(".a") || artifacts[i].getOutput().endsWith(".so") || artifacts[i].getOutput().endsWith(".dylib") || artifacts[i].getOutput().endsWith(".lib") || artifacts[i].getOutput().endsWith(".dll")) || artifacts[i].getConfigurationType() == 2 || artifacts[i].getConfigurationType() == 10 || artifacts[i].getConfigurationType() == 3 || artifacts[i].getConfigurationType() == 5 || artifacts[i].getConfigurationType() == 6) {
                        this.addElement(artifacts[i]);
                    }
                } else if (this.artifactType == ArtifactType.PROJECT) {
                    this.addElement(artifacts[i]);
                } else assert (false);
                if (!artifacts[i].getActive()) continue;
                this.def = i;
            }
        }
    }

    public static enum ArtifactType {
        PROJECT,
        LIBRARY;

    }
}

