/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class CCCompilerConfiguration
extends CCCCompilerConfiguration {
    public CCCompilerConfiguration(String baseDir, CCCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
    }

    public void assign(CCCompilerConfiguration conf) {
        super.assign(conf);
    }

    public CCCompilerConfiguration clone() {
        CCCompilerConfiguration clone = new CCCompilerConfiguration(this.getBaseDir(), (CCCompilerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setLibraryLevel(this.getLibraryLevel().clone());
        clone.setStandardsEvolution(this.getStandardsEvolution().clone());
        clone.setLanguageExt(this.getLanguageExt().clone());
        clone.setIncludeDirectories((VectorConfiguration<String>)this.getIncludeDirectories().clone());
        clone.setInheritIncludes(this.getInheritIncludes().clone());
        clone.setPreprocessorConfiguration((VectorConfiguration<String>)this.getPreprocessorConfiguration().clone());
        clone.setInheritPreprocessor(this.getInheritPreprocessor().clone());
        clone.setUseLinkerLibraries(this.getUseLinkerLibraries().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        String options = "$(COMPILE.cc) ";
        options = options + this.getAllOptions2(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public String getCCFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getLibraryLevelOptions(this.getLibraryLevel().getValue()) + " ";
        options = options + compiler.getStandardEvaluationOptions(this.getStandardsEvolution().getValue()) + " ";
        options = options + compiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getCCFlags(AbstractCompiler compiler) {
        String options = this.getCCFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getCCFlagsBasic(compiler));
        options.append(" ");
        for (CCCompilerConfiguration master = this; master != null; master = (CCCompilerConfiguration)master.getMaster()) {
            options.append(master.getCommandLineConfiguration().getValue());
            options.append(" ");
        }
        options.append(this.getAllOptions2(compiler));
        options.append(" ");
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + this.getPreprocessorOptions(compiler.getCompilerSet());
        options = options + this.getIncludeDirectoriesOptions(compiler.getCompilerSet());
        options = options + this.getLibrariesFlags();
        return CppUtils.reformatWhitespaces(options);
    }

    public String getPreprocessorOptions(CompilerSet cs) {
        CCCompilerConfiguration master = (CCCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(null, this.getUserMacroFlag(cs));
        StringBuilder options = new StringBuilder(this.getPreprocessorConfiguration().toString(visitor));
        options.append(' ');
        while (master != null && this.getInheritPreprocessor().getValue()) {
            options.append(master.getPreprocessorConfiguration().toString(visitor));
            options.append(' ');
            if (master.getInheritPreprocessor().getValue()) {
                master = (CCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        return options.toString();
    }

    public String getIncludeDirectoriesOptions(CompilerSet cs) {
        CCCompilerConfiguration master = (CCCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserIncludeFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeDirectories().toString(visitor));
        options.append(' ');
        while (master != null && this.getInheritIncludes().getValue()) {
            options.append(master.getIncludeDirectories().toString(visitor));
            options.append(' ');
            if (master.getInheritIncludes().getValue()) {
                master = (CCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        return options.toString();
    }

    @Override
    protected String getUserIncludeFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getCpp().getUserIncludeFlag();
    }

    @Override
    protected String getUserMacroFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getCpp().getUserMacroFlag();
    }

    public Sheet getSheet(MakeConfiguration conf, Folder folder, Item item) {
        String compileLine;
        AllOptionsProvider options;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        Sheet.Set set0 = this.getSet();
        sheet.put(set0);
        if (conf.isCompileConfiguration() && folder == null) {
            sheet.put(this.getBasicSet());
            if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                Sheet.Set set2 = new Sheet.Set();
                set2.setName("OtherOptions");
                set2.setDisplayName(CCCompilerConfiguration.getString("OtherOptionsTxt"));
                set2.setShortDescription(CCCompilerConfiguration.getString("OtherOptionsHint"));
                set2.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", CCCompilerConfiguration.getString("MultithreadingLevelTxt"), CCCompilerConfiguration.getString("MultithreadingLevelHint")));
                set2.put((Node.Property)new IntNodeProp(this.getLibraryLevel(), this.getMaster() == null, "LibraryLevel", CCCompilerConfiguration.getString("LibraryLevelTxt"), CCCompilerConfiguration.getString("LibraryLevelHint")));
                set2.put((Node.Property)new IntNodeProp(this.getStandardsEvolution(), this.getMaster() == null, "StandardsEvolution", CCCompilerConfiguration.getString("StandardsEvolutionTxt"), CCCompilerConfiguration.getString("StandardsEvolutionHint")));
                set2.put((Node.Property)new IntNodeProp(this.getLanguageExt(), this.getMaster() == null, "LanguageExtensions", CCCompilerConfiguration.getString("LanguageExtensionsTxt"), CCCompilerConfiguration.getString("LanguageExtensionsHint")));
                sheet.put(set2);
            }
            if (this.getMaster() != null) {
                sheet.put(this.getInputSet());
            }
            Sheet.Set set4 = new Sheet.Set();
            set4.setName("Tool");
            set4.setDisplayName(CCCompilerConfiguration.getString("ToolTxt1"));
            set4.setShortDescription(CCCompilerConfiguration.getString("ToolHint1"));
            if (ccCompiler != null) {
                set4.put((Node.Property)new StringNodeProp(this.getTool(), ccCompiler.getName(), false, "Tool", CCCompilerConfiguration.getString("ToolTxt2"), CCCompilerConfiguration.getString("ToolHint2")));
            }
            sheet.put(set4);
            String[] texts = new String[]{CCCompilerConfiguration.getString("AdditionalOptionsTxt1"), CCCompilerConfiguration.getString("AdditionalOptionsHint"), CCCompilerConfiguration.getString("AdditionalOptionsTxt2"), CCCompilerConfiguration.getString("AllOptionsTxt")};
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("CommandLine");
            set2.setDisplayName(CCCompilerConfiguration.getString("CommandLineTxt"));
            set2.setShortDescription(CCCompilerConfiguration.getString("CommandLineHint"));
            if (ccCompiler != null) {
                set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, ccCompiler, null, texts));
            }
            sheet.put(set2);
        } else if (conf.getConfigurationType().getValue() == 0 && item != null && ccCompiler != null && (options = CompileOptionsProvider.getDefault().getOptions(item)) != null && (compileLine = options.getAllOptions((Tool)ccCompiler)) != null) {
            int hasPath = compileLine.indexOf(35);
            if (hasPath >= 0) {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CommandLineTxt"), CCCompilerConfiguration.getString("CommandLineHint"), compileLine.substring(hasPath + 1)));
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CompileFolderTxt"), CCCompilerConfiguration.getString("CompileFolderHint"), compileLine.substring(0, hasPath)));
            } else {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CommandLineTxt"), CCCompilerConfiguration.getString("CommandLineHint"), compileLine.substring(hasPath)));
            }
        }
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCompilerConfiguration.class, (String)s);
    }
}

