/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class MakeProjectFileOwnerQuery
implements FileOwnerQueryImplementation {
    private static final String PATH_SEPARATOR = "/";

    public Project getOwner(URI uri) {
        return this.getOwner(this.toFileObject(uri));
    }

    private FileObject toFileObject(URI uri) {
        try {
            URL url = uri.toURL();
            return URLMapper.findFileObject((URL)url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Project getOwner(FileObject fo) {
        FileSystem fs;
        if (fo == null) {
            return null;
        }
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        String path = CndPathUtilitities.normalizeSlashes((String)fo.getPath());
        for (NativeProject nativeProject : NativeProjectRegistry.getDefault().getOpenProjects()) {
            MakeConfigurationDescriptor descriptor;
            ConfigurationDescriptorProvider provider;
            Lookup.Provider project = nativeProject.getProject();
            if (!(project instanceof Project) || !fs.equals(RemoteFileUtil.getProjectSourceFileSystem((Project)((Project)project))) || (provider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) == null || !provider.gotDescriptor() || (descriptor = provider.getConfigurationDescriptor()) == null) continue;
            boolean mine = false;
            if (fo.isData()) {
                mine = descriptor.findProjectItemByPath(path) != null || descriptor.findExternalItemByPath(path) != null;
            } else if (fo.isFolder()) {
                boolean bl = mine = descriptor.findFolderByPath(path) != null;
            }
            if (mine) {
                return (Project)project;
            }
            if (this.isMine(descriptor.getAbsoluteSourceRoots(), fo, path)) {
                return (Project)project;
            }
            if (!this.isMine(descriptor.getAbsoluteTestRoots(), fo, path)) continue;
            return (Project)project;
        }
        return null;
    }

    private boolean isMine(List<String> list, FileObject fo, String path) {
        if (!list.isEmpty()) {
            if (fo.isFolder() && !path.endsWith(PATH_SEPARATOR)) {
                path = path + PATH_SEPARATOR;
            }
            for (String srcPath : list) {
                if (!(srcPath = CndPathUtilitities.normalizeSlashes((String)srcPath)).endsWith(PATH_SEPARATOR)) {
                    srcPath = srcPath + PATH_SEPARATOR;
                }
                if (!path.startsWith(srcPath)) continue;
                return true;
            }
        }
        return false;
    }
}

