/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

final class OutputTab
extends AbstractOutputTab
implements IOContainer.CallBacks {
    private final NbIO io;
    private OutWriter outWriter;
    private boolean hasOutputListeners = false;
    boolean ignoreCaretChanges = false;
    int[] lastCaretListenerRange;
    private static String lastDir = null;
    FilteredOutput filtOut;
    AbstractOutputPane origPane;
    private static final ACTION[] popupItems = new ACTION[]{ACTION.COPY, ACTION.PASTE, null, ACTION.FIND, ACTION.FIND_NEXT, ACTION.FIND_PREVIOUS, ACTION.FILTER, null, ACTION.WRAP, ACTION.LARGER_FONT, ACTION.SMALLER_FONT, ACTION.FONT_TYPE, null, ACTION.SAVEAS, ACTION.CLEAR, ACTION.CLOSE};
    private static final ACTION[] actionsToInstall = new ACTION[]{ACTION.COPY, ACTION.SELECT_ALL, ACTION.FIND, ACTION.FIND_NEXT, ACTION.FIND_PREVIOUS, ACTION.WRAP, ACTION.LARGER_FONT, ACTION.SMALLER_FONT, ACTION.SAVEAS, ACTION.CLOSE, ACTION.COPY, ACTION.NAVTOLINE, ACTION.POSTMENU, ACTION.CLEAR, ACTION.FILTER};
    private final Map<ACTION, TabAction> actions = new EnumMap<ACTION, TabAction>(ACTION.class);

    OutputTab(NbIO io) {
        this.io = io;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + io);
        }
        this.outWriter = ((NbWriter)io.getOut()).out();
        this.createActions();
        OutputDocument doc = new OutputDocument(this.outWriter);
        this.setDocument(doc);
        this.installKBActions();
        this.getActionMap().put("jumpPrev", this.action(ACTION.PREV_ERROR));
        this.getActionMap().put("jumpNext", this.action(ACTION.NEXT_ERROR));
        this.getActionMap().put(FindAction.class.getName(), this.action(ACTION.FIND));
        this.getActionMap().put("copy-to-clipboard", this.action(ACTION.COPY));
    }

    private final TabAction action(ACTION a) {
        return this.actions.get((Object)a);
    }

    private void installKBActions() {
        for (ACTION a : actionsToInstall) {
            this.installKeyboardAction(this.action(a));
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        assert (SwingUtilities.isEventDispatchThread());
        OutputDocument old = this.getDocument();
        this.hasOutputListeners = false;
        super.setDocument(doc);
        if (old != null && old instanceof OutputDocument) {
            old.dispose();
        }
    }

    public void reset() {
        if (this.origPane != null) {
            this.setFilter(null, false, false);
        }
        this.outWriter = this.io.out();
        this.setDocument(new OutputDocument(this.outWriter));
    }

    public OutputDocument getDocument() {
        Document d = this.getOutputPane().getDocument();
        if (d instanceof OutputDocument) {
            return (OutputDocument)d;
        }
        return null;
    }

    @Override
    protected AbstractOutputPane createOutputPane() {
        return new OutputPane(this);
    }

    @Override
    protected void inputSent(String txt) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + txt);
        }
        this.getOutputPane().lockScroll();
        NbIO.IOReader in = this.io.in();
        if (in != null) {
            if (Controller.LOG) {
                Controller.log("Sending input to " + in);
            }
            in.pushText(txt + "\n");
            this.outWriter.println(txt);
        }
    }

    @Override
    protected void inputEof() {
        NbIO.IOReader in;
        if (Controller.LOG) {
            Controller.log("Input EOF");
        }
        if ((in = this.io.in()) != null) {
            in.eof();
        }
    }

    @Override
    public void hasSelectionChanged(boolean val) {
        if (this.isShowing()) {
            this.actions.get((Object)ACTION.COPY).setEnabled(val);
            this.actions.get((Object)ACTION.SELECT_ALL).setEnabled(!this.getOutputPane().isAllSelected());
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void requestActive() {
        this.io.getIOContainer().requestActive();
    }

    public void lineClicked(int line, int pos) {
        OutWriter out = this.getOut();
        int[] range = new int[2];
        OutputListener l = out.getLines().getListener(pos, range);
        if (l != null) {
            int size = out.getLines().getCharCount();
            assert (range[1] < size) : "Size: " + size + " range: " + range[0] + " " + range[1];
            Controller.ControllerOutputEvent oe = new Controller.ControllerOutputEvent(this.io, out, line);
            l.outputLineAction((OutputEvent)oe);
            if (this.getOutputPane().getLength() >= range[1]) {
                this.getOutputPane().sendCaretToPos(range[0], range[1], true);
            }
        }
    }

    @Override
    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged(OutputPane pane) {
        if (this.filtOut != null && pane == this.origPane) {
            this.filtOut.readFrom(this.outWriter);
        }
        boolean hadOutputListeners = this.hasOutputListeners;
        boolean bl = this.hasOutputListeners = this.getOut() != null && (this.getOut().getLines().firstListenerLine() >= 0 || this.getOut().getLines().firstImportantListenerLine() >= 0);
        if (this.hasOutputListeners != hadOutputListeners) {
            this.hasOutputListenersChanged(this.hasOutputListeners);
        }
        IOContainer ioContainer = this.io.getIOContainer();
        if (this.io.isFocusTaken()) {
            ioContainer.open();
            ioContainer.select((JComponent)this);
            ioContainer.requestVisible();
        }
        Controller.getDefault().updateName(this);
        if (this == ioContainer.getSelected() && ioContainer.isActivated()) {
            this.updateActions();
        }
    }

    private void navigateToFirstErrorLine() {
        OutWriter out = this.getOut();
        if (out != null) {
            int line = out.getLines().firstImportantListenerLine();
            if (Controller.LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + line);
            }
            if (line >= 0) {
                this.getOutputPane().sendCaretToLine(line, false);
                if (this.isSDI()) {
                    this.requestActive();
                }
            }
        }
    }

    private boolean isSDI() {
        Container c = this.getTopLevelAncestor();
        return c != WindowManager.getDefault().getMainWindow();
    }

    void hasOutputListenersChanged(boolean hasOutputListeners) {
        if (hasOutputListeners && this.getOutputPane().isScrollLocked()) {
            this.navigateToFirstErrorLine();
        }
    }

    public void activated() {
        this.updateActions();
    }

    public void closed() {
        this.io.setClosed(true);
        this.io.setStreamClosed(true);
        Controller.getDefault().removeTab(this.io);
        NbWriter w = this.io.writer();
        if (w != null && w.isClosed()) {
            this.setDocument(null);
            this.io.dispose();
        } else if (w != null) {
            if (this.getOut() != null) {
                this.getOut().setDisposeOnClose(true);
            }
            this.getDocument().disposeQuietly();
            NbIOProvider.dispose(this.io);
        }
    }

    public void deactivated() {
    }

    public void selected() {
    }

    public boolean shouldRelock(int dot) {
        OutWriter w = this.getOut();
        if (w != null && !w.isClosed()) {
            int dist = Math.abs(w.getLines().getCharCount() - dot);
            return dist < 100;
        }
        return false;
    }

    void caretPosChanged(int pos) {
        if (!this.ignoreCaretChanges) {
            if (this.lastCaretListenerRange != null && pos >= this.lastCaretListenerRange[0] && pos < this.lastCaretListenerRange[1]) {
                return;
            }
            OutWriter out = this.getOut();
            if (out != null) {
                int[] range = new int[2];
                OutputListener l = out.getLines().getListener(pos, range);
                if (l != null) {
                    Controller.ControllerOutputEvent oe = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(pos));
                    l.outputLineSelected((OutputEvent)oe);
                    this.lastCaretListenerRange = range;
                } else {
                    this.lastCaretListenerRange = null;
                }
            }
        }
    }

    private void sendCaretToError(boolean backward) {
        OutWriter out = this.getOut();
        if (out != null) {
            AbstractOutputPane op = this.getOutputPane();
            int selStart = op.getSelectionStart();
            int selEnd = op.getSelectionEnd();
            int pos = op.getCaretPos();
            if (selStart != selEnd && pos == selStart && out.getLines().isListener(selStart, selEnd)) {
                pos = backward ? selStart - 1 : selEnd + 1;
            }
            int[] lpos = new int[2];
            OutputListener l = out.getLines().nearestListener(pos, backward, lpos);
            if (l != null) {
                op.sendCaretToPos(lpos[0], lpos[1], true);
                if (!this.io.getIOContainer().isActivated()) {
                    Controller.ControllerOutputEvent ce = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(lpos[0]));
                    l.outputLineAction((OutputEvent)ce);
                }
            }
        }
    }

    private boolean find(boolean reversed) {
        OutWriter out = this.getOut();
        if (out != null) {
            String msg;
            int pos;
            String lastPattern = FindDialogPanel.result();
            if (lastPattern == null) {
                return false;
            }
            int n = pos = reversed ? this.getOutputPane().getSelectionStart() : this.getOutputPane().getCaretPos();
            if (pos > this.getOutputPane().getLength() || pos < 0) {
                pos = 0;
            }
            boolean regExp = FindDialogPanel.regExp();
            boolean matchCase = FindDialogPanel.matchCase();
            int[] sel = reversed ? out.getLines().rfind(pos, lastPattern, regExp, matchCase) : out.getLines().find(pos, lastPattern, regExp, matchCase);
            String appendMsg = null;
            if (sel == null) {
                int[] nArray = sel = reversed ? out.getLines().rfind(out.getLines().getCharCount(), lastPattern, regExp, matchCase) : out.getLines().find(0, lastPattern, regExp, matchCase);
                if (sel != null) {
                    appendMsg = NbBundle.getMessage(OutputTab.class, (String)(reversed ? "MSG_SearchFromEnd" : "MSG_SearchFromBeg"));
                }
            }
            if (sel != null) {
                this.getOutputPane().unlockScroll();
                this.getOutputPane().setSelection(sel[0], sel[1]);
                int line = out.getLines().getLineAt(sel[0]);
                int col = sel[0] - out.getLines().getLineStart(line);
                msg = NbBundle.getMessage(OutputTab.class, (String)"MSG_Found", (Object)lastPattern, (Object)(line + 1), (Object)(col + 1));
                if (appendMsg != null) {
                    msg = msg + "; " + appendMsg;
                }
            } else {
                msg = NbBundle.getMessage(OutputTab.class, (String)"MSG_NotFound", (Object)lastPattern);
            }
            StatusDisplayer.getDefault().setStatusText(msg);
            return sel != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAs() {
        OutWriter out = this.getOut();
        if (out == null) {
            return;
        }
        File f = OutputTab.showFileChooser(this);
        if (f != null) {
            try {
                OutWriter outWriter = out;
                synchronized (outWriter) {
                    out.getLines().saveAs(f.getPath());
                }
            }
            catch (IOException ioe) {
                NotifyDescriptor notifyDesc = new NotifyDescriptor((Object)NbBundle.getMessage(OutputTab.class, (String)"MSG_SaveAsFailed", (Object)f.getPath()), NbBundle.getMessage(OutputTab.class, (String)"LBL_SaveAsFailedTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDesc);
            }
        }
    }

    private static File showFileChooser(JComponent owner) {
        File f = null;
        String dlgTtl = NbBundle.getMessage(Controller.class, (String)"TITLE_SAVE_DLG");
        boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (isAqua) {
            String s;
            Container frameOrDialog = owner.getTopLevelAncestor();
            FileDialog fd = frameOrDialog instanceof Frame ? new FileDialog((Frame)frameOrDialog, dlgTtl, 1) : new FileDialog((Dialog)frameOrDialog, dlgTtl, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                fd.setDirectory(lastDir);
            }
            fd.setModal(true);
            fd.setVisible(true);
            if (fd.getFile() != null && fd.getDirectory() != null && (f = new File(s = fd.getDirectory() + fd.getFile())).exists() && f.isDirectory()) {
                f = null;
            }
        } else {
            File dir;
            JFileChooser jfc = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && (dir = new File(lastDir)).exists()) {
                jfc.setCurrentDirectory(dir);
            }
            jfc.setName(dlgTtl);
            jfc.setDialogTitle(dlgTtl);
            if (jfc.showSaveDialog(owner.getTopLevelAncestor()) == 0) {
                f = jfc.getSelectedFile();
            }
        }
        if (f != null && f.exists() && !isAqua) {
            String msg = NbBundle.getMessage(Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{f.getName()});
            String title = NbBundle.getMessage(Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(owner.getTopLevelAncestor(), msg, title, 2) != 0) {
                f = null;
            }
        }
        if (f != null) {
            lastDir = f.getParent();
        }
        return f;
    }

    private void openHyperlink() {
        OutWriter out = this.getOut();
        if (out != null) {
            int pos = this.getOutputPane().getCaretPos();
            int[] range = new int[2];
            OutputListener l = out.getLines().getListener(pos, range);
            if (l != null) {
                this.ignoreCaretChanges = true;
                this.getOutputPane().sendCaretToPos(range[0], range[1], true);
                this.ignoreCaretChanges = false;
                Controller.ControllerOutputEvent coe = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(pos));
                l.outputLineAction((OutputEvent)coe);
            }
        }
    }

    void postPopupMenu(Point p, Component src) {
        int i;
        JPopupMenu popup = new JPopupMenu();
        Action[] a = this.getToolbarActions();
        if (a.length > 0) {
            boolean added = false;
            for (i = 0; i < a.length; ++i) {
                if (a[i].getValue("Name") == null) continue;
                popup.add(new ProxyAction(a[i]));
                added = true;
            }
            if (added) {
                popup.add(new JSeparator());
            }
        }
        ArrayList<TabAction> activeActions = new ArrayList<TabAction>(popupItems.length);
        for (i = 0; i < popupItems.length; ++i) {
            JMenuItem item;
            if (popupItems[i] == null) {
                popup.add(new JSeparator());
                continue;
            }
            TabAction ta = this.action(popupItems[i]);
            if (popupItems[i] == ACTION.WRAP) {
                item = new JCheckBoxMenuItem(ta);
                item.setSelected(this.getOutputPane().isWrapped());
                activeActions.add(ta);
                popup.add(item);
                continue;
            }
            if (popupItems[i] == ACTION.FILTER) {
                item = new JCheckBoxMenuItem(ta);
                item.setSelected(this.origPane != null);
                activeActions.add(ta);
                popup.add(item);
                continue;
            }
            if (popupItems[i] == ACTION.CLOSE && !this.io.getIOContainer().isCloseable((JComponent)this) || popupItems[i] == ACTION.FONT_TYPE && this.getOutputPane().isWrapped()) continue;
            item = popup.add(ta);
            activeActions.add(ta);
            if (popupItems[i] != ACTION.FIND) continue;
            item.setMnemonic(70);
        }
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        JTextComponent c = this.getOutputPane().getTextView();
        Object escHandle = c.getInputMap().get(esc);
        c.getInputMap().remove(esc);
        this.getInputMap(1).remove(esc);
        popup.addPopupMenuListener(new PMListener(activeActions, escHandle));
        popup.show(src, p.x, p.y);
    }

    void updateActions() {
        OutputPane pane = (OutputPane)this.getOutputPane();
        int len = pane.getLength();
        boolean enable = len > 0;
        OutWriter out = this.getOut();
        this.action(ACTION.SAVEAS).setEnabled(enable);
        this.action(ACTION.SELECT_ALL).setEnabled(enable);
        this.action(ACTION.COPY).setEnabled(pane.hasSelection());
        boolean hasErrors = out == null ? false : out.getLines().hasListeners();
        this.action(ACTION.NEXT_ERROR).setEnabled(hasErrors);
        this.action(ACTION.PREV_ERROR).setEnabled(hasErrors);
    }

    private void showFontChooser() {
        PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
        if (pe != null) {
            pe.setValue(this.getOutputPane().getViewFont());
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), NbBundle.getMessage(OutputTab.class, (String)"LBL_Font_Chooser_Title"));
            String defaultFont = NbBundle.getMessage(OutputTab.class, (String)"BTN_Defaul_Font");
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, defaultFont, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                Font f = (Font)pe.getValue();
                Controller.getDefault().changeFont(f);
            } else if (dd.getValue() == defaultFont) {
                Controller.getDefault().changeFont(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilter(String pattern, boolean regExp, boolean matchCase) {
        if (pattern == null) {
            assert (this.origPane != null);
            this.setOutputPane(this.origPane);
            this.origPane = null;
            this.filtOut.dispose();
            this.filtOut = null;
        } else {
            assert (this.origPane == null);
            this.origPane = this.getOutputPane();
            this.filtOut = new FilteredOutput(pattern, regExp, matchCase);
            this.setOutputPane(this.filtOut.getPane());
            try {
                this.waitCursor(true);
                this.filtOut.readFrom(this.outWriter);
                this.installKBActions();
            }
            finally {
                this.waitCursor(false);
            }
        }
        this.validate();
        this.getOutputPane().repaint();
        this.requestFocus();
    }

    private void waitCursor(boolean enable) {
        RootPaneContainer root = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        Cursor cursor = Cursor.getPredefinedCursor(enable ? 3 : 0);
        root.getGlassPane().setCursor(cursor);
        root.getGlassPane().setVisible(enable);
    }

    OutWriter getOut() {
        return this.origPane != null ? this.filtOut.getWriter() : this.outWriter;
    }

    private void disableHtmlName() {
        String escaped;
        Controller.getDefault().removeFromUpdater(this);
        try {
            escaped = XMLUtil.toAttributeValue((String)(this.io.getName() + " "));
        }
        catch (CharConversionException e) {
            escaped = this.io.getName() + " ";
        }
        this.io.getIOContainer().setTitle((JComponent)this, escaped.replace("&apos;", "'"));
    }

    private void createActions() {
        for (ACTION a : ACTION.values()) {
            TabAction action;
            switch (a) {
                case COPY: 
                case PASTE: 
                case WRAP: 
                case SAVEAS: 
                case CLOSE: 
                case NEXT_ERROR: 
                case PREV_ERROR: 
                case SELECT_ALL: 
                case FIND: 
                case FIND_NEXT: 
                case FIND_PREVIOUS: 
                case FILTER: 
                case LARGER_FONT: 
                case SMALLER_FONT: 
                case FONT_TYPE: 
                case CLEAR: {
                    action = new TabAction(a, "ACTION_" + a.name());
                    break;
                }
                case NAVTOLINE: {
                    action = new TabAction(a, "navToLine", KeyStroke.getKeyStroke(10, 0));
                    break;
                }
                case POSTMENU: {
                    action = new TabAction(a, "postMenu", KeyStroke.getKeyStroke(121, 64));
                    break;
                }
                case NEXTTAB: {
                    action = new TabAction(a, "NextViewAction", null);
                    break;
                }
                case PREVTAB: {
                    action = new TabAction(a, "PreviousViewAction", null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled action " + (Object)((Object)a));
                }
            }
            this.actions.put(a, action);
        }
    }

    @Override
    public void setInputVisible(boolean val) {
        super.setInputVisible(val);
        this.action(ACTION.PASTE).setEnabled(val);
    }

    private boolean validRegExp(String pattern) {
        try {
            Pattern.compile(pattern);
            return true;
        }
        catch (PatternSyntaxException ex) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), NbBundle.getMessage(OutputTab.class, (String)"FMT_Invalid_RegExp", (Object)pattern), NbBundle.getMessage(OutputTab.class, (String)"LBL_Invalid_RegExp"), 0);
            return false;
        }
    }

    private String getFindDlgResult(String selection, String title, String label, String button) {
        String pattern = FindDialogPanel.getResult(selection, title, label, button);
        while (pattern != null && FindDialogPanel.regExp() && !this.validRegExp(pattern)) {
            pattern = FindDialogPanel.getResult(pattern, title, label, button);
        }
        return pattern;
    }

    private class FilteredOutput {
        String pattern;
        OutWriter out;
        OutputPane pane;
        OutputDocument doc;
        int readCount;
        Pattern compPattern;
        boolean regExp;
        boolean matchCase;

        public FilteredOutput(String pattern, boolean regExp, boolean matchCase) {
            this.pattern = regExp || matchCase ? pattern : pattern.toLowerCase();
            this.regExp = regExp;
            this.matchCase = matchCase;
            this.out = new OutWriter();
            this.pane = new OutputPane(OutputTab.this);
            this.doc = new OutputDocument(this.out);
            this.pane.setDocument(this.doc);
        }

        boolean passFilter(String str) {
            if (this.regExp) {
                if (this.compPattern == null) {
                    this.compPattern = this.matchCase ? Pattern.compile(this.pattern) : Pattern.compile(this.pattern, 2);
                }
                return this.compPattern.matcher(str).find();
            }
            return this.matchCase ? str.contains(this.pattern) : str.toLowerCase().contains(this.pattern);
        }

        OutputPane getPane() {
            return this.pane;
        }

        OutWriter getWriter() {
            return this.out;
        }

        synchronized void readFrom(OutWriter orig) {
            AbstractLines lines = (AbstractLines)orig.getLines();
            while (this.readCount < lines.getLineCount()) {
                try {
                    int line;
                    ++this.readCount;
                    String str = lines.getLine(line);
                    if (!this.passFilter(str)) continue;
                    LineInfo info = lines.getExistingLineInfo(line);
                    this.out.print(str, info, lines.isImportantLine(line));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        void dispose() {
            this.out.dispose();
        }
    }

    private class PMListener
    implements PopupMenuListener {
        private List<TabAction> popupItems;
        private Object handle;

        PMListener(List<TabAction> popupItems, Object escHandle) {
            this.popupItems = popupItems;
            this.handle = escHandle;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            popup.removeAll();
            popup.setInvoker(null);
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            JTextComponent c = OutputTab.this.getOutputPane().getTextView();
            c.getInputMap().put(esc, this.handle);
            OutputTab.this.getInputMap(1).put(esc, this.handle);
            popup.removePopupMenuListener(this);
            for (TabAction action : this.popupItems) {
                action.clearListeners();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(e);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action original) {
            this.orig = original;
        }

        @Override
        public Object getValue(String key) {
            if ("SmallIcon".equals(key)) {
                return null;
            }
            return this.orig.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.orig.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.orig.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.orig.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.orig.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.orig.actionPerformed(e);
        }
    }

    class TabAction
    extends AbstractAction {
        private ACTION action;

        TabAction(ACTION action, String bundleKey) {
            if (bundleKey != null) {
                String name = NbBundle.getMessage(OutputTab.class, (String)bundleKey);
                KeyStroke accelerator = this.getAcceleratorFor(bundleKey);
                this.action = action;
                this.putValue("Name", name);
                this.putValue("AcceleratorKey", accelerator);
            }
        }

        TabAction(ACTION action, String name, KeyStroke stroke) {
            this.action = action;
            this.putValue("Name", name);
            this.putValue("AcceleratorKey", stroke);
        }

        void clearListeners() {
            PropertyChangeListener[] l = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < l.length; ++i) {
                this.removePropertyChangeListener(l[i]);
            }
        }

        private KeyStroke getAcceleratorFor(String name) {
            String key = name + ".accel";
            if (Utilities.isMac()) {
                key = key + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage(OutputTab.class, (String)key));
        }

        public ACTION getAction() {
            return this.action;
        }

        @Override
        public boolean isEnabled() {
            if (OutputTab.this.getIO().isClosed()) {
                JComponent selected = OutputTab.this.getIO().getIOContainer().getSelected();
                if (OutputTab.this != selected && selected instanceof OutputTab) {
                    OutputTab tab = (OutputTab)selected;
                    return tab.action(this.action).isEnabled();
                }
                return false;
            }
            return super.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OutputTab.this.getIO().isClosed()) {
                JComponent selected = OutputTab.this.getIO().getIOContainer().getSelected();
                if (OutputTab.this != selected && selected instanceof OutputTab) {
                    OutputTab tab = (OutputTab)selected;
                    tab.action(this.action).actionPerformed(e);
                }
                return;
            }
            switch (this.getAction()) {
                case COPY: {
                    OutputTab.this.getOutputPane().copy();
                    break;
                }
                case PASTE: {
                    OutputTab.this.getOutputPane().paste();
                    break;
                }
                case WRAP: {
                    boolean wrapped = OutputTab.this.getOutputPane().isWrapped();
                    OutputTab.this.getOutputPane().setWrapped(!wrapped);
                    break;
                }
                case SAVEAS: {
                    OutputTab.this.saveAs();
                    break;
                }
                case CLOSE: {
                    OutputTab.this.io.getIOContainer().remove((JComponent)OutputTab.this);
                    break;
                }
                case NEXT_ERROR: {
                    OutputTab.this.sendCaretToError(false);
                    break;
                }
                case PREV_ERROR: {
                    OutputTab.this.sendCaretToError(true);
                    break;
                }
                case SELECT_ALL: {
                    OutputTab.this.getOutputPane().selectAll();
                    break;
                }
                case FIND: {
                    String pattern = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Find_Title", "LBL_Find_What", "BTN_Find");
                    if (pattern == null || !OutputTab.this.find(false)) break;
                    OutputTab.this.action(ACTION.FIND_NEXT).setEnabled(true);
                    OutputTab.this.action(ACTION.FIND_PREVIOUS).setEnabled(true);
                    OutputTab.this.requestFocus();
                    break;
                }
                case FIND_NEXT: {
                    OutputTab.this.find(false);
                    break;
                }
                case FIND_PREVIOUS: {
                    OutputTab.this.find(true);
                    break;
                }
                case NAVTOLINE: {
                    OutputTab.this.openHyperlink();
                    break;
                }
                case POSTMENU: {
                    OutputTab.this.postPopupMenu(new Point(0, 0), OutputTab.this);
                    break;
                }
                case CLEAR: {
                    NbWriter writer = OutputTab.this.io.writer();
                    if (writer == null) break;
                    try {
                        boolean vis = OutputTab.this.isInputVisible();
                        boolean closed = OutputTab.this.io.isStreamClosed();
                        writer.reset();
                        OutputTab.this.setInputVisible(vis);
                        OutputTab.this.io.setStreamClosed(closed);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    break;
                }
                case SMALLER_FONT: {
                    Controller.getDefault().changeFontSizeBy(-1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case LARGER_FONT: {
                    Controller.getDefault().changeFontSizeBy(1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case FONT_TYPE: {
                    OutputTab.this.showFontChooser();
                    break;
                }
                case FILTER: {
                    if (OutputTab.this.origPane != null) {
                        OutputTab.this.setFilter(null, false, false);
                        break;
                    }
                    String pattern = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Filter_Title", "LBL_Filter_What", "BTN_Filter");
                    if (pattern == null) break;
                    OutputTab.this.setFilter(pattern, FindDialogPanel.regExp(), FindDialogPanel.matchCase());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    static enum ACTION {
        COPY,
        WRAP,
        SAVEAS,
        CLOSE,
        NEXT_ERROR,
        PREV_ERROR,
        SELECT_ALL,
        FIND,
        FIND_NEXT,
        NAVTOLINE,
        POSTMENU,
        FIND_PREVIOUS,
        CLEAR,
        NEXTTAB,
        PREVTAB,
        LARGER_FONT,
        SMALLER_FONT,
        FONT_TYPE,
        FILTER,
        PASTE;

    }
}

