/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.ServerDetails;
import org.netbeans.modules.glassfish.common.wizards.GlassfishWizardProvider;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class ServerUtilities {
    public static final int ACTION_TIMEOUT = 15000;
    public static final TimeUnit ACTION_TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    public static final String GFV3_MODULES_DIR_NAME = "modules";
    public static final String GFV3_LIB_DIR_NAME = "lib";
    public static final String GFV3_VERSION_MATCHER = "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GFV3_JAR_MATCHER = "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String PROP_FIRST_RUN = "first_run";
    private GlassfishInstanceProvider gip;
    private GlassfishWizardProvider gwp;

    private ServerUtilities(GlassfishInstanceProvider gip, GlassfishWizardProvider gwp) {
        assert (null != gip);
        this.gip = gip;
        this.gwp = gwp;
    }

    public static ServerUtilities getPreludeUtilities() {
        GlassfishInstanceProvider gip = GlassfishInstanceProvider.getPrelude();
        return null == gip ? null : new ServerUtilities(gip, null);
    }

    public static ServerUtilities getEe6Utilities() {
        GlassfishInstanceProvider gip = GlassfishInstanceProvider.getEe6();
        return null == gip ? null : new ServerUtilities(gip, GlassfishWizardProvider.createEe6());
    }

    public ServerInstance getServerInstance(String uri) {
        ServerInstance retVal = this.gip.getInstance(uri);
        return retVal;
    }

    public boolean isRegisteredUri(String uri) {
        return this.gip.getInstance(uri) != null || GlassfishInstanceProvider.activeRegistrationSet.contains(uri);
    }

    public Lookup getLookupFor(ServerInstance instance) {
        return this.gip.getLookupFor(instance);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        return this.gip.getInstanceByCapability(uri, serverFacadeClass);
    }

    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        return this.gip.getInstancesByCapability(serverFacadeClass);
    }

    public WizardDescriptor.InstantiatingIterator getAddInstanceIterator() {
        return new ServerWizardIterator(new ServerDetails[]{ServerDetails.GLASSFISH_SERVER_3_1_1, ServerDetails.GLASSFISH_SERVER_3_1_2, ServerDetails.GLASSFISH_SERVER_4_0, ServerDetails.GLASSFISH_SERVER_3_0_1, ServerDetails.GLASSFISH_SERVER_3_1, ServerDetails.GLASSFISH_SERVER_3}, new ServerDetails[]{ServerDetails.GLASSFISH_SERVER_3_1_1, ServerDetails.GLASSFISH_SERVER_3_0_1});
    }

    public ServerInstanceProvider getServerProvider() {
        return this.gip;
    }

    public static File getJarName(String glassfishInstallRoot, String jarNamePattern) {
        return ServerUtilities.getJarName(glassfishInstallRoot, jarNamePattern, GFV3_MODULES_DIR_NAME);
    }

    public static File getJarName(String glassfishInstallRoot, String jarNamePattern, String subdirectoryName) {
        File searchDirectory = new File(glassfishInstallRoot + File.separatorChar + subdirectoryName);
        return Utils.getFileFromPattern(jarNamePattern, searchDirectory);
    }

    public static File getWsJarName(String glassfishInstallRoot, String jarNamePattern) {
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + GFV3_MODULES_DIR_NAME);
        File retVal = Utils.getFileFromPattern(jarNamePattern, modulesDir);
        if (null == retVal) {
            retVal = Utils.getFileFromPattern(jarNamePattern, new File(modulesDir, "endorsed"));
        }
        return retVal;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    public static final String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    public static boolean isTP2(String gfRoot) {
        return ServerUtilities.getJarName(gfRoot, GFV3_JAR_MATCHER).getName().indexOf("-tp-2-") > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> filterByManifest(List<String> jarList, FileObject parent, int depth, boolean escape) {
        if (null != parent) {
            int parentLength = parent.getPath().length();
            if (depth == 1) {
                parentLength = parent.getParent().getPath().length();
            }
            for (FileObject candidate : parent.getChildren()) {
                if (candidate.isFolder()) {
                    if (depth >= 1) continue;
                    ServerUtilities.filterByManifest(jarList, candidate, depth + 1, escape);
                    continue;
                }
                if (!candidate.getNameExt().endsWith(".jar")) continue;
                JarFile jarFile = null;
                try {
                    String bundleName;
                    Attributes attrs;
                    jarFile = new JarFile(FileUtil.toFile((FileObject)candidate), false);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attrs = manifest.getMainAttributes()) == null || (bundleName = attrs.getValue("Bundle-SymbolicName")) == null || !bundleName.contains("javax")) continue;
                    String val = candidate.getPath().substring(parentLength);
                    if (escape) {
                        val = val.replace("\\", "\\\\");
                    }
                    jarList.add(val);
                }
                catch (IOException ex) {
                    Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, candidate.getPath(), ex);
                }
                finally {
                    if (null != jarFile) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ServerUtilities.class.getName()).log(Level.INFO, candidate.getPath(), ex);
                        }
                        jarFile = null;
                    }
                }
            }
        } else {
            Logger.getLogger(ServerUtilities.class.getName()).log(Level.FINER, "Null FileObject passed in as the parent parameter. Returning the original list");
        }
        return jarList;
    }

    public String[] getAssociatedJavaDoc() {
        return this.gip.getAssociatedJavaDoc();
    }
}

