/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.PortCollection;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class Util {
    private static String DOMAIN_XML_PATH = "config/domain.xml";
    public static final String GF_LOOKUP_PATH = "Servers/GlassFish";
    private static String INDICATOR = File.separatorChar == '/' ? "jrunscript" : "jrunscript.exe";
    private static FilenameFilter JDK6_DETECTION_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File arg0, String arg1) {
            return arg1.equalsIgnoreCase(INDICATOR);
        }
    };

    private Util() {
    }

    public static boolean appearsToBeJdk6OrBetter(File javaExecutable) {
        String[] hits;
        File dir = javaExecutable.getParentFile();
        if (null != dir && null != (hits = dir.list(JDK6_DETECTION_FILTER))) {
            return hits.length > 0;
        }
        return false;
    }

    public static final String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    @Deprecated
    public static final String escapePath(String path) {
        return Utils.escapePath(path);
    }

    public static final List<File> classPathToFileList(String cp, File root) {
        ArrayList<File> result = new ArrayList<File>();
        if (cp != null && cp.length() > 0) {
            String[] jars;
            for (String jar : jars = cp.split(File.pathSeparator)) {
                File jarFile = new File(jar);
                if (!jarFile.isAbsolute() && root != null) {
                    jarFile = new File(root, jar);
                }
                if (!jarFile.exists()) continue;
                result.add(FileUtil.normalizeFile((File)jarFile));
            }
        }
        return result;
    }

    public static boolean readServerConfiguration(File domainDir, PortCollection wi) {
        boolean result = false;
        File domainXml = new File(domainDir, DOMAIN_XML_PATH);
        final LinkedHashMap httpMap = new LinkedHashMap();
        if (domainXml.exists()) {
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path("/domain/configs/config/http-service/http-listener", new TreeParser.NodeReader(){

                @Override
                public void readAttributes(String qname, Attributes attributes) throws SAXException {
                    try {
                        String id = attributes.getValue("id");
                        if (id != null && id.length() > 0) {
                            boolean enabled;
                            int port = Integer.parseInt(attributes.getValue("port"));
                            boolean secure = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl = enabled = !"false".equals(attributes.getValue("enabled"));
                            if (enabled) {
                                HttpData data = new HttpData(id, port, secure);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding {0}", data);
                                httpMap.put(id, data);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener {0} is not enabled and won''t be used.", id);
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }));
            pathList.add(new TreeParser.Path("/domain/configs/config/network-config/network-listeners/network-listener", new TreeParser.NodeReader(){

                @Override
                public void readAttributes(String qname, Attributes attributes) throws SAXException {
                    try {
                        String id = attributes.getValue("name");
                        if (id != null && id.length() > 0) {
                            boolean enabled;
                            String portAttr = attributes.getValue("port");
                            if (null == portAttr || portAttr.startsWith("$")) {
                                return;
                            }
                            int port = Integer.parseInt(portAttr);
                            boolean secure = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl = enabled = !"false".equals(attributes.getValue("enabled"));
                            if (enabled) {
                                HttpData data = new HttpData(id, port, secure);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding {0}", data);
                                httpMap.put(id, data);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener {0} is not enabled and won''t be used.", id);
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }));
            try {
                int adminPort;
                TreeParser.readXml(domainXml, pathList);
                HttpData adminData = (HttpData)httpMap.remove("admin-listener");
                if (null != wi) {
                    wi.setAdminPort(adminData != null ? adminData.getPort() : -1);
                }
                HttpData httpData = null;
                HttpData httpsData = null;
                for (HttpData data : httpMap.values()) {
                    if (data.isSecure()) {
                        if (httpsData == null) {
                            httpsData = data;
                        }
                    } else if (httpData == null) {
                        httpData = data;
                    }
                    if (httpData == null || httpsData == null) continue;
                    break;
                }
                int httpPort = httpData != null ? httpData.getPort() : -1;
                int n = adminPort = null != adminData ? adminData.getPort() : -1;
                if (null != wi) {
                    wi.setHttpPort(httpPort);
                    wi.setHttpsPort(httpsData != null ? httpsData.getPort() : -1);
                }
                result = httpPort != -1 && adminPort != -1;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return result;
    }

    public static String computeTarget(Map<String, String> ip) {
        String candidate;
        int lastColon;
        String retVal = null;
        String url = ip.get("url");
        if (null != url && (lastColon = url.lastIndexOf(58)) != -1 && !Character.isDigit((candidate = url.substring(lastColon + 1)).charAt(0))) {
            retVal = candidate;
        }
        return retVal;
    }

    public static boolean isDefaultOrServerTarget(Map<String, String> ip) {
        String target = Util.computeTarget(ip);
        return null == target || "server".equals(target);
    }

    private static class HttpData {
        private final String id;
        private final int port;
        private final boolean secure;

        public HttpData(String id, int port, boolean secure) {
            this.id = id;
            this.port = port;
            this.secure = secure;
        }

        public String getId() {
            return this.id;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return "{ " + this.id + ", " + this.port + ", " + this.secure + " }";
        }
    }
}

