/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.ProfilingSettings;

public class ProfilingSettingsPresets {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    private static final String MONITOR_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_MonitorPresetName");
    private static final String CPU_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_CpuPresetName");
    private static final String MEMORY_PRESET_NAME = bundle.getString("ProfilingSettingsPresets_MemoryPresetName");

    public static ProfilingSettings createCPUPreset() {
        return ProfilingSettingsPresets.createCPUPreset(64);
    }

    public static ProfilingSettings createCPUPreset(int type) {
        return new CPUPreset(type);
    }

    public static ProfilingSettings createMemoryPreset() {
        return ProfilingSettingsPresets.createMemoryPreset(2);
    }

    public static ProfilingSettings createMemoryPreset(int type) {
        return new MemoryPreset(type);
    }

    public static ProfilingSettings createMonitorPreset() {
        return new MonitorPreset();
    }

    private static final class MonitorPreset
    extends ProfilingSettings {
        public MonitorPreset() {
            this.setIsPreset(true);
            this.setProfilingType(1);
            this.setSettingsName(MONITOR_PRESET_NAME);
        }
    }

    private static final class MemoryPreset
    extends ProfilingSettings {
        public MemoryPreset(int type) {
            this.setIsPreset(true);
            this.setProfilingType(type);
            this.setSettingsName(MEMORY_PRESET_NAME);
        }
    }

    private static final class CPUPreset
    extends ProfilingSettings {
        public CPUPreset(int type) {
            this.setIsPreset(true);
            this.setProfilingType(type);
            this.setSettingsName(CPU_PRESET_NAME);
            this.setCPUProfilingType(type == 64 ? 2 : 0);
            this.setInstrumentGetterSetterMethods(false);
            this.setInstrumentEmptyMethods(false);
            this.setInstrumentMethodInvoke(true);
            this.setExcludeWaitTime(true);
            if (type == 8) {
                this.setInstrScheme(3);
                this.setInstrumentSpawnedThreads(false);
            } else if (type == 16) {
                this.setInstrScheme(1);
                this.setInstrumentSpawnedThreads(false);
            } else if (type == 64) {
                this.setSamplingFrequency(10);
                this.setThreadCPUTimerOn(true);
            }
        }
    }
}

