/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class ResolvedPath {
    private final CharSequence folder;
    private final FileSystem fileSystem;
    private final CharSequence path;
    private final boolean isDefaultSearchPath;
    private final int index;

    public ResolvedPath(FileSystem fileSystem, CharSequence folder, CharSequence path, boolean isDefaultSearchPath, int index) {
        this.folder = folder;
        this.fileSystem = fileSystem;
        this.path = FilePathCache.getManager().getString(path);
        this.isDefaultSearchPath = isDefaultSearchPath;
        this.index = index;
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (debug) {
            if (!CndFileUtils.isExistingFile((FileSystem)fileSystem, (String)((Object)this.path).toString())) {
                APTUtils.LOG.log(Level.WARNING, "ResolvedPath: isExistingFile failed in {0} for {1}", new Object[]{fileSystem, path});
            }
            if (CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) && !new File(((Object)this.path).toString()).isFile()) {
                APTUtils.LOG.log(Level.WARNING, "ResolvedPath: isFile failed for {0}", path);
            }
            if (CndFileUtils.toFileObject((FileSystem)fileSystem, (CharSequence)path) == null) {
                APTUtils.LOG.log(Level.WARNING, "ResolvedPath: no FileObject in {0} for {1} FileUtil.toFileObject = {2} second check = {3}", new Object[]{fileSystem, path, FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)((Object)path).toString()))), fileSystem.findResource(((Object)path).toString())});
            }
        }
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)folder);
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)path);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FileObject getFileObject() {
        return CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.path);
    }

    public CharSequence getPath() {
        return this.path;
    }

    public CharSequence getFolder() {
        return this.folder;
    }

    public boolean isDefaultSearchPath() {
        return this.isDefaultSearchPath;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.path + " in " + this.folder + " at " + this.fileSystem;
    }
}

