/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.SortedSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CustomizerDisplay
extends NbPropertyPanel.Single {
    private boolean noBundle;
    private boolean showInPluginManagerCheckboxChanged;
    private JLabel categoryLabel;
    private JComboBox categoryValue;
    private JPanel hackPanel;
    private JLabel longDesc;
    private JTextArea longDescValue;
    private JScrollPane longDescValueSP;
    private JLabel name;
    private JTextField nameValue;
    private JLabel shortDesc;
    private JTextField shortDescValue;
    private JCheckBox showInPluginManagerCheckbox;

    CustomizerDisplay(SingleModuleProperties props, ProjectCustomizer.Category cat) {
        super(props, CustomizerDisplay.class, cat);
        this.initComponents();
        this.initAccessibility();
        this.refresh();
        this.checkValidity();
    }

    @Override
    protected void refresh() {
        boolean bl = this.noBundle = this.getBundle() == null;
        if (this.noBundle) {
            this.nameValue.setEnabled(false);
            this.categoryValue.setEnabled(false);
            this.shortDescValue.setEnabled(false);
            this.longDescValue.setEnabled(false);
        } else {
            this.readFromProperties();
        }
        Boolean autoUpdateShowInClient = ((SingleModuleProperties)this.props).getAutoUpdateShowInClient();
        if (autoUpdateShowInClient == null) {
            autoUpdateShowInClient = !this.getBooleanProperty("is.autoload") && !this.getBooleanProperty("is.eager");
        }
        this.showInPluginManagerCheckbox.setSelected(autoUpdateShowInClient);
        this.showInPluginManagerCheckboxChanged = false;
        final NbPlatform plaf = this.getProperties().getActivePlatform();
        if (plaf != null) {
            ModuleProperties.RP.post(new Runnable(){

                @Override
                public void run() {
                    final boolean visible = plaf.getModule("org.netbeans.modules.autoupdate.services") != null;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustomizerDisplay.this.showInPluginManagerCheckbox.setVisible(visible);
                        }
                    });
                }
            });
        }
    }

    private void checkValidity() {
        if (this.noBundle) {
            this.category.setErrorMessage(CustomizerDisplay.getMessage("MSG_NoBundleForModule"));
        } else {
            this.category.setErrorMessage(null);
        }
    }

    @Override
    public void store() {
        if (!this.noBundle) {
            this.getBundle().setDisplayName(this.nameValue.getText());
            this.getBundle().setCategory(this.getSelectedCategory());
            this.getBundle().setShortDescription(this.shortDescValue.getText());
            this.getBundle().setLongDescription(this.longDescValue.getText());
        }
        if (this.showInPluginManagerCheckboxChanged) {
            ((SingleModuleProperties)this.props).setAutoUpdateShowInClient(this.showInPluginManagerCheckbox.isSelected());
        }
    }

    private LocalizedBundleInfo getBundle() {
        return this.getProperties().getBundleInfo();
    }

    private void readFromProperties() {
        ApisupportAntUIUtils.setText(this.nameValue, this.getBundle().getDisplayName());
        ApisupportAntUIUtils.setText(this.shortDescValue, this.getBundle().getShortDescription());
        this.longDescValue.setText(this.getBundle().getLongDescription());
        this.fillUpCategoryValue();
    }

    private void fillUpCategoryValue() {
        this.categoryValue.setEnabled(false);
        this.categoryValue.setModel(UIUtil.createComboWaitModel());
        this.categoryValue.setSelectedItem(UIUtil.WAIT_VALUE);
        ModuleProperties.RP.post(new Runnable(){

            @Override
            public void run() {
                final SortedSet<String> moduleCategories = CustomizerDisplay.this.getProperties().getModuleCategories();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                        CustomizerDisplay.this.categoryValue.removeAllItems();
                        for (String cat : moduleCategories) {
                            model.addElement(cat);
                        }
                        if (!moduleCategories.contains(CustomizerDisplay.this.getCategory())) {
                            model.insertElementAt(CustomizerDisplay.this.getCategory(), 0);
                        }
                        CustomizerDisplay.this.categoryValue.setModel(model);
                        CustomizerDisplay.this.categoryValue.setSelectedItem(CustomizerDisplay.this.getCategory());
                        CustomizerDisplay.this.categoryValue.setEnabled(true);
                    }
                });
            }
        });
    }

    private String getCategory() {
        LocalizedBundleInfo bundle = this.getBundle();
        String cat = bundle != null ? bundle.getCategory() : null;
        return cat != null ? cat : "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("nbPlatform".equals(evt.getPropertyName())) {
            this.fillUpCategoryValue();
        }
    }

    private String getSelectedCategory() {
        String cat = (String)this.categoryValue.getSelectedItem();
        return UIUtil.WAIT_VALUE.equals(cat) ? this.getCategory() : cat;
    }

    private void initComponents() {
        this.name = new JLabel();
        this.nameValue = new JTextField();
        this.categoryLabel = new JLabel();
        this.categoryValue = new JComboBox();
        this.shortDesc = new JLabel();
        this.shortDescValue = new JTextField();
        this.longDesc = new JLabel();
        this.hackPanel = new JPanel();
        this.longDescValueSP = new JScrollPane();
        this.longDescValue = new JTextArea();
        this.showInPluginManagerCheckbox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.name.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.name, (String)NbBundle.getMessage(CustomizerDisplay.class, (String)"LBL_DisplayName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.nameValue, gridBagConstraints);
        this.categoryLabel.setLabelFor(this.categoryValue);
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)NbBundle.getMessage(CustomizerDisplay.class, (String)"LBL_DisplayCategory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryValue.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.categoryValue, gridBagConstraints);
        this.shortDesc.setLabelFor(this.shortDescValue);
        Mnemonics.setLocalizedText((JLabel)this.shortDesc, (String)NbBundle.getMessage(CustomizerDisplay.class, (String)"LBL_ShortDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.shortDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.shortDescValue, gridBagConstraints);
        this.longDesc.setLabelFor(this.longDescValue);
        Mnemonics.setLocalizedText((JLabel)this.longDesc, (String)NbBundle.getMessage(CustomizerDisplay.class, (String)"LBL_LongDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 6);
        this.add((Component)this.longDesc, gridBagConstraints);
        this.hackPanel.setLayout(new BorderLayout());
        this.longDescValue.setLineWrap(true);
        this.longDescValue.setRows(10);
        this.longDescValue.setWrapStyleWord(true);
        this.longDescValueSP.setViewportView(this.longDescValue);
        this.hackPanel.add((Component)this.longDescValueSP, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.hackPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showInPluginManagerCheckbox, (String)NbBundle.getMessage(CustomizerDisplay.class, (String)"CustomizerDisplay.showInPluginManagerCheckbox.text"));
        this.showInPluginManagerCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.showInPluginManagerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDisplay.this.showInPluginManagerCheckboxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.showInPluginManagerCheckbox, gridBagConstraints);
    }

    private void showInPluginManagerCheckboxActionPerformed(ActionEvent evt) {
        this.showInPluginManagerCheckboxChanged = true;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerDisplay.class, (String)key);
    }

    private void initAccessibility() {
        this.longDescValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_LongDescValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_NameValue"));
        this.shortDescValue.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("ACSD_ShortDescValue"));
        this.showInPluginManagerCheckbox.getAccessibleContext().setAccessibleDescription(CustomizerDisplay.getMessage("CustomizerDisplay.showInPluginManagerCheckbox.AccessibleContext.accessibleDescription"));
    }
}

