/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.ioprovider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.support.DefaultFindState;
import org.netbeans.lib.terminalemulator.support.FindState;
import org.netbeans.lib.terminalemulator.support.TermOptions;
import org.netbeans.modules.terminal.TermAdvancedOption;
import org.netbeans.modules.terminal.api.IOResizable;
import org.netbeans.modules.terminal.api.IOVisibilityControl;
import org.netbeans.modules.terminal.ioprovider.Catalog;
import org.netbeans.modules.terminal.ioprovider.Task;
import org.netbeans.modules.terminal.ioprovider.TerminalInputOutput;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Terminal
extends JComponent {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final IOContainer ioContainer;
    private final TerminalInputOutput tio;
    private final String name;
    private final MouseAdapter mouseAdapter;
    private final CallBacks callBacks = new CallBacks();
    private final ActiveTerm term;
    private final TermListener termListener;
    private FindState findState;
    private static final Preferences prefs = NbPreferences.forModule(TermAdvancedOption.class);
    private final TermOptions termOptions;
    private final TermOptionsPCL termOptionsPCL = new TermOptionsPCL();
    private final FileObject shortcutsDir = FileUtil.getConfigFile((String)"Terminal/Shortcuts");
    private final ShortcutsListener shortcutsListener = new ShortcutsListener();
    private String title;
    private boolean visibleInContainer;
    private boolean outConnected;
    private boolean errConnected;
    private boolean extConnected;
    private boolean disposed;
    private boolean closable = true;
    private boolean closedUnconditionally;
    private static final String BOOLEAN_STATE_ACTION_KEY = "boolean_state_action";
    private static final String BOOLEAN_STATE_ENABLED_KEY = "boolean_state_enabled";
    private final Action copyAction = new CopyAction();
    private final Action setTitleAction = new SetTitleAction();
    private final Action pasteAction = new PasteAction();
    private final Action findAction = new FindAction();
    private final Action wrapAction = new WrapAction();
    private final Action clearAction = new ClearAction();
    private final Action closeAction = new CloseAction();

    Terminal(IOContainer ioContainer, TerminalInputOutput tio, String name) {
        if (ioContainer == null) {
            throw new IllegalArgumentException("ioContainer cannot be null");
        }
        this.ioContainer = ioContainer;
        this.tio = tio;
        this.name = name;
        this.termOptions = TermOptions.getDefault((Preferences)prefs);
        this.term = new ActiveTerm();
        this.applyDebugFlags();
        this.term.setCursorVisible(true);
        this.findState = new DefaultFindState((Term)this.term);
        this.term.setHorizontallyScrollable(false);
        this.term.setEmulation("ansi");
        this.term.setBackground(Color.white);
        this.term.setHistorySize(4000);
        this.term.setRenderingHints(this.getRenderingHints());
        this.shortcutsDir.addFileChangeListener((FileChangeListener)this.shortcutsListener);
        this.termOptions.addPropertyChangeListener((PropertyChangeListener)this.termOptionsPCL);
        this.applyTermOptions(true);
        HashSet<Action> actions = new HashSet<Action>();
        actions.add(this.copyAction);
        actions.add(this.pasteAction);
        actions.add(this.findAction);
        actions.add(this.wrapAction);
        actions.add(this.clearAction);
        actions.add(this.closeAction);
        this.setupKeymap(actions);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), Terminal.this.term.getScreen());
                    Terminal.this.postPopupMenu(p);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), Terminal.this.term.getScreen());
                    Terminal.this.postPopupMenu(p);
                }
            }
        };
        this.term.getScreen().addMouseListener(this.mouseAdapter);
        this.termListener = new MyTermListener();
        this.term.addListener(this.termListener);
        this.term.setActionListener(new ActiveTermListener(){

            public void action(ActiveRegion r, InputEvent e) {
                OutputListener ol = (OutputListener)r.getUserObject();
                if (ol == null) {
                    return;
                }
                Extent extent = r.getExtent();
                String text = Terminal.this.term.textWithin(extent.begin, extent.end);
                TerminalOutputEvent oe = new TerminalOutputEvent(Terminal.this.tio, text);
                ol.outputLineAction((OutputEvent)oe);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.term, "Center");
        this.setFocusable(false);
    }

    void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.term.getScreen().removeMouseListener(this.mouseAdapter);
        this.term.removeListener(this.termListener);
        this.term.setActionListener(null);
        this.findState = null;
        this.shortcutsDir.removeFileChangeListener((FileChangeListener)this.shortcutsListener);
        this.termOptions.removePropertyChangeListener((PropertyChangeListener)this.termOptionsPCL);
        this.tio.dispose();
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public IOContainer.CallBacks callBacks() {
        return this.callBacks;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void requestFocus() {
        this.term.getScreen().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.term.getScreen().requestFocusInWindow();
    }

    private void applyDebugFlags() {
        String value = System.getProperty("Term.debug");
        if (value == null) {
            return;
        }
        int flags = 0;
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.toLowerCase().equals("ops")) {
                flags |= 1;
                continue;
            }
            if (s.toLowerCase().equals("keys")) {
                flags |= 2;
                continue;
            }
            if (s.toLowerCase().equals("input")) {
                flags |= 4;
                continue;
            }
            if (s.toLowerCase().equals("output")) {
                flags |= 8;
                continue;
            }
            if (s.toLowerCase().equals("wrap")) {
                flags |= 0x10;
                continue;
            }
            if (!s.toLowerCase().equals("margins")) continue;
            flags |= 0x20;
        }
        this.term.setDebugFlags(flags);
    }

    private void applyTermOptions(boolean initial) {
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        if (initial) {
            this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        }
        this.applyShortcuts();
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public ActiveTerm term() {
        return this.term;
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateName();
    }

    public String getTitle() {
        return this.title == null ? this.name : this.title;
    }

    FindState getFindState() {
        return this.findState;
    }

    void setClosedUnconditionally(boolean closedUnconditionally) {
        this.closedUnconditionally = closedUnconditionally;
    }

    boolean isClosedUnconditionally() {
        return this.closedUnconditionally;
    }

    public void closeUnconditionally() {
        this.setClosedUnconditionally(true);
        this.close();
    }

    public void close() {
        if (!this.isVisibleInContainer()) {
            return;
        }
        this.ioContainer.remove((JComponent)this);
    }

    public void setVisibleInContainer(boolean visible) {
        boolean wasVisible = this.visibleInContainer;
        this.visibleInContainer = visible;
        if (visible != wasVisible) {
            this.tio.pcs().firePropertyChange("IOVisibility.PROP_VISIBILITY", wasVisible, visible);
        }
    }

    public boolean isVisibleInContainer() {
        return this.visibleInContainer;
    }

    public void setOutConnected(boolean outConnected) {
        boolean wasConnected = this.isConnected();
        this.outConnected = outConnected;
        if (!outConnected) {
            this.errConnected = false;
        }
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public void setErrConnected(boolean errConnected) {
        boolean wasConnected = this.isConnected();
        this.errConnected = errConnected;
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public void setExtConnected(boolean extConnected) {
        boolean wasConnected = this.isConnected();
        this.extConnected = extConnected;
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public boolean isConnected() {
        return this.outConnected || this.errConnected || this.extConnected;
    }

    private boolean okToHide() {
        try {
            this.tio.vcs().fireVetoableChange("IOVisibility.PROP_VISIBILITY", true, false);
        }
        catch (PropertyVetoException ex) {
            return false;
        }
        return true;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.putClientProperty("noCloseButton", !closable);
    }

    public boolean isClosable() {
        return this.closable;
    }

    private void updateName() {
        Task.UpdateName task = new Task.UpdateName(this.ioContainer, this);
        task.post();
    }

    private boolean isBooleanStateAction(Action a) {
        Boolean isBooleanStateAction = (Boolean)a.getValue(BOOLEAN_STATE_ACTION_KEY);
        return isBooleanStateAction != null && isBooleanStateAction != false;
    }

    private void addMenuItem(JPopupMenu menu, Object o) {
        if (o instanceof JSeparator) {
            menu.add((JSeparator)o);
        } else if (o instanceof Action) {
            Action a = (Action)o;
            if (this.isBooleanStateAction(a)) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
                item.setSelected((Boolean)a.getValue(BOOLEAN_STATE_ENABLED_KEY));
                menu.add(item);
            } else {
                menu.add((Action)o);
            }
        }
    }

    private void setupKeymap(Set<Action> actions) {
        JComponent comp = this.term.getScreen();
        ActionMap actionMap = comp.getActionMap();
        ActionMap newActionMap = new ActionMap();
        newActionMap.setParent(actionMap);
        InputMap inputMap = comp.getInputMap();
        InputMap newInputMap = new InputMap();
        newInputMap.setParent(inputMap);
        HashSet<KeyStroke> passKeystrokes = new HashSet<KeyStroke>();
        for (Action a : actions) {
            String n = (String)a.getValue("Name");
            KeyStroke accelerator = (KeyStroke)a.getValue("AcceleratorKey");
            if (accelerator == null) continue;
            newInputMap.put(accelerator, n);
            newActionMap.put(n, a);
            passKeystrokes.add(accelerator);
        }
        comp.setActionMap(newActionMap);
        comp.setInputMap(0, newInputMap);
        this.term.setKeyStrokeSet(passKeystrokes);
    }

    private void postPopupMenu(Point p) {
        JPopupMenu menu = new JPopupMenu();
        menu.putClientProperty("container", this.ioContainer);
        menu.putClientProperty("component", this);
        this.addMenuItem(menu, this.copyAction);
        this.addMenuItem(menu, this.pasteAction);
        this.addMenuItem(menu, new JSeparator());
        this.addMenuItem(menu, this.findAction);
        this.addMenuItem(menu, new JSeparator());
        this.addMenuItem(menu, this.wrapAction);
        this.addMenuItem(menu, new JSeparator());
        this.addMenuItem(menu, this.setTitleAction);
        this.addMenuItem(menu, new JSeparator());
        this.addMenuItem(menu, this.clearAction);
        if (this.isClosable()) {
            this.addMenuItem(menu, this.closeAction);
        }
        this.findAction.setEnabled(!this.findState.isVisible());
        this.findAction.setEnabled(false);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        menu.show(this.term.getScreen(), p.x, p.y);
    }

    private Map<?, ?> getRenderingHints() {
        AttributeSet attributes;
        FontColorSettings fcs;
        Map renderingHints = null;
        Lookup lookup = MimeLookup.getLookup((String)"text/plain");
        if (lookup != null && (fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class)) != null && (attributes = fcs.getFontColors("default")) != null) {
            renderingHints = (Map)attributes.getAttribute(EditorStyleConstants.RenderingHints);
        }
        return renderingHints;
    }

    void scrollTo(Coord coord) {
        this.term.possiblyNormalize(coord);
    }

    private void applyShortcuts() {
        if (!this.termOptions.getIgnoreKeymap()) {
            HashSet<Action> actions = new HashSet<Action>();
            for (FileObject def : this.shortcutsDir.getChildren()) {
                try {
                    DataObject dobj = DataObject.find((FileObject)def);
                    InstanceCookie ic = (InstanceCookie)dobj.getLookup().lookup(InstanceCookie.class);
                    if (ic == null) continue;
                    actions.add((Action)ic.instanceCreate());
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            this.term.setKeymap((Keymap)Lookup.getDefault().lookup(Keymap.class), actions);
        } else {
            this.term.setKeymap(null, null);
        }
    }

    private class ShortcutsListener
    extends FileChangeAdapter {
        private ShortcutsListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileChanged(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileDataCreated(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileDeleted(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileFolderCreated(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileRenamed(FileRenameEvent fe) {
            Terminal.this.applyShortcuts();
        }
    }

    private final class WrapAction
    extends AbstractAction {
        public WrapAction() {
            super(Catalog.get("CTL_Wrap"));
            this.putValue(Terminal.BOOLEAN_STATE_ACTION_KEY, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            boolean hs = Terminal.this.term.isHorizontallyScrollable();
            Terminal.this.term.setHorizontallyScrollable(!hs);
        }

        @Override
        public Object getValue(String key) {
            if (key.equals(Terminal.BOOLEAN_STATE_ENABLED_KEY)) {
                return !Terminal.this.term.isHorizontallyScrollable();
            }
            return super.getValue(key);
        }
    }

    private final class FindAction
    extends AbstractAction {
        public FindAction() {
            super(Catalog.get("CTL_Find"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FindState findState = Terminal.this.getFindState();
            if (findState.isVisible()) {
                return;
            }
            findState.setVisible(true);
        }
    }

    private final class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(Catalog.get("CTL_Paste"));
            KeyStroke accelerator = KeyStroke.getKeyStroke(86, 3);
            this.putValue("AcceleratorKey", accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Terminal.this.term.pasteFromClipboard();
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(Catalog.get("CTL_Copy"));
            KeyStroke accelerator = KeyStroke.getKeyStroke(67, 3);
            this.putValue("AcceleratorKey", accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Terminal.this.term.copyToClipboard();
        }
    }

    private final class SetTitleAction
    extends AbstractAction {
        public SetTitleAction() {
            super(Catalog.get("CTL_SetTitle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newTitle;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Catalog.get("LBL_Title"), Catalog.get("LBL_SetTitle"));
            String title = Terminal.this.getTitle();
            inputLine.setInputText(title);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION && !(newTitle = inputLine.getInputText().trim()).equals(title)) {
                Terminal.this.setTitle(newTitle);
            }
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Catalog.get("CTL_Close"));
            KeyStroke accelerator = KeyStroke.getKeyStroke(87, 3);
            this.putValue("AcceleratorKey", accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Terminal.this.close();
        }

        @Override
        public boolean isEnabled() {
            return Terminal.this.closable;
        }
    }

    private final class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(Catalog.get("CTL_Clear"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Terminal.this.term.clear();
        }
    }

    private static class TerminalOutputEvent
    extends OutputEvent {
        private final String text;

        public TerminalOutputEvent(InputOutput io, String text) {
            super(io);
            this.text = text;
        }

        public String getLine() {
            return this.text;
        }
    }

    private class MyTermListener
    implements TermListener {
        private MyTermListener() {
        }

        public void sizeChanged(Dimension cells, Dimension pixels) {
            IOResizable.Size size = new IOResizable.Size(cells, pixels);
            Terminal.this.tio.pcs().firePropertyChange("IOResizable.PROP_SIZE", null, size);
        }
    }

    private class CallBacks
    implements IOContainer.CallBacks,
    Lookup.Provider {
        private final Lookup lookup = Lookups.fixed((Object[])new Object[]{new MyIOVisibilityControl()});

        private CallBacks() {
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void closed() {
            Terminal.this.setVisibleInContainer(false);
        }

        public void selected() {
        }

        public void activated() {
        }

        public void deactivated() {
        }

        private class MyIOVisibilityControl
        extends IOVisibilityControl {
            private MyIOVisibilityControl() {
            }

            @Override
            protected boolean okToClose() {
                if (Terminal.this.isClosedUnconditionally()) {
                    return true;
                }
                return Terminal.this.okToHide();
            }

            @Override
            protected boolean isClosable() {
                if (Terminal.this.isClosedUnconditionally()) {
                    return true;
                }
                return Terminal.this.isClosable();
            }
        }
    }

    private class TermOptionsPCL
    implements PropertyChangeListener {
        private TermOptionsPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Terminal.this.applyTermOptions(false);
        }
    }
}

