/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.openide.util.Exceptions;

public enum HotCharIndent {
    INSTANCE;


    public boolean getKeywordBasedReformatBlock(BaseDocument doc, int dotPos, String typedText) {
        if (HotCharIndent.isTokenContinue(doc, dotPos)) {
            return false;
        }
        if ("e".equals(typedText)) {
            try {
                int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                if (HotCharIndent.checkCase(doc, fnw, "else")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "#else")) {
                    return true;
                }
            }
            catch (BadLocationException e) {}
        } else if ("f".equals(typedText)) {
            try {
                int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                if (HotCharIndent.checkCase(doc, fnw, "#if")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "#elif")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "#ifdef")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "#ifndef")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "#endif")) {
                    return true;
                }
            }
            catch (BadLocationException e) {}
        } else if (":".equals(typedText)) {
            try {
                int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                if (HotCharIndent.checkCase(doc, fnw, "case")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "default")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "public")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "protected")) {
                    return true;
                }
                if (HotCharIndent.checkCase(doc, fnw, "private")) {
                    return true;
                }
            }
            catch (BadLocationException e) {}
        } else if ("{".equals(typedText) || "}".equals(typedText)) {
            try {
                int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                return HotCharIndent.checkCase(doc, fnw, typedText);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        if (typedText != null && typedText.length() == 1 && (Character.isLetter(typedText.charAt(0)) || typedText.charAt(0) == '#')) {
            try {
                int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                if (HotCharIndent.checkCase(doc, fnw, typedText + "\n") || dotPos == doc.getLength() - 1 && HotCharIndent.checkCase(doc, fnw, typedText)) {
                    return true;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkCase(BaseDocument doc, int fnw, String what) throws BadLocationException {
        return fnw >= 0 && fnw + what.length() <= doc.getLength() && what.equals(doc.getText(fnw, what.length()));
    }

    static boolean isTokenContinue(BaseDocument doc, int dotPos) {
        try {
            String prev;
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
            if (rowStart > 1 && "\\\n".equals(prev = doc.getText(rowStart - 2, 2))) {
                return true;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }
}

