/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.editor.filecreation;

import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.CndPanel;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.cnd.simpleunit.editor.filecreation.NewTestSimplePanelGUI;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NewTestSimplePanel
extends CndPanel {
    private final String baseTestName;
    private final MIMEExtensions es;
    private final String defaultExt;
    private final boolean fileWithoutExtension;

    NewTestSimplePanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, MIMEExtensions es, String defaultExt, String baseTestName) {
        super(project, folders, bottomPanel);
        this.baseTestName = baseTestName;
        this.es = es;
        this.defaultExt = defaultExt;
        this.fileWithoutExtension = "".equals(defaultExt);
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new NewTestSimplePanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.es, this.defaultExt, this.baseTestName);
            this.gui.addChangeListener((ChangeListener)((Object)this));
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("CreateTestWizardP2");
    }

    protected void doStoreSettings(WizardDescriptor settings) {
        if (this.getTargetExtension().length() > 0) {
            if (((NewTestSimplePanelGUI)this.gui).useTargetExtensionAsDefault()) {
                this.es.setDefaultExtension(this.getTargetExtension());
            } else {
                this.es.addExtension(this.getTargetExtension());
            }
        }
    }

    public boolean isValid() {
        String errorMessage;
        boolean ok = super.isValid();
        this.setErrorMessage("");
        if (!ok) {
            return false;
        }
        String documentName = this.gui.getTargetName();
        if (!this.fileWithoutExtension && this.getTargetExtension().length() == 0 || documentName.charAt(0) == '.') {
            this.setErrorMessage(NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_Invalid_File_Name"));
            return false;
        }
        if (!this.fileWithoutExtension && !this.es.getValues().contains(this.getTargetExtension())) {
            String msg = NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_new_extension_introduced", (Object)this.getTargetExtension());
            this.setErrorMessage(msg);
        }
        if ((errorMessage = NewTestSimplePanel.canUseFileName((FileObject)this.gui.getTargetGroup().getRootFolder(), (String)this.gui.getTargetFolder(), (String)documentName, (boolean)false)) != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    private String getTargetExtension() {
        return ((NewTestSimplePanelGUI)this.gui).getTargetExtension();
    }

    public static FileObject getTemplateFileObject(String formType) {
        return FileUtil.getConfigFile((String)("Templates/testFiles/" + formType));
    }

    public static DataObject getTemplateDataObject(String formType) {
        FileObject fileObj = NewTestSimplePanel.getTemplateFileObject(formType);
        if (fileObj != null) {
            try {
                return DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTemplateDisplayName(String formType) {
        DataObject dataObj = NewTestSimplePanel.getTemplateDataObject(formType);
        if (dataObj != null) {
            return dataObj.getNodeDelegate().getDisplayName();
        }
        return formType;
    }
}

