/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class YamlCompletion
implements CodeCompletionHandler {
    private String refcard;
    private static final String[] YAML_KEYS = new String[]{"? ", "Key indicator.", ": ", "Value indicator.", "- ", "Nested series entry indicator.", ", ", "Separate in-line branch entries.", "[]", "Surround in-line series branch.", "{}", "Surround in-line keyed branch.", "'", "Surround in-line unescaped scalar", "\"", "Surround in-line escaped scalar", "|", "Block scalar indicator.", ">", "Folded scalar indicator.", "-", "Strip chomp modifier ('|-' or '>-').", "+", "Keep chomp modifier ('|+' or '>+').", "&", "Anchor property.", "*", "Alias indicator.", "!", "Non-specific tag", "!foo", "Primary", "!!foo", "Secondary", "!h!foo", "Requires \"%TAG !h! <prefix>\"", "!<foo>", "Verbatim tag (always means \"foo\").", "%", "Directive indicator.", "---", "Document header.", "...", "Document terminator.", "#", "Throwaway comment indicator.", "`@", "Both reserved for future use.", "=", "Default \"value\" mapping key.", "<<", "Merge keys from another mapping.", "!!map", "{ Hash table, dictionary, mapping }", "!!seq", "{ List, array, tuple, vector, sequence }", "!!str", "Unicode string", "!!set", "{ cherries, plums, apples }", "!!omap", "[ one: 1, two: 2 ]"};
    private static ImageIcon keywordIcon;

    private boolean startsWith(String theString, String prefix, boolean caseSensitive) {
        if (prefix.length() == 0) {
            return true;
        }
        return caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public CodeCompletionResult complete(CodeCompletionContext context) {
        KeywordItem item;
        String desc;
        String word;
        int i;
        ArrayList<KeywordItem> proposals = new ArrayList<KeywordItem>();
        boolean caseSensitive = context.isCaseSensitive();
        String prefix = context.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        int anchor = context.getCaretOffset();
        int n = YAML_KEYS.length;
        for (i = 0; i < n; i += 2) {
            word = YAML_KEYS[i];
            desc = YAML_KEYS[i + 1];
            if (!this.startsWith(word, prefix, caseSensitive)) continue;
            item = new KeywordItem(word, desc, anchor, Integer.toString(10000 + i));
            proposals.add(item);
        }
        if (proposals.size() == 0) {
            n = YAML_KEYS.length;
            for (i = 0; i < n; i += 2) {
                word = YAML_KEYS[i];
                desc = YAML_KEYS[i + 1];
                item = new KeywordItem(word, desc, anchor, Integer.toString(10000 + i));
                proposals.add(item);
            }
        }
        DefaultCompletionResult result = new DefaultCompletionResult(proposals, false);
        result.setFilterable(false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String document(ParserResult info, ElementHandle element) {
        if (this.refcard == null) {
            this.refcard = "";
            BufferedInputStream is = null;
            StringBuilder sb = new StringBuilder();
            try {
                int c;
                is = new BufferedInputStream(YamlCompletion.class.getResourceAsStream("refcard.html"));
                while ((c = ((InputStream)is).read()) != -1) {
                    sb.append((char)c);
                }
                if (sb.length() > 0) {
                    this.refcard = sb.toString();
                }
            }
            catch (IOException ie) {
                Exceptions.printStackTrace((Throwable)ie);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ie) {
                    Exceptions.printStackTrace((Throwable)ie);
                }
            }
        }
        return this.refcard.length() > 0 ? this.refcard : null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        if (caretOffset > 0) {
            try {
                Document doc = ((YamlParserResult)info).getSnapshot().getSource().getDocument(false);
                if (doc != null) {
                    return doc.getText(caretOffset - 1, 1);
                }
                return null;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private static class KeywordItem
    implements CompletionProposal,
    ElementHandle {
        private int anchor;
        private static final String YAML_KEYWORD = "org/netbeans/modules/languages/yaml/yaml_files_16.png";
        private final String keyword;
        private final String description;
        private final String sort;

        KeywordItem(String keyword, String description, int anchor, String sort) {
            this.keyword = keyword;
            this.description = description;
            this.anchor = anchor;
            this.sort = sort;
        }

        public String getName() {
            return this.keyword;
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.description != null) {
                formatter.appendHtml(this.description);
                return formatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)YAML_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public ElementHandle getElement() {
            return this;
        }

        public boolean isSmart() {
            return false;
        }

        public int getAnchorOffset() {
            return this.anchor;
        }

        public String getInsertPrefix() {
            return this.keyword;
        }

        public String getSortText() {
            return this.sort;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(ElementKind.KEYWORD, true);
            formatter.appendText(this.getName());
            formatter.name(ElementKind.KEYWORD, false);
            return formatter.getText();
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "text/x-yaml";
        }

        public String getIn() {
            return null;
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public int getSortPrioOverride() {
            return 0;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }
}

