/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WLDriverDeployer
implements JDBCDriverDeployer {
    private static final Logger LOGGER = Logger.getLogger(WLDriverDeployer.class.getName());
    private static final RequestProcessor DRIVER_DEPLOYMENT_RP = new RequestProcessor("Weblogic Driver Deployment", 1);
    private final WLDeploymentManager manager;
    private final FileFilter serverClasspathFilter;
    private static final FileFilter DEFAULT_CLASSPATH_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".jar");
        }
    };

    public WLDriverDeployer(WLDeploymentManager manager) {
        this.manager = manager;
        this.serverClasspathFilter = DEFAULT_CLASSPATH_FILTER;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        return true;
    }

    public ProgressObject deployJDBCDrivers(Target target, final Set<Datasource> datasources) {
        final WLProgressObject progress = new WLProgressObject(new TargetModuleID[0]);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_CheckingMissingDrivers")));
        DRIVER_DEPLOYMENT_RP.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List jdbcDriverURLs = WLDriverDeployer.this.jdbcDriversToDeploy(datasources);
                if (!jdbcDriverURLs.isEmpty()) {
                    File libsDir = WLPluginProperties.getDomainLibDirectory(WLDriverDeployer.this.manager);
                    if (libsDir == null) {
                        LOGGER.log(Level.FINE, "No domain lib, using server lib for {0}", WLDriverDeployer.this.manager.getUri());
                        libsDir = WLPluginProperties.getServerLibDirectory(WLDriverDeployer.this.manager, false);
                    }
                    if (libsDir != null) {
                        for (FileObject file : jdbcDriverURLs) {
                            File toJar = new File(libsDir, file.getNameExt());
                            try {
                                BufferedInputStream is = new BufferedInputStream(file.getInputStream());
                                try {
                                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_DeployingJDBCDrivers", (Object)toJar.getPath())));
                                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(toJar));
                                    try {
                                        FileUtil.copy((InputStream)is, (OutputStream)os);
                                    }
                                    finally {
                                        os.close();
                                    }
                                }
                                finally {
                                    is.close();
                                }
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.INFO, null, e);
                                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)toJar.getPath(), (Object)libsDir.getPath())));
                                return;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "Restart flag configured");
                    WLDriverDeployer.this.manager.setRestartNeeded(true);
                }
                progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(WLDriverDeployer.class, (String)"MSG_JDBCDriversDeployed")));
            }
        });
        return progress;
    }

    private List<FileObject> jdbcDriversToDeploy(Set<Datasource> datasources) {
        ArrayList<FileObject> jdbcDriverFiles = new ArrayList<FileObject>();
        Collection<File> driverCP = this.getJDBCDriverClasspath();
        for (Datasource datasource : datasources) {
            String className = datasource.getDriverClassName();
            boolean exists = false;
            try {
                exists = Util.containsClass(driverCP, (String)className);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
            if (exists) continue;
            for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                JDBCDriver[] jdbcDrivers;
                JDBCDriver connDriver = databaseConnection.getJDBCDriver();
                if (connDriver != null) {
                    jdbcDrivers = new JDBCDriver[]{connDriver};
                } else {
                    String driverClass = databaseConnection.getDriverClass();
                    jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                }
                for (JDBCDriver jdbcDriver : jdbcDrivers) {
                    for (URL url : jdbcDriver.getURLs()) {
                        FileObject file = URLMapper.findFileObject((URL)url);
                        if (file == null) continue;
                        jdbcDriverFiles.add(file);
                    }
                }
            }
        }
        return jdbcDriverFiles;
    }

    private Collection<File> getJDBCDriverClasspath() {
        File[] files;
        File serverLib;
        File[] files2;
        ArrayList<File> cp = new ArrayList<File>();
        File domainLib = WLPluginProperties.getDomainLibDirectory(this.manager);
        if (domainLib != null && (files2 = domainLib.listFiles(DEFAULT_CLASSPATH_FILTER)) != null) {
            cp.addAll(Arrays.asList(files2));
        }
        if ((serverLib = WLPluginProperties.getServerLibDirectory(this.manager, false)) != null && (files = serverLib.listFiles(this.serverClasspathFilter)) != null) {
            cp.addAll(Arrays.asList(files));
        }
        return cp;
    }
}

