/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.dd.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.EarApplicationModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.QueueType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.TopicType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WeblogicJms;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class MessageModel
extends BaseDescriptorModel {
    private final WeblogicJms bean;

    private MessageModel(WeblogicJms bean) {
        super(bean);
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageModel forFile(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            MessageModel messageModel = MessageModel.forInputStream(is);
            return messageModel;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static MessageModel forInputStream(InputStream is) throws IOException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)NullEntityResolver.newInstance());
            doc = builder.parse(is);
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(EarApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(EarApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        return new MessageModel(org.netbeans.modules.j2ee.weblogic9.dd.jms1031.WeblogicJms.createGraph(doc));
    }

    public static MessageModel generate(@NullAllowed Version serverVersion) {
        return MessageModel.generate1031();
    }

    public List<MessageDestination> getMessageDestinations(MessageDestination.Type type, boolean includeLocal) {
        ArrayList<MessageDestination> ret = new ArrayList<MessageDestination>();
        switch (type) {
            case QUEUE: {
                for (QueueType qType : this.bean.getQueue()) {
                    String jndiName = qType.getJndiName();
                    if (jndiName == null && includeLocal) {
                        jndiName = qType.getLocalJndiName();
                    }
                    if (jndiName == null) continue;
                    MessageDestination element = new MessageDestination(qType.getName(), jndiName, type);
                    ret.add(element);
                }
                break;
            }
            case TOPIC: {
                for (TopicType tType : this.bean.getTopic()) {
                    String jndiName = tType.getJndiName();
                    if (jndiName == null && includeLocal) {
                        jndiName = tType.getLocalJndiName();
                    }
                    if (jndiName == null) continue;
                    MessageDestination element = new MessageDestination(tType.getName(), tType.getJndiName(), type);
                    ret.add(element);
                }
                break;
            }
        }
        return ret;
    }

    public void addMessageDestination(MessageDestination destination) {
        switch (destination.getType()) {
            case QUEUE: {
                QueueType qType = this.bean.addQueue();
                qType.setName(destination.getResourceName());
                qType.setJndiName(destination.getJndiName());
                break;
            }
            case TOPIC: {
                TopicType tType = this.bean.addTopic();
                tType.setName(destination.getResourceName());
                tType.setJndiName(destination.getJndiName());
                break;
            }
        }
    }

    private static MessageModel generate1031() {
        org.netbeans.modules.j2ee.weblogic9.dd.jms1031.WeblogicJms webLogicJms = new org.netbeans.modules.j2ee.weblogic9.dd.jms1031.WeblogicJms();
        webLogicJms.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicJms.setAttributeValue("xsi:schemaLocation", "http://xmlns.oracle.com/weblogic/weblogic-jms http://xmlns.oracle.com/weblogic/weblogic-jms/1.0/weblogic-jms.xsd");
        return new MessageModel(webLogicJms);
    }

    public static class MessageDestination {
        private final String resourceName;
        private final String jndiName;
        private final MessageDestination.Type type;

        public MessageDestination(String resourceName, String jndiName, MessageDestination.Type type) {
            this.resourceName = resourceName;
            this.jndiName = jndiName;
            this.type = type;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public MessageDestination.Type getType() {
            return this.type;
        }
    }
}

