/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.dd.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WeblogicApplication;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class EarApplicationModel
extends BaseDescriptorModel {
    private final WeblogicApplication bean;

    private EarApplicationModel(WeblogicApplication bean) {
        super(bean);
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EarApplicationModel forFile(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            EarApplicationModel earApplicationModel = EarApplicationModel.forInputStream(is);
            return earApplicationModel;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static EarApplicationModel forInputStream(InputStream is) throws IOException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)NullEntityResolver.newInstance());
            doc = builder.parse(is);
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(EarApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(EarApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://xmlns.oracle.com/weblogic/weblogic-application".equals(ns)) {
            return new EarApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.ear1031.WeblogicApplication.createGraph(doc));
        }
        if ("http://www.bea.com/ns/weblogic/weblogic-application".equals(ns)) {
            return new EarApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.ear1030.WeblogicApplication.createGraph(doc));
        }
        return new EarApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.ear90.WeblogicApplication.createGraph(doc));
    }

    public static EarApplicationModel generate(@NullAllowed Version serverVersion) {
        if (serverVersion != null) {
            if (serverVersion.isAboveOrEqual(VERSION_10_3_1)) {
                return EarApplicationModel.generate1031();
            }
            if (serverVersion.isAboveOrEqual(VERSION_10_3_0)) {
                return EarApplicationModel.generate1030();
            }
        }
        return EarApplicationModel.generate90();
    }

    private static EarApplicationModel generate90() {
        org.netbeans.modules.j2ee.weblogic9.dd.ear90.WeblogicApplication webLogicApplication = new org.netbeans.modules.j2ee.weblogic9.dd.ear90.WeblogicApplication();
        webLogicApplication.createAttribute("xmlns:j2ee", "xmlns:j2ee", 513, null, null);
        webLogicApplication.setAttributeValue("xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        webLogicApplication.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicApplication.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/90 http://www.bea.com/ns/weblogic/90/weblogic-application.xsd");
        return new EarApplicationModel(webLogicApplication);
    }

    private static EarApplicationModel generate1030() {
        org.netbeans.modules.j2ee.weblogic9.dd.ear1030.WeblogicApplication webLogicApplication = new org.netbeans.modules.j2ee.weblogic9.dd.ear1030.WeblogicApplication();
        webLogicApplication.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicApplication.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/weblogic-application http://www.bea.com/ns/weblogic/weblogic-application/1.0/weblogic-application.xsd");
        return new EarApplicationModel(webLogicApplication);
    }

    private static EarApplicationModel generate1031() {
        org.netbeans.modules.j2ee.weblogic9.dd.ear1031.WeblogicApplication webLogicApplication = new org.netbeans.modules.j2ee.weblogic9.dd.ear1031.WeblogicApplication();
        webLogicApplication.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicApplication.setAttributeValue("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/javaee_5.xsd http://xmlns.oracle.com/weblogic/weblogic-application http://xmlns.oracle.com/weblogic/weblogic-application/1.0/weblogic-application.xsd");
        return new EarApplicationModel(webLogicApplication);
    }
}

