/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.profiler.RunCheckerImpl;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MavenProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private final Set<String> supportedPTypes = new HashSet<String>(){
        {
            this.add("jar");
            this.add("war");
            this.add("ejb");
            this.add("nbm");
            this.add("nbm-application");
            this.add("bundle");
        }
    };

    public JavaPlatform getProjectJavaPlatform() {
        return JavaPlatform.getDefaultPlatform();
    }

    public boolean isProfilingSupported() {
        NbMavenProject mproject = (NbMavenProject)this.getProject().getLookup().lookup(NbMavenProject.class);
        return mproject == null ? false : this.supportedPTypes.contains(mproject.getPackagingType());
    }

    public boolean checkProjectIsModifiedForProfiler() {
        return true;
    }

    public boolean startProfilingSession(final FileObject profiledClassFile, final boolean isTest, final Properties properties) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MavenProjectProfilingSupportProvider.this.startMaven((Project)MavenProjectProfilingSupportProvider.this.getProject().getLookup().lookup(Project.class), profiledClassFile, isTest, properties);
            }
        });
        return true;
    }

    private void startMaven(Project project, FileObject profiledClassFile, boolean isTest, Properties properties) {
        ProfilingSettings lastProfilingSettings = new ProfilingSettings();
        SessionSettings lastSessionSettings = new SessionSettings();
        Properties lastSessionProperties = new Properties(properties);
        lastProfilingSettings.load((Map)properties);
        lastSessionSettings.load((Map)properties);
        RunCheckerImpl.configureProject(project, lastSessionProperties, lastProfilingSettings, lastSessionSettings);
        NetBeansProfiler.getDefaultNB().setProfiledProject((Lookup.Provider)project, profiledClassFile);
        String packaging = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
        if (profiledClassFile != null) {
            ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : (packaging.equals("war") ? "profile-single.deploy" : "profile-single")));
        } else {
            ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : "profile"));
        }
    }

    public MavenProjectProfilingSupportProvider(Project project) {
        super(project);
    }
}

