/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.FixLibDeclaration;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LibraryDeclarationChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext context) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        this.checkLibraryDeclarations(hints, context);
        return hints;
    }

    private void checkLibraryDeclarations(final List<Hint> hints, final RuleContext context) {
        final HtmlParserResult result = (HtmlParserResult)context.parserResult;
        final Snapshot snapshot = result.getSnapshot();
        Set declaredNamespaces = result.getNamespaces().keySet();
        final ArrayList<AbstractFaceletsLibrary> declaredLibraries = new ArrayList<AbstractFaceletsLibrary>();
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        Map<Object, Object> libs = Collections.emptyMap();
        if (jsfSupport != null) {
            libs = jsfSupport.getLibraries();
        }
        final HashMap namespace2Attribute = new HashMap();
        AstNode root = result.root();
        final Document doc = snapshot.getSource().getDocument(true);
        if (doc == null) {
            return;
        }
        final AtomicReference docTextRef = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    docTextRef.set(doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        final String docText = (String)docTextRef.get();
        AstNodeVisitor namespacesCollector = new AstNodeVisitor(){

            public void visit(AstNode node) {
                Collection nsAttrs = node.getAttributes(new AstNode.AttributeFilter(){

                    public boolean accepts(AstNode.Attribute attribute) {
                        return "xmlns".equals(attribute.namespacePrefix());
                    }
                });
                for (AstNode.Attribute attr : nsAttrs) {
                    namespace2Attribute.put(attr.unquotedValue(), attr);
                }
            }
        };
        AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)namespacesCollector, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
        AstNode undeclaredComponentsTreeRoot = result.rootOfUndeclaredTagsParseTree();
        if (undeclaredComponentsTreeRoot != null) {
            AstNodeUtils.visitChildren((AstNode)undeclaredComponentsTreeRoot, (AstNodeVisitor)namespacesCollector, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
            AstNodeUtils.visitChildren((AstNode)undeclaredComponentsTreeRoot, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode node) {
                    if (node.type() == AstNode.NodeType.OPEN_TAG && node.getNamespacePrefix() != null) {
                        ArrayList<FixLibDeclaration> fixes = new ArrayList<FixLibDeclaration>();
                        List libs = LibraryDeclarationChecker.getLibsByPrefix(context, node.getNamespacePrefix());
                        for (AbstractFaceletsLibrary lib : libs) {
                            FixLibDeclaration fix = new FixLibDeclaration((Document)context.doc, node.getNamespacePrefix(), lib);
                            fixes.add(fix);
                        }
                        Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT"), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.startOffset(), node.startOffset() + node.name().length() + 1), fixes, 50);
                        hints.add(hint);
                    }
                }
            });
        }
        for (String namespace : declaredNamespaces) {
            AbstractFaceletsLibrary lib = (AbstractFaceletsLibrary)libs.get(namespace);
            if (lib != null) {
                declaredLibraries.add(lib);
                continue;
            }
            AstNode.Attribute attr = (AstNode.Attribute)namespace2Attribute.get(namespace);
            if (attr == null) continue;
            Hint hint = new Hint((Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_LIBRARY"), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, attr.nameOffset(), attr.valueOffset() + attr.value().length()), Collections.emptyList(), 50);
            hints.add(hint);
        }
        final ArrayList<PositionRange> ranges = new ArrayList<PositionRange>();
        context.doc.render(new Runnable(){

            @Override
            public void run() {
                for (AbstractFaceletsLibrary lib : declaredLibraries) {
                    AstNode.Attribute declAttr;
                    AstNode rootNode = result.root(lib.getNamespace());
                    if (rootNode == null) continue;
                    final int[] usages = new int[1];
                    AstNodeUtils.visitChildren((AstNode)rootNode, (AstNodeVisitor)new AstNodeVisitor(){

                        public void visit(AstNode node) {
                            usages[0] = usages[0] + 1;
                        }
                    }, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
                    usages[0] = usages[0] + (LibraryDeclarationChecker.this.isFunctionLibraryPrefixUsedInEL(context, lib) ? 1 : 0);
                    if (usages[0] != 0 || (declAttr = (AstNode.Attribute)namespace2Attribute.get(lib.getNamespace())) == null) continue;
                    int from = declAttr.nameOffset();
                    int to = declAttr.valueOffset() + declAttr.value().length();
                    try {
                        ranges.add(new PositionRange(context, from, to));
                    }
                    catch (BadLocationException ex) {}
                }
            }
        });
        for (PositionRange range : ranges) {
            int from = range.getFrom();
            int to = range.getTo();
            List<HintFix> fixes = Arrays.asList(new RemoveUnusedLibraryDeclarationHintFix(context.doc, range), new RemoveUnusedLibrariesDeclarationHintFix(context.doc, ranges));
            Hint hint = new Hint((Rule)DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNUSED_LIBRARY_DECLARATION"), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, from, to), fixes, 50);
            hints.add(hint);
        }
    }

    private static List<AbstractFaceletsLibrary> getLibsByPrefix(RuleContext context, String prefix) {
        ArrayList<AbstractFaceletsLibrary> libs = new ArrayList<AbstractFaceletsLibrary>();
        JsfSupportImpl sup = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        if (sup != null) {
            for (AbstractFaceletsLibrary lib : new HashSet<AbstractFaceletsLibrary>(sup.getLibraries().values())) {
                if (!prefix.equals(lib.getDefaultPrefix())) continue;
                libs.add(lib);
            }
        }
        return libs;
    }

    private boolean isFunctionLibraryPrefixUsedInEL(RuleContext context, AbstractFaceletsLibrary lib) {
        String libraryPrefix = (String)((HtmlParserResult)context.parserResult).getNamespaces().get(lib.getNamespace());
        BaseDocument doc = context.doc;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.moveStart();
        while (ts.moveNext()) {
            TokenSequence elts = ts.embeddedJoined(ELTokenId.language());
            if (elts == null) continue;
            elts.moveStart();
            while (elts.moveNext()) {
                if (elts.token().id() != ELTokenId.TAG_LIB_PREFIX || !CharSequenceUtilities.equals((CharSequence)libraryPrefix, (Object)elts.token().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static final class PositionRange {
        private Position from;
        private Position to;

        public PositionRange(RuleContext context, int from, int to) throws BadLocationException {
            Snapshot snapshot = context.parserResult.getSnapshot();
            this.from = context.doc.createPosition(snapshot.getOriginalOffset(from));
            this.to = context.doc.createPosition(snapshot.getOriginalOffset(to));
        }

        public int getFrom() {
            return this.from.getOffset();
        }

        public int getTo() {
            return this.to.getOffset();
        }
    }

    private static class RemoveUnusedLibrariesDeclarationHintFix
    implements HintFix {
        protected Collection<PositionRange> ranges = new ArrayList<PositionRange>();
        protected BaseDocument document;

        public RemoveUnusedLibrariesDeclarationHintFix(BaseDocument document, Collection<PositionRange> ranges) {
            this.document = document;
            this.ranges = ranges;
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_ALL_UNUSED_LIBRARIES_DECLARATION");
        }

        public void implement() throws Exception {
            this.document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PositionRange range : RemoveUnusedLibrariesDeclarationHintFix.this.ranges) {
                            int firstNonWhite;
                            int from = range.getFrom();
                            int to = range.getTo();
                            int lineBeginning = Utilities.getRowStart((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)from);
                            if (lineBeginning > (firstNonWhite = Utilities.getFirstNonWhiteBwd((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)from))) {
                                from = lineBeginning - 1;
                            }
                            RemoveUnusedLibrariesDeclarationHintFix.this.document.remove(from, to - from);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveUnusedLibraryDeclarationHintFix
    extends RemoveUnusedLibrariesDeclarationHintFix {
        public RemoveUnusedLibraryDeclarationHintFix(BaseDocument document, PositionRange range) {
            super(document, Collections.singletonList(range));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_UNUSED_LIBRARY_DECLARATION");
        }
    }
}

