/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.nbform.palette.AddToPaletteWizard;
import org.netbeans.modules.nbform.palette.BeanInstaller;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbCollections;

class ChooseBeansWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private List<? extends ClassSource.Entry> currentFiles;
    private List<BeanInstaller.ItemInfo> markedBeans;
    private List<BeanInstaller.ItemInfo> allBeans;
    private Class<? extends ClassSource.Entry> sourceType;
    private BeanSelector beanSelector;
    private JLabel noBeansLabel;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseBeansWizardPanel() {
    }

    public Component getComponent() {
        if (this.markedBeans == null && (this.allBeans == null || this.allBeans.isEmpty())) {
            String messageKey;
            if (this.sourceType == ClassSourceResolver.JarEntry.class) {
                messageKey = "MSG_NoBeanInJAR";
            } else if (this.sourceType == ClassSourceResolver.LibraryEntry.class) {
                messageKey = "MSG_NoBeanInLibrary";
            } else if (this.sourceType == ClassSourceResolver.ProjectEntry.class) {
                messageKey = "MSG_NoBeanInProject";
            } else {
                throw new IllegalArgumentException();
            }
            this.noBeansLabel = new JLabel(PaletteUtils.getBundleString((String)messageKey));
            this.noBeansLabel.setPreferredSize(new Dimension(400, 300));
            this.noBeansLabel.setVerticalAlignment(1);
            this.noBeansLabel.setName(PaletteUtils.getBundleString((String)"CTL_NoBeans_Caption"));
            this.noBeansLabel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            return this.noBeansLabel;
        }
        if (this.beanSelector == null) {
            this.beanSelector = new BeanSelector();
            this.beanSelector.setName(PaletteUtils.getBundleString((String)"CTL_SelectBeans_Caption"));
            this.beanSelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.markedBeans != null || this.allBeans != null) {
                this.beanSelector.setBeans(this.markedBeans, this.allBeans);
            }
            Listener listener = new Listener();
            this.beanSelector.list.addListSelectionListener(listener);
            this.beanSelector.radio1.addActionListener(listener);
            this.beanSelector.radio2.addActionListener(listener);
        }
        return this.beanSelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.beanSelector != null && this.beanSelector.getSelectedBeans().size() > 0;
    }

    public void readSettings(AddToPaletteWizard wizard) {
        this.sourceType = wizard.getSourceType();
        List<? extends ClassSource.Entry> jarFiles = wizard.getJARFiles();
        if (((Object)jarFiles).equals(this.currentFiles)) {
            return;
        }
        this.currentFiles = jarFiles;
        this.allBeans = null;
        this.markedBeans = BeanInstaller.findJavaBeansInJar(jarFiles);
        if (this.markedBeans != null) {
            Collections.sort(this.markedBeans);
        } else {
            this.allBeans = BeanInstaller.findJavaBeans(jarFiles);
            Collections.sort(this.allBeans);
        }
        if (this.beanSelector != null) {
            this.beanSelector.setBeans(this.markedBeans, this.allBeans);
        }
    }

    public void storeSettings(AddToPaletteWizard settings) {
        if (this.beanSelector != null) {
            List<BeanInstaller.ItemInfo> itemList = this.beanSelector.getSelectedBeans();
            BeanInstaller.ItemInfo[] itemArray = new BeanInstaller.ItemInfo[itemList.size()];
            itemList.toArray(itemArray);
            settings.setSelectedBeans(itemArray);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    class Listener
    implements ListSelectionListener,
    ActionListener {
        Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ChooseBeansWizardPanel.this.cs.fireChange();
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if ("SHOW MARKED".equals(ev.getActionCommand())) {
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.markedBeans);
            } else if ("SHOW ALL".equals(ev.getActionCommand())) {
                if (ChooseBeansWizardPanel.this.allBeans == null) {
                    ChooseBeansWizardPanel.this.allBeans = BeanInstaller.findJavaBeans(ChooseBeansWizardPanel.this.currentFiles);
                    Collections.sort(ChooseBeansWizardPanel.this.allBeans);
                }
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.allBeans);
            }
        }
    }

    private static class ItemInfoRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public ItemInfoRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name = ((BeanInstaller.ItemInfo)value).classname;
            this.setToolTipText(name);
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            this.setText(name);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    static class BeanSelector
    extends JPanel {
        JList list;
        JRadioButton radio1;
        JRadioButton radio2;

        BeanSelector() {
            this.setLayout(new GridBagLayout());
            JLabel label1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label1, (String)PaletteUtils.getBundleString((String)"CTL_SelectBeans"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)label1, gridBagConstraints);
            this.list = new JList();
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.list.setCellRenderer(new ItemInfoRenderer());
            this.list.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString((String)"ACSD_CTL_SelectBeans"));
            label1.setLabelFor(this.list);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)scrollPane, gridBagConstraints);
            this.radio1 = new JRadioButton();
            this.radio1.setActionCommand("SHOW MARKED");
            Mnemonics.setLocalizedText((AbstractButton)this.radio1, (String)PaletteUtils.getBundleString((String)"CTL_ShowMarked"));
            this.radio1.setToolTipText(PaletteUtils.getBundleString((String)"HINT_ShowMarked"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio1, gridBagConstraints);
            this.radio2 = new JRadioButton();
            this.radio2.setActionCommand("SHOW ALL");
            Mnemonics.setLocalizedText((AbstractButton)this.radio2, (String)PaletteUtils.getBundleString((String)"CTL_ShowAllClasses"));
            this.radio2.setToolTipText(PaletteUtils.getBundleString((String)"HINT_ShowAllClasses"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio2, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString((String)"ACSD_SelectBeansDialog"));
        }

        void setBeans(List<BeanInstaller.ItemInfo> markedBeans, List<BeanInstaller.ItemInfo> allBeans) {
            if (markedBeans == null) {
                this.radio1.setEnabled(false);
            } else {
                this.radio1.setEnabled(true);
                this.radio1.setSelected(true);
                this.setDisplayedBeans(markedBeans);
            }
            if (allBeans != null && markedBeans == null) {
                this.radio2.setSelected(true);
                this.setDisplayedBeans(allBeans);
            }
        }

        void setDisplayedBeans(final List<BeanInstaller.ItemInfo> beans) {
            this.list.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return beans.size();
                }

                @Override
                public Object getElementAt(int i) {
                    return beans.get(i);
                }
            });
        }

        List<BeanInstaller.ItemInfo> getSelectedBeans() {
            return NbCollections.checkedListByCopy(Arrays.asList(this.list.getSelectedValues()), BeanInstaller.ItemInfo.class, (boolean)true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

