/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform.palette;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.nbform.palette.AddToPaletteWizard;
import org.netbeans.modules.nbform.palette.CategorySelector;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class BeanInstaller {
    private static Reference<AddToPaletteWizard> wizardRef;

    private BeanInstaller() {
    }

    public static void installBeans(Class<? extends ClassSource.Entry> sourceType) {
        AddToPaletteWizard wizard = BeanInstaller.getAddWizard();
        if (wizard.show(sourceType)) {
            BeanInstaller.createPaletteItems(wizard.getSelectedBeans(), wizard.getSelectedCategory());
        }
    }

    public static void installBeans(Node[] nodes) {
        final LinkedList beans = new LinkedList();
        final LinkedList unableToInstall = new LinkedList();
        final LinkedList noBeans = new LinkedList();
        for (int i = 0; i < nodes.length; ++i) {
            DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
            if (dobj == null) continue;
            final FileObject fo = dobj.getPrimaryFile();
            JavaClassHandler handler = new JavaClassHandler(){

                @Override
                public void handle(String className, String problem) {
                    if (problem == null) {
                        ClassSource classSource = BeanInstaller.getProjectClassSource(fo, className);
                        if (classSource == null) {
                            unableToInstall.add(className);
                        } else {
                            beans.add(classSource);
                        }
                    } else {
                        noBeans.add(className);
                        noBeans.add(problem);
                    }
                }
            };
            BeanInstaller.scanFileObject(fo.getParent(), fo, handler);
        }
        if (unableToInstall.size() > 0) {
            Iterator iter = unableToInstall.iterator();
            StringBuilder sb = new StringBuilder();
            while (iter.hasNext()) {
                sb.append(iter.next()).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            String messageFormat = PaletteUtils.getBundleString((String)"MSG_cannotInstallBeans");
            String message = MessageFormat.format(messageFormat, sb.toString());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (beans.isEmpty()) {
                return;
            }
        }
        String message = null;
        if (beans.isEmpty()) {
            message = PaletteUtils.getBundleString((String)"MSG_noBeansUnderNodes");
        }
        if (!noBeans.isEmpty()) {
            Iterator iter = noBeans.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                String format = (String)iter.next();
                String msg = MessageFormat.format(format, className);
                message = message != null ? message + '\n' : "";
                message = message + msg;
            }
        }
        if (message != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        if (beans.isEmpty()) {
            return;
        }
        String category = CategorySelector.selectCategory();
        if (category == null) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() {
                    for (ClassSource classSource : beans) {
                        try {
                            PaletteItemDataObject.createFile((FileObject)categoryFolder, (ClassSource)classSource);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static ClassSource getProjectClassSource(FileObject fileInProject, String className) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (project == null) {
            return null;
        }
        ClassSourceResolver.ProjectEntry entry = new ClassSourceResolver.ProjectEntry(project);
        return new ClassSource(className, new ClassSource.Entry[]{entry});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ItemInfo> findJavaBeansInJar(List<? extends ClassSource.Entry> entries) {
        HashMap<String, ItemInfo> beans = null;
        for (ClassSource.Entry entry : entries) {
            for (URL root : entry.getClasspath()) {
                Manifest mf;
                File jarF;
                FileObject jarFO;
                URL jarU = FileUtil.getArchiveFile((URL)root);
                if (jarU == null || (jarFO = URLMapper.findFileObject((URL)jarU)) == null || (jarF = FileUtil.toFile((FileObject)jarFO)) == null) continue;
                try {
                    JarFile jf = new JarFile(jarF);
                    try {
                        mf = jf.getManifest();
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                    continue;
                }
                if (mf == null) continue;
                for (Map.Entry<String, Attributes> section : mf.getEntries().entrySet()) {
                    String value;
                    if (!section.getKey().endsWith(".class") || !"True".equalsIgnoreCase(value = section.getValue().getValue("Java-Bean"))) continue;
                    String classname = section.getKey().substring(0, section.getKey().length() - 6).replace('\\', '/').replace('/', '.');
                    if (classname.startsWith(".")) {
                        classname = classname.substring(1);
                    }
                    ItemInfo ii = new ItemInfo();
                    ii.classname = classname;
                    ii.entry = entry;
                    if (beans == null) {
                        beans = new HashMap<String, ItemInfo>(100);
                    }
                    beans.put(ii.classname, ii);
                }
            }
        }
        return beans != null ? new ArrayList(beans.values()) : null;
    }

    static List<ItemInfo> findJavaBeans(List<? extends ClassSource.Entry> entries) {
        HashMap<String, ItemInfo> beans = new HashMap<String, ItemInfo>(100);
        for (ClassSource.Entry entry : entries) {
            for (URL root : entry.getClasspath()) {
                FileObject foRoot = URLMapper.findFileObject((URL)root);
                if (foRoot == null) continue;
                BeanInstaller.scanFolderForBeans(foRoot, beans, entry);
            }
        }
        return new ArrayList<ItemInfo>(beans.values());
    }

    private static void createPaletteItems(final ItemInfo[] beans, String category) {
        if (beans.length == 0) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        if (categoryFolder == null) {
            return;
        }
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() {
                    for (int i = 0; i < beans.length; ++i) {
                        try {
                            PaletteItemDataObject.createFile((FileObject)categoryFolder, (ClassSource)new ClassSource(beans[i].classname, new ClassSource.Entry[]{beans[i].entry}));
                            continue;
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void scanFolderForBeans(FileObject folder, final Map<String, ItemInfo> beans, final ClassSource.Entry root) {
        JavaClassHandler handler = new JavaClassHandler(){

            @Override
            public void handle(String className, String problem) {
                if (problem == null) {
                    ItemInfo ii = new ItemInfo();
                    ii.classname = className;
                    ii.entry = root;
                    beans.put(ii.classname, ii);
                }
            }
        };
        FileObject[] files = folder.getChildren();
        for (int i = 0; i < files.length; ++i) {
            FileObject fo = files[i];
            if (fo.isFolder()) {
                BeanInstaller.scanFolderForBeans(fo, beans, root);
                continue;
            }
            try {
                if (!"class".equals(fo.getExt()) || DataObject.find((FileObject)fo) == null) continue;
                BeanInstaller.scanFileObject(folder, fo, handler);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    private static void scanFileObject(FileObject folder, FileObject fileObject, JavaClassHandler handler) {
        if ("class".equals(fileObject.getExt())) {
            BeanInstaller.processClassFile(fileObject, handler);
        } else if ("java".equals(fileObject.getExt())) {
            BeanInstaller.processJavaFile(fileObject, handler);
        }
    }

    public static String findJavaBeanName(FileObject file) {
        final String[] fqn = new String[1];
        BeanInstaller.scanFileObject(null, file, new JavaClassHandler(){

            @Override
            public void handle(String className, String problem) {
                if (problem == null) {
                    fqn[0] = className;
                }
            }
        });
        return fqn[0];
    }

    private static void processJavaFile(final FileObject javaFO, final JavaClassHandler handler) {
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)javaFO);
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ctrl) throws Exception {
                    ctrl.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement clazz = BeanInstaller.findClass(ctrl, javaFO.getName());
                    if (clazz != null) {
                        handler.handle(clazz.getQualifiedName().toString(), BeanInstaller.isDeclaredAsJavaBean(clazz));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, javaFO.toString(), ex);
        }
    }

    private static TypeElement findClass(CompilationController ctrl, String className) {
        for (Tree tree : ctrl.getCompilationUnit().getTypeDecls()) {
            if (!className.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            TreePath path = ctrl.getTrees().getPath(ctrl.getCompilationUnit(), tree);
            TypeElement clazz = (TypeElement)ctrl.getTrees().getElement(path);
            return clazz;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassFile(FileObject classFO, JavaClassHandler handler) {
        try {
            ClassFile clazz;
            InputStream is = null;
            try {
                is = classFO.getInputStream();
                clazz = new ClassFile(is, false);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (clazz != null) {
                handler.handle(clazz.getName().getExternalName(), BeanInstaller.isDeclaredAsJavaBean(clazz));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BeanInstaller.class.getClass().getName()).log(Level.SEVERE, classFO.toString(), ex);
        }
    }

    public static String isDeclaredAsJavaBean(TypeElement clazz) {
        if (ElementKind.CLASS != clazz.getKind()) {
            return PaletteUtils.getBundleString((String)"MSG_notAClass");
        }
        Set<javax.lang.model.element.Modifier> mods = clazz.getModifiers();
        if (mods.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return PaletteUtils.getBundleString((String)"MSG_abstractClass");
        }
        if (!mods.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            return PaletteUtils.getBundleString((String)"MSG_notPublic");
        }
        for (Element element : clazz.getEnclosedElements()) {
            mods = element.getModifiers();
            if (ElementKind.CONSTRUCTOR != element.getKind() || !mods.contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return null;
        }
        return PaletteUtils.getBundleString((String)"MSG_noPublicConstructor");
    }

    public static String isDeclaredAsJavaBean(ClassFile clazz) {
        int access = clazz.getAccess();
        if (Modifier.isInterface(access) || clazz.isAnnotation() || clazz.isEnum() || clazz.isSynthetic()) {
            return PaletteUtils.getBundleString((String)"MSG_notAClass");
        }
        if (Modifier.isAbstract(access)) {
            return PaletteUtils.getBundleString((String)"MSG_abstractClass");
        }
        if (!Modifier.isPublic(access)) {
            return PaletteUtils.getBundleString((String)"MSG_notPublic");
        }
        for (Method omethod : clazz.getMethods()) {
            Method method = omethod;
            if (!method.isPublic() || !method.getParameters().isEmpty() || !"<init>".equals(method.getName())) continue;
            return null;
        }
        return PaletteUtils.getBundleString((String)"MSG_noPublicConstructor");
    }

    private static AddToPaletteWizard getAddWizard() {
        AddToPaletteWizard wizard = null;
        if (wizardRef != null) {
            wizard = wizardRef.get();
        }
        if (wizard == null) {
            wizard = new AddToPaletteWizard();
            wizardRef = new WeakReference<AddToPaletteWizard>(wizard);
        }
        return wizard;
    }

    private static interface JavaClassHandler {
        public void handle(String var1, String var2);
    }

    static class ItemInfo
    implements Comparable<ItemInfo> {
        String classname;
        ClassSource.Entry entry;

        ItemInfo() {
        }

        @Override
        public int compareTo(ItemInfo ii) {
            int i = this.classname.lastIndexOf(46);
            String name1 = i >= 0 ? this.classname.substring(i + 1) : this.classname;
            i = ii.classname.lastIndexOf(46);
            String name2 = i >= 0 ? ii.classname.substring(i + 1) : ii.classname;
            return name1.compareTo(name2);
        }
    }
}

