/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

public class UnitOfWorkIdentityMapAccessor
extends IdentityMapAccessor {
    public UnitOfWorkIdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public void clearQueryCache() {
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessor().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery query) {
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessor().clearQueryCache(query);
    }

    public void clearQueryCache(String sessionQueryName) {
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getQuery(sessionQueryName));
    }

    public void clearQueryCache(String descriptorQueryName, Class queryClass) {
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getDescriptor(queryClass).getQueryManager().getQuery(descriptorQueryName));
    }

    public boolean containsObjectInIdentityMap(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor)) {
            return true;
        }
        return ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        return super.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Object getFromIdentityMapWithDeferredLock(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return super.getFromIdentityMapWithDeferredLock(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMap(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object objectFromCache = super.getFromIdentityMap(primaryKey, theClass, true, descriptor);
        if (objectFromCache != null) {
            return objectFromCache;
        }
        return this.getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAndCloneCacheKeyFromParent(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object unregisteredDeletedClone;
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
        IdentityMapAccessor parentIdentityMapAccessor = unitOfWork.getParentIdentityMapSession(descriptor, false, false).getIdentityMapAccessorInstance();
        CacheKey cacheKey = parentIdentityMapAccessor.getCacheKeyForObject(primaryKey, theClass, descriptor, false);
        if (cacheKey == null && unitOfWork.getParentIdentityMapSession(descriptor, false, false).isUnitOfWork()) {
            ((UnitOfWorkIdentityMapAccessor)parentIdentityMapAccessor).getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
            cacheKey = parentIdentityMapAccessor.getCacheKeyForObject(primaryKey, theClass, descriptor, false);
        }
        Object objectFromCache = null;
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            ConcurrencyManager concurrencyManager = cacheKey.getMutex();
            synchronized (concurrencyManager) {
                objectFromCache = cacheKey.getObject();
                try {
                    while (cacheKey.isAcquired() && objectFromCache == null) {
                        cacheKey.getMutex().wait(5L);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (objectFromCache == null) {
                    return null;
                }
            }
        }
        return null;
        if (this.session.isClassReadOnly(theClass, descriptor)) {
            return objectFromCache;
        }
        if (this.session instanceof RepeatableWriteUnitOfWork && (unregisteredDeletedClone = ((RepeatableWriteUnitOfWork)this.session).getUnregisteredDeletedCloneForOriginal(objectFromCache)) != null) {
            return unregisteredDeletedClone;
        }
        return unitOfWork.cloneAndRegisterObject(objectFromCache, cacheKey, descriptor);
    }

    public Object getQueryResult(ReadQuery query, List parameters, boolean checkExpiry) {
        return ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessorInstance().getQueryResult(query, parameters, checkExpiry);
    }

    public void putQueryResult(ReadQuery query, List parameters, Object results) {
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessorInstance().putQueryResult(query, parameters, results);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((UnitOfWorkImpl)this.session).getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

